/*
 * Copyright (c) 2010 Macrofocus GmbH. All Rights Reserved.
 */
package org.kamaeleo.palette

import com.macrofocus.common.collection.CollectionFactory

/**
 * This class provides a skeletal implementation of the MutablePalette interface to minimize the effort required to implement this interface.
 */
abstract class AbstractMutablePalette protected constructor() : AbstractPalette(), MutablePalette {
    private val _listeners: MutableList<PaletteListener>

    override var cycle: Palette.Cycle? = super.cycle
        get() = field
        set(cycle) {
            if (field != cycle) {
                field = cycle
                notifyPaletteChanged(PaletteEvent())
            }
        }

    override fun addPaletteListener(listener: PaletteListener) {
        _listeners.add(listener)
    }

    //    public void addWeakPaletteListener(final PaletteListener listener) {
    //        synchronized (_listeners) {
    //            _listeners.add(new WeakPaletteListener(listener));
    //        }
    //    }
    override fun removePaletteListener(listener: PaletteListener) {
//            if (listener instanceof WeakPaletteListener) {
//                final boolean removed = _listeners.remove(listener);
//                assert removed : listener;
//            } else {
            var toRemove: org.kamaeleo.palette.PaletteListener? = null
            for (PaletteListener in _listeners) {
                val comparable: org.kamaeleo.palette.PaletteListener
                //                    if (PaletteListener instanceof WeakPaletteListener) {
//                        comparable = ((WeakPaletteListener) PaletteListener).getReference();
//                    } else {
                comparable = PaletteListener
                //                    }
                if (listener.equals(comparable)) {
                    toRemove = PaletteListener
                }
            }
            if (toRemove != null) {
                val removed = _listeners.remove(toRemove)
            }
    }

    fun removePaletteListeners() {
        _listeners.clear()
    }

    protected fun notifyPaletteChanged(event: PaletteEvent) {
        for (listener in _listeners) {
            listener.paletteChanged(event)
        }
    } //    private class WeakPaletteListener implements PaletteListener {

    //        private final WeakReference<PaletteListener> l_ref;
    //
    //        public WeakPaletteListener(final PaletteListener listener) {
    //            this.l_ref = new WeakReference<PaletteListener>(listener);
    //        }
    //
    //        public void paletteChanged(final PaletteEvent event) {
    //            final PaletteListener l = getReference();
    //            if (l != null) {
    //                l.paletteChanged(event);
    //            } else {
    //                removePaletteListener(this);
    //            }
    //        }
    //
    //        public PaletteListener getReference() {
    //            return l_ref.get();
    //        }
    //    }
    init {
        _listeners = CollectionFactory.copyOnWriteArrayList<PaletteListener>();
    }
}