package org.kamaeleo.graphics

import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.geometry.Size
import androidx.compose.ui.graphics.Path
import androidx.compose.ui.graphics.drawscope.*
import org.kamaeleo.canvas.ComposeTextMetrics
import org.kamaeleo.color.CPColor
import org.kamaeleo.font.CPFont
import org.kamaeleo.text.CPTextMetrics
import java.awt.*
import java.awt.geom.*
import java.util.*

actual class CPGraphicsContext2D(private var gc: DrawScope) : GraphicsContext2D {
    private val stack = Stack<Graphics2D>()
    private var path: Path? = null
    private var fill: CPColor? = null
    private var stroke: CPColor? = null

    override fun getTextMetrics(text: String): CPTextMetrics {
        return ComposeTextMetrics(gc, text)
    }

    override fun drawGradient(color1: CPColor, color2: CPColor, x: Double, y: Double, w: Double, h: Double, isVertical: Boolean) {
        if (isVertical) {
//            val gradient = GradientPaint(0.0f, y.toFloat(), color1.nativeColor, 0.0f, (y + h).toFloat(), color2.nativeColor)
//            gc.paint = gradient
//            gc.fill(Rectangle2D.Double(x, y, w, h))
        } else {
//            val gradient = GradientPaint(x.toFloat(), 0.0f, color1.nativeColor, (x + w).toFloat(), 0.0f, color2.nativeColor)
//            gc.paint = gradient
//            gc.fill(Rectangle2D.Double(x, y, w, h))
        }
    }

    override fun save() {
//        stack.push(gc)
//        gc = gc.create() as Graphics2D
    }

    override fun restore() {
//        gc.dispose()
//        gc = stack.pop()
    }

    override fun translate(x: Double, y: Double) {
//       gc.translate(x.toFloat(), y.toFloat())
    }

    override fun scale(x: Double, y: Double) {
//        gc.scale(x.toFloat(), y.toFloat())
    }

    override fun rotate(degrees: Double) {
//        gc.rotate(degrees.toFloat())
    }

    override fun transform(mxx: Double, myx: Double, mxy: Double, myy: Double, mxt: Double, myt: Double) {
//        gc.transform(AffineTransform(mxx, myx, mxy, myy, mxt, myt))
    }

    override fun setTransform(mxx: Double, myx: Double, mxy: Double, myy: Double, mxt: Double, myt: Double) {
//        gc.transform = AffineTransform(mxx, myx, mxy, myy, mxt, myt)
    }

    override fun setGlobalAlpha(alpha: Double) {
//        gc.composite = AlphaComposite.getInstance(AlphaComposite.SRC_OVER, alpha.toFloat())
    }

//    @Override
//    public double getGlobalAlpha() {
//        return gc.getGlobalAlpha();
//    }

    //    @Override
    //    public double getGlobalAlpha() {
    //        return gc.getGlobalAlpha();
    //    }
    override fun setFill(p: CPColor) {
        fill = p
//        gc.color = p.nativeColor
    }

    //    @Override
//    public Color getFill() {
//        return (Color)gc.getFill();
//    }

    //    @Override
    //    public Color getFill() {
    //        return (Color)gc.getFill();
    //    }
    override fun setStroke(p: CPColor) {
        stroke = p
//        gc.color = p.nativeColor
    }

    //    @Override
//    public Color getStroke() {
//        return (Color)gc.getStroke();
//    }

    //    @Override
    //    public Color getStroke() {
    //        return (Color)gc.getStroke();
    //    }
    override fun setLineWidth(lw: Double) {
//        gc.stroke = BasicStroke(lw.toFloat())
    }

//    @Override
//    public double getLineWidth() {
//        return gc.getLineWidth();
//    }

//    @Override
//    public void setMiterLimit(double ml) {
//        gc.setMiterLimit(ml);
//    }

//    @Override
//    public double getMiterLimit() {
//        return gc.getMiterLimit();
//    }

//    @Override
//    public void setLineDashes(double... dashes) {
//        gc.setLineDashes(dashes);
//    }

//    @Override
//    public double[] getLineDashes() {
//        return gc.getLineDashes();
//    }

    //    @Override
//    public void setLineDashOffset(double dashOffset) {
//        gc.setLineDashOffset(dashOffset);
//    }

    //    @Override
//    public double getLineDashOffset() {
//        return gc.getLineDashOffset();
//    }

    //    @Override
    //    public double getLineWidth() {
    //        return gc.getLineWidth();
    //    }
    //    @Override
    //    public void setMiterLimit(double ml) {
    //        gc.setMiterLimit(ml);
    //    }
    //    @Override
    //    public double getMiterLimit() {
    //        return gc.getMiterLimit();
    //    }
    //    @Override
    //    public void setLineDashes(double... dashes) {
    //        gc.setLineDashes(dashes);
    //    }
    //    @Override
    //    public double[] getLineDashes() {
    //        return gc.getLineDashes();
    //    }
    //    @Override
    //    public void setLineDashOffset(double dashOffset) {
    //        gc.setLineDashOffset(dashOffset);
    //    }
    //    @Override
    //    public double getLineDashOffset() {
    //        return gc.getLineDashOffset();
    //    }
    //    @Override
    fun getFont(): Font? {
//        return gc.font
        return null
    }

    fun setFont(f: Font?) {
//        gc.font = f
    }

    override fun setFont(f: CPFont) {
//        gc.font = f.nativeFont
    }

    override fun fillText(text: String, x: Double, y: Double) {
//        gc.drawString(text, x.toFloat(), y.toFloat())
    }

//    @Override
//    public void strokeText(String text, double x, double y) {
//        gc.strokeText(text, x, y);
//    }

//    @Override
//    public void fillText(String text, double x, double y, double maxWidth) {
//        gc.fill(text, x, y, maxWidth);
//    }

//    @Override
//    public void strokeText(String text, double x, double y, double maxWidth) {
//        gc.drawString(text, x, y, maxWidth);
//    }

    //    @Override
    //    public void strokeText(String text, double x, double y) {
    //        gc.strokeText(text, x, y);
    //    }
    //    @Override
    //    public void fillText(String text, double x, double y, double maxWidth) {
    //        gc.fill(text, x, y, maxWidth);
    //    }
    //    @Override
    //    public void strokeText(String text, double x, double y, double maxWidth) {
    //        gc.drawString(text, x, y, maxWidth);
    //    }
    override fun beginPath() {
        path = Path()
    }

    override fun moveTo(x0: Double, y0: Double) {
        path!!.moveTo(x0.toFloat(), y0.toFloat())
    }

    override fun lineTo(x1: Double, y1: Double) {
        path!!.lineTo(x1.toFloat(), y1.toFloat())
    }

    override fun quadraticCurveTo(xc: Double, yc: Double, x1: Double, y1: Double) {
        path!!.quadraticBezierTo(xc.toFloat(), yc.toFloat(), x1.toFloat(), y1.toFloat())
    }

    override fun bezierCurveTo(xc1: Double, yc1: Double, xc2: Double, yc2: Double, x1: Double, y1: Double) {
        path!!.cubicTo(xc1.toFloat(), yc1.toFloat(), xc2.toFloat(), yc2.toFloat(), x1.toFloat(), y1.toFloat())
    }

//    @Override
//    public void arcTo(double x1, double y1, double x2, double y2, double radius) {
//        path.arcTo(x1, y1, x2, y2, radius);
//    }

//    @Override
//    public void arc(double centerX, double centerY, double radiusX, double radiusY, double startAngle, double length) {
//        gc.arc(centerX, centerY, radiusX, radiusY, startAngle, length);
//    }

    //    @Override
    //    public void arcTo(double x1, double y1, double x2, double y2, double radius) {
    //        path.arcTo(x1, y1, x2, y2, radius);
    //    }
    //    @Override
    //    public void arc(double centerX, double centerY, double radiusX, double radiusY, double startAngle, double length) {
    //        gc.arc(centerX, centerY, radiusX, radiusY, startAngle, length);
    //    }
    override fun rect(x: Double, y: Double, w: Double, h: Double) {
        path!!.moveTo(x.toFloat(), y.toFloat())
        path!!.lineTo(x.toFloat() + w.toFloat(), y.toFloat())
        path!!.lineTo(x.toFloat() + w.toFloat(), y.toFloat() + h.toFloat())
        path!!.lineTo(x.toFloat(), y.toFloat() + h.toFloat())
        path!!.lineTo(x.toFloat(), y.toFloat())
    }

    //    @Override
//    public void appendSVGPath(String svgpath) {
//        gc.appendSVGPath(svgpath);
//    }

    //    @Override
    //    public void appendSVGPath(String svgpath) {
    //        gc.appendSVGPath(svgpath);
    //    }
    override fun closePath() {
        path!!.close()
    }

    override fun fill() {
        gc!!.drawPath(path!!, fill!!.nativeColor)
    }

    override fun stroke() {
        gc!!.drawPath(path!!, stroke!!.nativeColor)
    }

    override fun clip() {
//        gc.clip(path)
    }

//    @Override
//    public boolean isPointInPath(double x, double y) {
//        return gc.isPointInPath(x, y);
//    }

//    @Override
//    public void clearRect(double x, double y, double w, double h) {
//        gc.clearRect(x, y, w, h);
//    }

    //    @Override
    //    public boolean isPointInPath(double x, double y) {
    //        return gc.isPointInPath(x, y);
    //    }
    //    @Override
    //    public void clearRect(double x, double y, double w, double h) {
    //        gc.clearRect(x, y, w, h);
    //    }
    override fun fillRect(x: Double, y: Double, w: Double, h: Double) {
        gc.drawRect(fill!!.nativeColor, Offset(x.toFloat(), y.toFloat()), Size(w.toFloat(), w.toFloat()))
    }

    override fun strokeRect(x: Double, y: Double, w: Double, h: Double) {
        gc.drawRect(stroke!!.nativeColor, Offset(x.toFloat(), y.toFloat()), Size(w.toFloat(), w.toFloat()))
    }

    //    @Override
//    public void fillOval(double x, double y, double w, double h) {
//        gc.fillOval(x, y, w, h);
//    }

    //    @Override
//    public void strokeOval(double x, double y, double w, double h) {
//        gc.strokeOval(x, y, w, h);
//    }

    //    @Override
//    public void fillArc(double x, double y, double w, double h, double startAngle, double arcExtent, ArcType closure) {
//        gc.fillArc(x, y, w, h, startAngle, arcExtent, closure);
//    }

    //    @Override
//    public void strokeArc(double x, double y, double w, double h, double startAngle, double arcExtent, ArcType closure) {
//        gc.strokeArc(x, y, w, h, startAngle, arcExtent, closure);
//    }

    //    @Override
    //    public void fillOval(double x, double y, double w, double h) {
    //        gc.fillOval(x, y, w, h);
    //    }
    //    @Override
    //    public void strokeOval(double x, double y, double w, double h) {
    //        gc.strokeOval(x, y, w, h);
    //    }
    //    @Override
    //    public void fillArc(double x, double y, double w, double h, double startAngle, double arcExtent, ArcType closure) {
    //        gc.fillArc(x, y, w, h, startAngle, arcExtent, closure);
    //    }
    //    @Override
    //    public void strokeArc(double x, double y, double w, double h, double startAngle, double arcExtent, ArcType closure) {
    //        gc.strokeArc(x, y, w, h, startAngle, arcExtent, closure);
    //    }
    override fun strokeLine(x1: Double, y1: Double, x2: Double, y2: Double) {
//        gc.draw(Line2D.Double(x1, y1, x2, y2))
    }

    //    @Override
//    public void strokeRoundRect(double x, double y, double w, double h, double arcWidth, double arcHeight) {
//        gc.strokeRoundRect(x, y, w, h, arcWidth, arcHeight);
//    }

    //    @Override
    //    public void strokeRoundRect(double x, double y, double w, double h, double arcWidth, double arcHeight) {
    //        gc.strokeRoundRect(x, y, w, h, arcWidth, arcHeight);
    //    }
    //    @Override
    fun fillRoundRect(x: Double, y: Double, w: Double, h: Double, arcWidth: Double, arcHeight: Double) {
//        gc.fill(RoundRectangle2D.Double(x, y, w, h, arcWidth, arcHeight))
    }

    //    @Override
//    public void fillPolygon(double[] xPoints, double[] yPoints, int nPoints) {
//        gc.fillPolygon(xPoints, yPoints, nPoints);
//    }

    //    @Override
//    public void strokePolygon(double[] xPoints, double[] yPoints, int nPoints) {
//        gc.strokePolygon(xPoints, yPoints, nPoints);
//    }

    //    @Override
//    public void strokePolyline(double[] xPoints, double[] yPoints, int nPoints) {
//        gc.strokePolyline(xPoints, yPoints, nPoints);
//    }

}