/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.canvas;

import androidx.compose.runtime.Composer;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import com.macrofocus.common.collection.CollectionFactory;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.canvas.CanvasListener;
import org.kamaeleo.canvas.ContextMenuListener;
import org.kamaeleo.canvas.DrawScopeLayer;
import org.kamaeleo.canvas.FunctionalCPCanvas;
import org.kamaeleo.canvas.GraphicsContextDrawing;
import org.kamaeleo.canvas.KeyListener;
import org.kamaeleo.canvas.MouseListener;
import org.kamaeleo.canvas.MouseMotionListener;
import org.kamaeleo.canvas.MouseWheelListener;
import org.kamaeleo.component.CPComponent;
import org.kamaeleo.graphics.CPGraphicsContext2D;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\rH\u0016J\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020 H\u0016J\u000e\u0010!\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\tJ\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020%H\u0016J\u0018\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0014J\u0006\u0010+\u001a\u00020\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u000e\u001a\r\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\b\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006,"}, d2={"Lorg/kamaeleo/canvas/CPCanvas;", "Lorg/kamaeleo/component/CPComponent;", "()V", "functionalCanvas", "Lorg/kamaeleo/canvas/FunctionalCPCanvas;", "getFunctionalCanvas", "()Lorg/kamaeleo/canvas/FunctionalCPCanvas;", "layers", "", "Lorg/kamaeleo/canvas/DrawScopeLayer;", "getLayers", "()Ljava/util/List;", "listeners", "Lorg/kamaeleo/canvas/CanvasListener;", "nativeComponent", "Lkotlin/Function0;", "", "Landroidx/compose/runtime/Composable;", "getNativeComponent", "()Lkotlin/jvm/functions/Function2;", "addCanvasListener", "l", "addContextMenuListener", "Lorg/kamaeleo/canvas/ContextMenuListener;", "addKeyListener", "Lorg/kamaeleo/canvas/KeyListener;", "addLayer", "d", "Lorg/kamaeleo/canvas/GraphicsContextDrawing;", "addMouseListener", "Lorg/kamaeleo/canvas/MouseListener;", "addMouseMotionListener", "Lorg/kamaeleo/canvas/MouseMotionListener;", "addMouseWheelListener", "Lorg/kamaeleo/canvas/MouseWheelListener;", "addNativeLayer", "getHeight", "", "getWidth", "notifySizeChanged", "width", "", "height", "redraw", "kamaeleo"})
@StabilityInferred(parameters=0)
public class CPCanvas
implements CPComponent {
    @NotNull
    private final List<DrawScopeLayer> layers = CollectionFactory.INSTANCE.copyOnWriteArrayList();
    @NotNull
    private final List<CanvasListener> listeners = new ArrayList();
    @NotNull
    private final FunctionalCPCanvas functionalCanvas = new FunctionalCPCanvas(this.layers, this.listeners);
    public static final int $stable = 8;

    @NotNull
    public final List<DrawScopeLayer> getLayers() {
        return this.layers;
    }

    @NotNull
    public final FunctionalCPCanvas getFunctionalCanvas() {
        return this.functionalCanvas;
    }

    public final void addNativeLayer(@NotNull DrawScopeLayer d) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        this.layers.add(d);
    }

    public final void addLayer(@NotNull GraphicsContextDrawing d) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        this.layers.add(new DrawScopeLayer(d, this){
            final /* synthetic */ GraphicsContextDrawing $d;
            final /* synthetic */ CPCanvas this$0;
            {
                this.$d = $d;
                this.this$0 = $receiver;
            }

            public void prepare(int width, int height) {
            }

            public void render(@Nullable DrawScope g) {
                Intrinsics.checkNotNull((Object)g);
                this.$d.draw(new CPGraphicsContext2D(g), this.this$0.getWidth(), this.this$0.getHeight());
            }
        });
    }

    @Override
    @NotNull
    public Function2<Composer<?>, Integer, Unit> getNativeComponent() {
        return this.functionalCanvas.getNativeComponent();
    }

    public double getWidth() {
        return this.functionalCanvas.getWidth();
    }

    public double getHeight() {
        return this.functionalCanvas.getHeight();
    }

    public void addCanvasListener(@NotNull CanvasListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.add(l);
    }

    protected void notifySizeChanged(int width, int height) {
        for (CanvasListener listener : this.listeners) {
            listener.sizeChange(width, height);
        }
    }

    public final void redraw() {
        this.functionalCanvas.redraw();
    }

    public final void addMouseListener(@NotNull MouseListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.functionalCanvas.addMouseListener(l);
    }

    public void addMouseMotionListener(@NotNull MouseMotionListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.functionalCanvas.addMouseMotionListener(l);
    }

    public final void addMouseWheelListener(@NotNull MouseWheelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.functionalCanvas.addMouseWheelListener(l);
    }

    public final void addKeyListener(@NotNull KeyListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.functionalCanvas.addKeyListener(l);
    }

    public final void addContextMenuListener(@NotNull ContextMenuListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.functionalCanvas.addContextMenuListener(l);
    }
}

