/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom.curve;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.geom.curve.BinaryCurveApproximationAlgorithm;
import org.kamaeleo.geom.curve.ControlPath;
import org.kamaeleo.geom.curve.GroupIterator;
import org.kamaeleo.geom.curve.MultiPath;
import org.kamaeleo.geom.curve.ParametricCurve;
import org.kamaeleo.geom.curve.PascalsTriangle;
import org.kamaeleo.geom.curve.Point;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0012H\u0016J\u0016\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fR$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/kamaeleo/geom/curve/BezierCurve;", "Lorg/kamaeleo/geom/curve/ParametricCurve;", "cp", "Lorg/kamaeleo/geom/curve/ControlPath;", "gi", "Lorg/kamaeleo/geom/curve/GroupIterator;", "(Lorg/kamaeleo/geom/curve/ControlPath;Lorg/kamaeleo/geom/curve/GroupIterator;)V", "limit", "", "sampleLimit", "getSampleLimit", "()I", "setSampleLimit", "(I)V", "t_max", "", "t_min", "appendTo", "", "mp", "Lorg/kamaeleo/geom/curve/MultiPath;", "eval", "p", "", "resetMemory", "setInterval", "Companion", "kamaeleo"})
@StabilityInferred(parameters=0)
public final class BezierCurve
extends ParametricCurve {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double t_min;
    private double t_max = 1.0;
    private int sampleLimit = 1;
    public static final int $stable = 8;
    @NotNull
    private static double[] a = new double[0];

    public BezierCurve(@Nullable ControlPath cp, @Nullable GroupIterator gi) {
        super(cp, gi);
    }

    @Override
    public int getSampleLimit() {
        return this.sampleLimit;
    }

    public void setSampleLimit(int limit) {
        this.sampleLimit = limit;
    }

    public final void setInterval(double t_min, double t_max) {
        this.t_min = t_min;
        this.t_max = t_max;
    }

    public final double t_min() {
        return this.t_min;
    }

    public final double t_max() {
        return this.t_max;
    }

    @Override
    public void appendTo(@NotNull MultiPath mp) {
        Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
        Object object = this.getGi();
        Intrinsics.checkNotNull((Object)object);
        GroupIterator groupIterator = object;
        object = this.getCp();
        Intrinsics.checkNotNull((Object)object);
        if (!groupIterator.isInRange(0, ((ControlPath)object).numPoints())) {
            return;
        }
        int n = mp.getDimension();
        double[] d = new double[n + 1];
        d[n] = this.t_min;
        this.eval(d);
        if (this.getConnect()) {
            mp.lineTo(d);
        } else {
            mp.moveTo(d);
        }
        BinaryCurveApproximationAlgorithm.INSTANCE.genPts(this, this.t_min, this.t_max, mp);
    }

    @Override
    public void eval(@NotNull double[] p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        double t = p[p.length - 1];
        GroupIterator groupIterator = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator);
        int numPts = groupIterator.getGroupSize();
        if (numPts > a.length) {
            a = new double[2 * numPts];
        }
        BezierCurve.a[numPts - 1] = 1.0;
        double one_minus_t = 1.0 - t;
        int n = numPts - 2;
        if (0 <= n) {
            do {
                int i = n;
                BezierCurve.a[i] = a[i + 1] * one_minus_t;
            } while (0 <= (n += -1));
        }
        GroupIterator groupIterator2 = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator2);
        groupIterator2.set(0, 0);
        int i = 0;
        double b = 1.0;
        while (i < numPts) {
            double pt;
            double d = pt = PascalsTriangle.INSTANCE.nCr(numPts - 1, i);
            boolean bl = false;
            if (!Double.isNaN(d)) {
                d = pt;
                bl = false;
                if (!Double.isNaN(d)) {
                    double gravity = a[i] * b * pt;
                    Object object = this.getCp();
                    Intrinsics.checkNotNull((Object)object);
                    ControlPath controlPath = object;
                    object = this.getGi();
                    Intrinsics.checkNotNull((Object)object);
                    Point point = controlPath.getPoint(((GroupIterator)object).next());
                    Intrinsics.checkNotNull((Object)point);
                    double[] d2 = point.getLocation();
                    int n2 = p.length - 1;
                    int n3 = 0;
                    int n4 = n2 + -1;
                    if (n2 != Integer.MIN_VALUE && n3 <= n4) {
                        do {
                            int j = n3++;
                            double[] dArray = p;
                            int n5 = j;
                            dArray[n5] = dArray[n5] + d2[j] * gravity;
                        } while (n3 <= n4);
                    }
                }
            }
            b *= t;
            int n6 = i;
            i = n6 + 1;
        }
    }

    @Override
    public void resetMemory() {
        if (a.length > 0) {
            a = new double[0];
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/kamaeleo/geom/curve/BezierCurve$Companion;", "", "()V", "a", "", "kamaeleo"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

