/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.graphics;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.DesktopPathKt;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.canvas.ComposeTextMetrics;
import org.kamaeleo.color.CPColor;
import org.kamaeleo.font.CPFont;
import org.kamaeleo.graphics.GraphicsContext2D;
import org.kamaeleo.text.CPTextMetrics;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J8\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0016J\b\u0010\u0018\u001a\u00020\u000eH\u0016J@\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\u0005\u001a\u00020\u000eH\u0016J(\u0010\"\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u0011H\u0016J6\u0010#\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u0011J \u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0011H\u0016J\b\u0010)\u001a\u0004\u0018\u00010*J\u0010\u0010+\u001a\u00020,2\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010-\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J\u0018\u0010.\u001a\u00020\u000e2\u0006\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u0011H\u0016J(\u00101\u001a\u00020\u000e2\u0006\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J(\u00104\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u0011H\u0016J\b\u00105\u001a\u00020\u000eH\u0016J\u0010\u00106\u001a\u00020\u000e2\u0006\u00107\u001a\u00020\u0011H\u0016J\b\u00108\u001a\u00020\u000eH\u0016J\u0018\u00109\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0011H\u0016J\u0010\u0010:\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020\u0006H\u0016J\u0010\u0010<\u001a\u00020\u000e2\b\u0010=\u001a\u0004\u0018\u00010*J\u0010\u0010<\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020\u000e2\u0006\u0010@\u001a\u00020\u0011H\u0016J\u0010\u0010A\u001a\u00020\u000e2\u0006\u0010B\u001a\u00020\u0011H\u0016J\u0010\u0010C\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020\u0006H\u0016J8\u0010D\u001a\u00020\u000e2\u0006\u0010E\u001a\u00020\u00112\u0006\u0010F\u001a\u00020\u00112\u0006\u0010G\u001a\u00020\u00112\u0006\u0010H\u001a\u00020\u00112\u0006\u0010I\u001a\u00020\u00112\u0006\u0010J\u001a\u00020\u0011H\u0016J\b\u0010\f\u001a\u00020\u000eH\u0016J(\u0010K\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010L\u001a\u00020\u00112\u0006\u0010M\u001a\u00020\u0011H\u0016J(\u0010N\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u0011H\u0016J8\u0010O\u001a\u00020\u000e2\u0006\u0010E\u001a\u00020\u00112\u0006\u0010F\u001a\u00020\u00112\u0006\u0010G\u001a\u00020\u00112\u0006\u0010H\u001a\u00020\u00112\u0006\u0010I\u001a\u00020\u00112\u0006\u0010J\u001a\u00020\u0011H\u0016J\u0018\u0010P\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0011H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lorg/kamaeleo/graphics/CPGraphicsContext2D;", "Lorg/kamaeleo/graphics/GraphicsContext2D;", "gc", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "(Landroidx/compose/ui/graphics/drawscope/DrawScope;)V", "fill", "Lorg/kamaeleo/color/CPColor;", "path", "Landroidx/compose/ui/graphics/Path;", "stack", "Ljava/util/Stack;", "Ljava/awt/Graphics2D;", "stroke", "beginPath", "", "bezierCurveTo", "xc1", "", "yc1", "xc2", "yc2", "x1", "y1", "clip", "closePath", "drawGradient", "color1", "color2", "x", "y", "w", "h", "isVertical", "", "fillRect", "fillRoundRect", "arcWidth", "arcHeight", "fillText", "text", "", "getFont", "Ljava/awt/Font;", "getTextMetrics", "Lorg/kamaeleo/text/CPTextMetrics;", "lineTo", "moveTo", "x0", "y0", "quadraticCurveTo", "xc", "yc", "rect", "restore", "rotate", "degrees", "save", "scale", "setFill", "p", "setFont", "f", "Lorg/kamaeleo/font/CPFont;", "setGlobalAlpha", "alpha", "setLineWidth", "lw", "setStroke", "setTransform", "mxx", "myx", "mxy", "myy", "mxt", "myt", "strokeLine", "x2", "y2", "strokeRect", "transform", "translate", "kamaeleo"})
@StabilityInferred(parameters=0)
public final class CPGraphicsContext2D
implements GraphicsContext2D {
    @NotNull
    private DrawScope gc;
    @NotNull
    private final Stack<Graphics2D> stack;
    @Nullable
    private Path path;
    @Nullable
    private CPColor fill;
    @Nullable
    private CPColor stroke;
    public static final int $stable = 8;

    public CPGraphicsContext2D(@NotNull DrawScope gc) {
        Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
        this.gc = gc;
        this.stack = new Stack();
    }

    @Override
    @NotNull
    public CPTextMetrics getTextMetrics(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new ComposeTextMetrics(this.gc, text);
    }

    @Override
    public void drawGradient(@NotNull CPColor color1, @NotNull CPColor color2, double x, double y, double w, double h, boolean isVertical) {
        Intrinsics.checkNotNullParameter((Object)color1, (String)"color1");
        Intrinsics.checkNotNullParameter((Object)color2, (String)"color2");
        if (isVertical) {
            // empty if block
        }
    }

    @Override
    public void save() {
    }

    @Override
    public void restore() {
    }

    @Override
    public void translate(double x, double y) {
    }

    @Override
    public void scale(double x, double y) {
    }

    @Override
    public void rotate(double degrees) {
    }

    @Override
    public void transform(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
    }

    @Override
    public void setTransform(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
    }

    @Override
    public void setGlobalAlpha(double alpha) {
    }

    @Override
    public void setFill(@NotNull CPColor p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        this.fill = p;
    }

    @Override
    public void setStroke(@NotNull CPColor p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        this.stroke = p;
    }

    @Override
    public void setLineWidth(double lw) {
    }

    @Nullable
    public final Font getFont() {
        return null;
    }

    public final void setFont(@Nullable Font f) {
    }

    @Override
    public void setFont(@NotNull CPFont f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
    }

    @Override
    public void fillText(@NotNull String text, double x, double y) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
    }

    @Override
    public void beginPath() {
        this.path = DesktopPathKt.Path();
    }

    @Override
    public void moveTo(double x0, double y0) {
        Path path = this.path;
        Intrinsics.checkNotNull((Object)path);
        path.moveTo((float)x0, (float)y0);
    }

    @Override
    public void lineTo(double x1, double y1) {
        Path path = this.path;
        Intrinsics.checkNotNull((Object)path);
        path.lineTo((float)x1, (float)y1);
    }

    @Override
    public void quadraticCurveTo(double xc, double yc, double x1, double y1) {
        Path path = this.path;
        Intrinsics.checkNotNull((Object)path);
        path.quadraticBezierTo((float)xc, (float)yc, (float)x1, (float)y1);
    }

    @Override
    public void bezierCurveTo(double xc1, double yc1, double xc2, double yc2, double x1, double y1) {
        Path path = this.path;
        Intrinsics.checkNotNull((Object)path);
        path.cubicTo((float)xc1, (float)yc1, (float)xc2, (float)yc2, (float)x1, (float)y1);
    }

    @Override
    public void rect(double x, double y, double w, double h) {
        Path path = this.path;
        Intrinsics.checkNotNull((Object)path);
        path.moveTo((float)x, (float)y);
        path = this.path;
        Intrinsics.checkNotNull((Object)path);
        path.lineTo((float)x + (float)w, (float)y);
        path = this.path;
        Intrinsics.checkNotNull((Object)path);
        path.lineTo((float)x + (float)w, (float)y + (float)h);
        path = this.path;
        Intrinsics.checkNotNull((Object)path);
        path.lineTo((float)x, (float)y + (float)h);
        path = this.path;
        Intrinsics.checkNotNull((Object)path);
        path.lineTo((float)x, (float)y);
    }

    @Override
    public void closePath() {
        Path path = this.path;
        Intrinsics.checkNotNull((Object)path);
        path.close();
    }

    @Override
    public void fill() {
        Object object = this.gc;
        Intrinsics.checkNotNull((Object)object);
        DrawScope drawScope = object;
        object = this.path;
        Intrinsics.checkNotNull((Object)object);
        DrawScope drawScope2 = object;
        object = this.fill;
        Intrinsics.checkNotNull((Object)object);
        DrawScope.DefaultImpls.drawPath-tilSWAQ$default((DrawScope)drawScope, (Path)drawScope2, (long)((CPColor)object).getNativeColor-0d7_KjU(), (float)0.0f, null, null, null, (int)60, null);
    }

    @Override
    public void stroke() {
        Object object = this.gc;
        Intrinsics.checkNotNull((Object)object);
        DrawScope drawScope = object;
        object = this.path;
        Intrinsics.checkNotNull((Object)object);
        DrawScope drawScope2 = object;
        object = this.stroke;
        Intrinsics.checkNotNull((Object)object);
        DrawScope.DefaultImpls.drawPath-tilSWAQ$default((DrawScope)drawScope, (Path)drawScope2, (long)((CPColor)object).getNativeColor-0d7_KjU(), (float)0.0f, null, null, null, (int)60, null);
    }

    @Override
    public void clip() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fillRect(double x, double y, double w, double h) {
        void x$iv;
        CPColor cPColor = this.fill;
        Intrinsics.checkNotNull((Object)cPColor);
        float f = (float)x;
        float y$iv = (float)y;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        void var13_10 = x$iv;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits((float)var13_10);
        float f2 = y$iv;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        DrawScope.DefaultImpls.drawRect-IdEHoqk$default((DrawScope)this.gc, (long)cPColor.getNativeColor-0d7_KjU(), (long)Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL)), (long)SizeKt.Size((float)((float)w), (float)((float)w)), (float)0.0f, null, null, null, (int)120, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void strokeRect(double x, double y, double w, double h) {
        void x$iv;
        CPColor cPColor = this.stroke;
        Intrinsics.checkNotNull((Object)cPColor);
        float f = (float)x;
        float y$iv = (float)y;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        void var13_10 = x$iv;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits((float)var13_10);
        float f2 = y$iv;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        DrawScope.DefaultImpls.drawRect-IdEHoqk$default((DrawScope)this.gc, (long)cPColor.getNativeColor-0d7_KjU(), (long)Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL)), (long)SizeKt.Size((float)((float)w), (float)((float)w)), (float)0.0f, null, null, null, (int)120, null);
    }

    @Override
    public void strokeLine(double x1, double y1, double x2, double y2) {
    }

    public final void fillRoundRect(double x, double y, double w, double h, double arcWidth, double arcHeight) {
    }
}

