/*
 * Copyright (c) 2010 Macrofocus GmbH. All Rights Reserved.
 */
package org.kamaeleo.colormap

/**
 * An event that characterizes a change in the colormap.
 */
class ColorMapEvent(colorMap: ColorMap, propertyName: String, oldValue: Any?, newValue: Any?) {
    private val colorMap: ColorMap

    /**
     * name of the property that changed.  May be null, if not known.
     * @serial
     */
    val propertyName: String

    /**
     * New value for property.  May be null if not known.
     * @serial
     */
    val newValue: Any?

    /**
     * Previous value for property.  May be null if not known.
     * @serial
     */
    val oldValue: Any?
    fun getColorMap(): ColorMap {
        return colorMap
    }

    init {
        this.colorMap = colorMap
        this.propertyName = propertyName
        this.oldValue = oldValue
        this.newValue = newValue
    }
}