/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package org.kamaeleo.geom

class Edge(c: Curve, ctag: Int, etag: Int) {
    val curve: Curve
    val curveTag: Int
    var edgeTag: Int
    var activey = 0.0
    var equivalence = 0
    private var lastEdge: Edge? = null
    private var lastResult = 0
    private var lastLimit = 0.0

    constructor(c: Curve, ctag: Int) : this(c, ctag, AreaOp.ETAG_IGNORE) {}

    fun compareTo(other: Edge, yrange: DoubleArray): Int {
        if (other == lastEdge && yrange[0] < lastLimit) {
            if (yrange[1] > lastLimit) {
                yrange[1] = lastLimit
            }
            return lastResult
        }
        if (this == other.lastEdge && yrange[0] < other.lastLimit) {
            if (yrange[1] > other.lastLimit) {
                yrange[1] = other.lastLimit
            }
            return 0 - other.lastResult
        }
        //long start = System.currentTimeMillis();
        val ret: Int = curve.compareTo(other.curve, yrange)
        //long end = System.currentTimeMillis();
        /*
        System.out.println("compare: "+
                           ((System.identityHashCode(this) <
                             System.identityHashCode(other))
                            ? this+" to "+other
                            : other+" to "+this)+
                           " == "+ret+" at "+yrange[1]+
                           " in "+(end-start)+"ms");
         */lastEdge = other
        lastLimit = yrange[1]
        lastResult = ret
        return ret
    }

    fun record(yend: Double, etag: Int) {
        activey = yend
        edgeTag = etag
    }

    fun isActiveFor(y: Double, etag: Int): Boolean {
        return edgeTag == etag && activey >= y
    }

    override fun toString(): String {
        return "Edge[" + curve +
                ", " +
                (if (curveTag == AreaOp.CTAG_LEFT) "L" else "R") +
                ", " +
                (if (edgeTag == AreaOp.ETAG_ENTER) "I" else if (edgeTag == AreaOp.ETAG_EXIT) "O" else "N") +
                ']'
    }

    companion object {
        const val INIT_PARTS = 4
        const val GROW_PARTS = 10
    }

    init {
        curve = c
        curveTag = ctag
        edgeTag = etag
    }
}