package org.kamaeleo.graphics

import org.kamaeleo.color.CPColor
import org.kamaeleo.font.CPFont
import org.kamaeleo.font.CPFontMetrics

interface IGraphics {
    enum class TextBaseline {
        Top, Bottom, Middle, Alphabetic, Ideographic, Hanging
    }

    fun isThreadSafe(): Boolean

    fun beginPick()

    fun getLineWidth(): Double

    fun setLineWidth(lineWidth: Double)

    fun setLineDash(dashPatern: FloatArray?)

    fun setGlobalAlpha(alpha: Double)

    fun getColor(): CPColor

    fun setColor(color: CPColor)

//    fun drawShape(shape: Shape?)

//    fun drawPoint(point: Point2D?)

    fun drawLine(x1: Int, y1: Int, x2: Int, y2: Int)

    fun drawLine(x1: Double, y1: Double, x2: Double, y2: Double)

//    fun fillCircle(rectangle: Rectangle2D?)

//    fun fillRectangle2D(rectangle: Rectangle2D?)

    fun fillRectangle(x1: Int, y1: Int, x2: Int, y2: Int)

    fun drawRectange(x1: Int, y1: Int, x2: Int, y2: Int)

//    fun fillShape(shape: Shape?)

//    fun <T> pickDraw(geometry: Shape?, point: Point2D?, value: T, callback: ICallback<T>?)

//    fun <T> pickFill(geometry: Shape?, point: Point2D?, value: T, callback: ICallback<T>?)

    fun endPick()

    fun setTextBaseline(baseline: TextBaseline?)

    fun setFont(font: CPFont?)

//    fun getStringBounds(text: String?): Rectangle2D?

    fun getStringWidth(text: String?): Float

    fun getStringHeight(text: String?): Float

    fun getAscent(): Double

    fun getDescent(): Double

    fun getFontMetrics(): CPFontMetrics?

    fun drawString(text: String?, x: Float, y: Float)

    fun drawCircularString(
        text: String?,
        centerX: Float,
        centerY: Float,
        diameter: Float,
        startAngle: Float,
        extent: Float
    )

    fun translate(x: Int, y: Int)

    fun rotate(theta: Double)

    fun beginPath()

    fun moveTo(x: Double, y: Double)

    fun lineTo(x: Double, y: Double)

    fun closePath()

    fun stroke()

    fun fill()
}