package org.kamaeleo.graphics

interface Image {
    val width: Int
    val height: Int

    /**
     * Sets all samples for a rectangle of pixels from an int array containing
     * one sample per array element.
     * An ArrayIndexOutOfBoundsException may be thrown if the coordinates are
     * not in bounds.
     * However, explicit bounds checking is not guaranteed.
     * @param x        The X coordinate of the upper left pixel location.
     * @param y        The Y coordinate of the upper left pixel location.
     * @param w        Width of the pixel rectangle.
     * @param h        Height of the pixel rectangle.
     * @param iArray   The input int pixel array.
     *
     * @throws NullPointerException if iArray is null.
     * @throws ArrayIndexOutOfBoundsException if the coordinates are not
     * in bounds, or if iArray is too small to hold the input.
     */
    fun setPixels(x: Int, y: Int, w: Int, h: Int, iArray: IntArray?)
    val isOneSamplePerArrayElement: Boolean
    val isLoaded: Boolean

    fun flush()
    val nativeImage: Any
}