package org.kamaeleo.canvas

import androidx.compose.runtime.Composable
import androidx.compose.ui.graphics.drawscope.DrawScope
import com.macrofocus.common.collection.CollectionFactory
import org.kamaeleo.color.CPColor
import org.kamaeleo.component.CPComponent
import org.kamaeleo.graphics.CPGraphicsContext2D
import org.kamaeleo.graphics.GraphicsContext2D
import java.awt.Graphics
import java.awt.Graphics2D
import java.awt.event.ComponentEvent
import java.awt.event.ComponentListener
import java.awt.event.HierarchyEvent
import java.util.*
import javax.swing.JButton
import javax.swing.JComponent
import javax.swing.JPanel
import kotlin.collections.HashSet

actual open class CPCanvas : CPComponent {
    val layers = CollectionFactory.copyOnWriteArrayList<DrawScopeLayer>()
    private val listeners: MutableList<CanvasListener> = ArrayList()
    val functionalCanvas = FunctionalCPCanvas(layers, listeners)


    fun addNativeLayer(d: DrawScopeLayer) {
        layers.add(d)
    }

    actual fun addLayer(d: GraphicsContextDrawing) {
        layers.add(object : DrawScopeLayer {
            override fun prepare(width: Int, height: Int) {

            }

            override fun render(g: DrawScope?) {
                d.draw(CPGraphicsContext2D(g!!), getWidth(), getHeight())
            }
        })
    }

    override val nativeComponent: @Composable () -> Unit
        get() = functionalCanvas.nativeComponent

    actual open fun getWidth(): Double {
        return functionalCanvas.width.toDouble()
    }

    actual open fun getHeight(): Double {
        return functionalCanvas.height.toDouble()
    }

    actual open fun addCanvasListener(l: CanvasListener) {
        listeners.add(l)
    }

    protected open fun notifySizeChanged(width: Int, height: Int) {
        for (listener in listeners) {
            listener.sizeChange(width, height)
        }
    }

    actual fun redraw() {
        functionalCanvas.redraw()
    }

    actual fun addMouseListener(l: MouseListener) {
        functionalCanvas.addMouseListener(l)
    }

    actual open fun addMouseMotionListener(l: MouseMotionListener) {
        functionalCanvas.addMouseMotionListener(l)
    }

    actual fun addMouseWheelListener(l: MouseWheelListener) {
        functionalCanvas.addMouseWheelListener(l)
    }

    actual fun addKeyListener(l: KeyListener) {
        functionalCanvas.addKeyListener(l)
    }

    actual fun addContextMenuListener(l: ContextMenuListener) {
        functionalCanvas.addContextMenuListener(l)
    }
}