package org.kamaeleo.canvas

import androidx.compose.foundation.Canvas
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.width
import androidx.compose.runtime.*
import androidx.compose.ui.Modifier
import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.drawscope.DrawScope
import androidx.compose.ui.layout.onSizeChanged
import androidx.compose.ui.unit.dp
import java.time.Instant.now
import kotlin.collections.ArrayList

class FunctionalCPCanvas(val graphicsContextDrawings: MutableList<DrawScopeLayer>, private val listeners: List<CanvasListener>) { // : CPComponent {
    private val mouseListeners : MutableList<MouseListener> = ArrayList()
    private val mouseMotionListeners: MutableList<MouseMotionListener> = ArrayList()
    private val mouseWheelListeners: MutableList<MouseWheelListener> = ArrayList()
    private val keyListeners: MutableList<KeyListener> = ArrayList()
    private val contextMenuListeners: MutableList<ContextMenuListener> = ArrayList()

    var width = 0
    var height = 0
    var scaleFactor = 1.0
    var physicalWidth = 0
    var physicalHeight = 0

    fun redraw() {
//        paintTheCanvas()
    }

    private fun paintTheCanvas(drawScope: DrawScope) {
//        val start = Date.now();
        println("Painting " + drawScope + " " + width + "x" + height)
//        with(ctx) {
//            val width = canvas.clientWidth
//            val height = canvas.clientHeight
//            val scaleFactor = findDesiredScaleFactor()
//            val dim = canvas.getBoundingClientRect()
//            if(dimensionHasChanged(width, height, scaleFactor)) {
//                syncCanvasDimension(width, height, scaleFactor)
//            }

//            clearAndResetRenderingContext2D(ctx)

            for (i in graphicsContextDrawings) {
                i.prepare(width, height)
            }

            for (i in graphicsContextDrawings) {
                i.render(drawScope)
            }
//        }

//        val delta = (Date.now() - start);
//        val fps = 1/delta

//        ctx.fillStyle = "red"
//        ctx.fillText("" + delta.absoluteValue + " ms", 5.0, height - 12.0)

//        window.requestAnimationFrame { paintTheCanvas() }
    }

    val nativeComponent: @Composable () -> Unit = {
        val count : MutableState<Int> = remember { mutableStateOf(0) }

        Canvas(modifier = Modifier.width(300.dp).height(300.dp).onSizeChanged {
            width = it.width
            height = it.height
            listeners.forEach { it.sizeChange(width, height) }
            count.value = count.value + 1
        }, onDraw = {
            drawCircle(Color(125, 130, 128), 100f, Offset(200f, 200f))
            paintTheCanvas(this)
        })
    }

    fun addMouseListener(l: MouseListener) {
        mouseListeners.add(l)
    }

    fun addMouseMotionListener(l: MouseMotionListener) {
        mouseMotionListeners.add(l)
    }

    fun addMouseWheelListener(l: MouseWheelListener) {
        mouseWheelListeners.add(l)
    }

    fun addKeyListener(l: KeyListener) {
        keyListeners.add(l)
    }

    fun addContextMenuListener(l: ContextMenuListener) {
        contextMenuListeners.add(l)
    }
}