package org.kamaeleo.font

import java.awt.Font

actual class CPFontFactory {
    actual fun createFont(family: String?, style: Weight, size: Int): CPFont? {
        return CPFont()
    }
    actual fun createFont(family: String?, style: Int, size: Int): CPFont? {
        return CPFont()
    }

    actual fun decodeFont(labelingFont: String?): CPFont? {
        return CPFont()
    }

    actual fun createFontFamily(family: String?): CPFont? {
        return CPFont()
    }

    actual fun decodeFontWithDefault(
        labelingFont: String?,
        defaultLabelingFont: CPFont?
    ): CPFont? {
        val f: CPFont? = decodeFont(labelingFont)
        return if (f != null) {
            f
        } else {
            defaultLabelingFont
        }
    }

    actual fun createDefaultFont(): CPFont {
        return createFontFamily("Arial")!!
    }

    actual companion object {
        actual val instance: CPFontFactory = CPFontFactory()
    }
}