/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package org.kamaeleo.geom

class ChainEnd(first: CurveLink, partner: ChainEnd?) {
    var head: CurveLink
    var tail: CurveLink
    var partner: ChainEnd?
    var etag: Int
    val chain: CurveLink?
        get() = head

    fun setOtherEnd(partner: ChainEnd?) {
        this.partner = partner
    }

    /*
     * Returns head of a complete chain to be added to subcurves
     * or null if the links did not complete such a chain.
     */
    fun linkTo(that: ChainEnd?): CurveLink? {
        if (etag == AreaOp.ETAG_IGNORE ||
            that!!.etag == AreaOp.ETAG_IGNORE
        ) {
            throw UnsupportedOperationException("ChainEnd linked more than once!")
        }
        if (etag == that!!.etag) {
            throw UnsupportedOperationException("Linking chains of the same type!")
        }
        val enter: ChainEnd?
        val exit: ChainEnd?
        // assert(partner.etag != that.partner.etag);
        if (etag == AreaOp.ETAG_ENTER) {
            enter = this
            exit = that
        } else {
            enter = that
            exit = this
        }
        // Now make sure these ChainEnds are not linked to any others...
        etag = AreaOp.ETAG_IGNORE
        that.etag = AreaOp.ETAG_IGNORE
        // Now link everything up...
        enter!!.tail.next = exit!!.head
        enter.tail = exit.tail
        if (partner == that) {
            // Curve has closed on itself...
            return enter.head
        }
        // Link this chain into one end of the chain formed by the partners
        val otherenter = exit.partner
        val otherexit = enter.partner
        otherenter!!.partner = otherexit
        otherexit!!.partner = otherenter
        if (enter.head.yTop < otherenter.head.yTop) {
            enter.tail.next = otherenter.head
            otherenter.head = enter.head
        } else {
            otherexit.tail.next = enter.head
            otherexit.tail = enter.tail
        }
        return null
    }

    fun addLink(newlink: CurveLink) {
        if (etag == AreaOp.ETAG_ENTER) {
            tail.next = newlink
            tail = newlink
        } else {
            newlink.next = head
            head = newlink
        }
    }

    val x: Double
        get() = if (etag == AreaOp.ETAG_ENTER) {
            tail.xBot
        } else {
            head.xBot
        }

    init {
        head = first
        tail = first
        this.partner = partner
        etag = first.edgeTag
    }
}