/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package org.kamaeleo.geom

internal class Order0(val x: Double, val y: Double) : Curve(INCREASING) {
    override val order: Int
        get() = 0
    override val x0: Double
        get() = x
    override val y0: Double
        get() = y
    override val x1: Double
        get() = x
    override val y1: Double
        get() = y
    override val xTop: Double
        get() = x
    override val xBot: Double
        get() = x
    override val yTop: Double
        get() = y
    override val yBot: Double
        get() = y
    override val xMin: Double
        get() = x
    override val xMax: Double
        get() = x
    override val reversedCurve: Curve?
        get() = this

    override fun YforT(t: Double): Double {
        return y
    }

    override fun dXforT(t: Double, deriv: Int): Double {
        return 0.0
    }

    override fun dYforT(t: Double, deriv: Int): Double {
        return 0.0
    }

    override fun crossingsFor(x: Double, y: Double): Int {
        return 0
    }

    override fun XforY(y: Double): Double {
        return y
    }

    override fun accumulateCrossings(c: Crossings): Boolean {
        return x > c.xLo && x < c.xHi && y > c.yLo && y < c.yHi
    }

    override fun TforY(y: Double): Double {
        return 0.0
    }

    override fun XforT(t: Double): Double {
        return x
    }

    override fun enlarge(r: Rectangle2D): Rectangle2D {
        return r.add(x, y)
    }

    override fun nextVertical(t0: Double, t1: Double): Double {
        return t1
    }

    override fun getSubCurve(ystart: Double, yend: Double, dir: Int): Curve {
        return this
    }

    override fun getSegment(coords: DoubleArray): Int {
        coords[0] = x
        coords[1] = y
        return PathIterator.SEG_MOVETO
    }
}