/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package org.kamaeleo.geom

import org.kamaeleo.font.CPFont

class TextShape(text: String, shape: Shape) : Shape {
    val text: String
    private val shape: Shape
    var font: CPFont? = null

    fun isTextOutline(): Boolean {
        return true
    }

    override val bounds2D: Rectangle2D
        get() = shape.bounds2D

    override operator fun contains(p: Point2D): Boolean {
        return shape.contains(p)
    }

    override fun intersects(r: Rectangle2D): Boolean {
        return shape.intersects(r)
    }

    override val pathIterator: org.kamaeleo.geom.PathIterator
        get() = shape.pathIterator

    override fun getPathIterator(at: AffineTransform?): PathIterator {
        return shape.getPathIterator(at)
    }

    override fun getFlattenPathIterator(flatness: Double): PathIterator {
        return shape.getFlattenPathIterator(flatness)
    }

    fun createTransformedShape(at: AffineTransform): Shape {
        return TODO()
    }

    init {
        this.shape = shape
        this.text = text
    }
}