/*
 * Copyright (c) 2010 Macrofocus GmbH. All Rights Reserved.
 */
package org.kamaeleo.palette

import org.kamaeleo.color.CPColor

/**
 * Defines a palette of colors.
 */
interface Palette {
    enum class Cycle {
        /**
         * Use the terminal colors to fill the remaining area.
         */
        NONE,

        /**
         * Cycle the gradient colors start-to-end, end-to-start to fill the remaining area.
         */
        REPEAT,

        /**
         * Cycle the gradient colors start-to-end, start-to-end to fill the remaining area.
         */
        REFLECT
    }

    fun getColor(fraction: Double): CPColor?
    fun getColorAt(fraction: Int): CPColor
    val colorCount: Int

    /**
     * Defines the method to use when retrieving colors outside the normal interval.
     *
     * @return the method to use
     */
    val cycle: Cycle?

    /**
     * Add a listener to the list that's notified each time a change to the palette occurs.
     *
     * @param listener the PaletteListener
     */
    fun addPaletteListener(listener: PaletteListener)
    /**
     * Add a listener to the list that's notified each time a change to the palette occurs. The listener will
     * automatically be disposed of should no other object have a reference to it.
     *
     * @param listener the PaletteListener
     */
    //    void addWeakPaletteListener(PaletteListener listener);
    /**
     * Remove a listener to the list that's notified each time a change to the palette occurs.
     *
     * @param listener the PaletteListener
     */
    fun removePaletteListener(listener: PaletteListener)
}