package org.kamaeleo.transform

abstract class AbstractTwoDScreenTransform : TwoDScreenTransform {
    override fun xWorldToScreen(x: Double): Int {
        return this.x.worldToScreen(x)
    }

    override fun yWorldToScreen(y: Double): Int {
        return this.y.worldToScreen(y)
    }

    override val screenWidth: Int
        get() = x.screenSize
    override val screenHeight: Int
        get() = y.screenSize

    override fun xScreenToWorld(x: Int): Double {
        return this.x.screenToWorld(x)
    }

    override fun yScreenToWorld(y: Int): Double {
        return this.y.screenToWorld(y)
    }
}