package org.kamaeleo.graphics

import org.kamaeleo.canvas.SwingTextMetrics
import org.kamaeleo.color.CPColor
import org.kamaeleo.font.CPFont
import org.kamaeleo.text.CPTextMetrics
import java.awt.*
import java.awt.geom.*
import java.util.*

actual class CPGraphicsContext2D(private var gc: Graphics2D) : GraphicsContext2D {
    private val stack = Stack<Graphics2D>()
    private var path: GeneralPath? = null
    private var fill: CPColor? = null
    private var stroke: CPColor? = null

    override fun getTextMetrics(text: String): CPTextMetrics {
        return SwingTextMetrics(gc, text)
    }

    override fun drawGradient(color1: CPColor, color2: CPColor, x: Double, y: Double, w: Double, h: Double, isVertical: Boolean) {
        if (isVertical) {
            val gradient = GradientPaint(0.0f, y.toFloat(), color1.nativeColor, 0.0f, (y + h).toFloat(), color2.nativeColor)
            gc.paint = gradient
            gc.fill(Rectangle2D.Double(x, y, w, h))
        } else {
            val gradient = GradientPaint(x.toFloat(), 0.0f, color1.nativeColor, (x + w).toFloat(), 0.0f, color2.nativeColor)
            gc.paint = gradient
            gc.fill(Rectangle2D.Double(x, y, w, h))
        }
    }

    override fun save() {
        stack.push(gc)
        gc = gc.create() as Graphics2D
    }

    override fun restore() {
        gc.dispose()
        gc = stack.pop()
    }

    override fun translate(x: Double, y: Double) {
        gc.translate(x, y)
    }

    override fun scale(x: Double, y: Double) {
        gc.scale(x, y)
    }

    override fun rotate(degrees: Double) {
        gc.rotate(degrees)
    }

    override fun transform(mxx: Double, myx: Double, mxy: Double, myy: Double, mxt: Double, myt: Double) {
        gc.transform(AffineTransform(mxx, myx, mxy, myy, mxt, myt))
    }

    override fun setTransform(mxx: Double, myx: Double, mxy: Double, myy: Double, mxt: Double, myt: Double) {
        gc.transform = AffineTransform(mxx, myx, mxy, myy, mxt, myt)
    }

    override fun setGlobalAlpha(alpha: Double) {
        gc.composite = AlphaComposite.getInstance(AlphaComposite.SRC_OVER, alpha.toFloat())
    }

//    @Override
//    public double getGlobalAlpha() {
//        return gc.getGlobalAlpha();
//    }

    //    @Override
    //    public double getGlobalAlpha() {
    //        return gc.getGlobalAlpha();
    //    }
    override fun setFill(p: CPColor) {
        fill = p
        gc.color = p.nativeColor
    }

    //    @Override
//    public Color getFill() {
//        return (Color)gc.getFill();
//    }

    //    @Override
    //    public Color getFill() {
    //        return (Color)gc.getFill();
    //    }
    override fun setStroke(p: CPColor) {
        stroke = p
        gc.color = p.nativeColor
    }

    //    @Override
//    public Color getStroke() {
//        return (Color)gc.getStroke();
//    }

    //    @Override
    //    public Color getStroke() {
    //        return (Color)gc.getStroke();
    //    }
    override fun setLineWidth(lw: Double) {
        gc.stroke = BasicStroke(lw.toFloat())
    }

//    @Override
//    public double getLineWidth() {
//        return gc.getLineWidth();
//    }

//    @Override
//    public void setMiterLimit(double ml) {
//        gc.setMiterLimit(ml);
//    }

//    @Override
//    public double getMiterLimit() {
//        return gc.getMiterLimit();
//    }

//    @Override
//    public void setLineDashes(double... dashes) {
//        gc.setLineDashes(dashes);
//    }

//    @Override
//    public double[] getLineDashes() {
//        return gc.getLineDashes();
//    }

    //    @Override
//    public void setLineDashOffset(double dashOffset) {
//        gc.setLineDashOffset(dashOffset);
//    }

    //    @Override
//    public double getLineDashOffset() {
//        return gc.getLineDashOffset();
//    }

    //    @Override
    //    public double getLineWidth() {
    //        return gc.getLineWidth();
    //    }
    //    @Override
    //    public void setMiterLimit(double ml) {
    //        gc.setMiterLimit(ml);
    //    }
    //    @Override
    //    public double getMiterLimit() {
    //        return gc.getMiterLimit();
    //    }
    //    @Override
    //    public void setLineDashes(double... dashes) {
    //        gc.setLineDashes(dashes);
    //    }
    //    @Override
    //    public double[] getLineDashes() {
    //        return gc.getLineDashes();
    //    }
    //    @Override
    //    public void setLineDashOffset(double dashOffset) {
    //        gc.setLineDashOffset(dashOffset);
    //    }
    //    @Override
    //    public double getLineDashOffset() {
    //        return gc.getLineDashOffset();
    //    }
    //    @Override
    fun getFont(): Font? {
        return gc.font
    }

    fun setFont(f: Font?) {
        gc.font = f
    }

    override fun setFont(f: CPFont) {
        gc.font = f.nativeFont
    }

    override fun fillText(text: String, x: Double, y: Double) {
        gc.drawString(text, x.toFloat(), y.toFloat())
    }

//    @Override
//    public void strokeText(String text, double x, double y) {
//        gc.strokeText(text, x, y);
//    }

//    @Override
//    public void fillText(String text, double x, double y, double maxWidth) {
//        gc.fill(text, x, y, maxWidth);
//    }

//    @Override
//    public void strokeText(String text, double x, double y, double maxWidth) {
//        gc.drawString(text, x, y, maxWidth);
//    }

    //    @Override
    //    public void strokeText(String text, double x, double y) {
    //        gc.strokeText(text, x, y);
    //    }
    //    @Override
    //    public void fillText(String text, double x, double y, double maxWidth) {
    //        gc.fill(text, x, y, maxWidth);
    //    }
    //    @Override
    //    public void strokeText(String text, double x, double y, double maxWidth) {
    //        gc.drawString(text, x, y, maxWidth);
    //    }
    override fun beginPath() {
        path = GeneralPath()
    }

    override fun moveTo(x0: Double, y0: Double) {
        path!!.moveTo(x0, y0)
    }

    override fun lineTo(x1: Double, y1: Double) {
        path!!.lineTo(x1, y1)
    }

    override fun quadraticCurveTo(xc: Double, yc: Double, x1: Double, y1: Double) {
        path!!.quadTo(xc, yc, x1, y1)
    }

    override fun bezierCurveTo(xc1: Double, yc1: Double, xc2: Double, yc2: Double, x1: Double, y1: Double) {
        path!!.curveTo(xc1, yc1, xc2, yc2, x1, y1)
    }

//    @Override
//    public void arcTo(double x1, double y1, double x2, double y2, double radius) {
//        path.arcTo(x1, y1, x2, y2, radius);
//    }

//    @Override
//    public void arc(double centerX, double centerY, double radiusX, double radiusY, double startAngle, double length) {
//        gc.arc(centerX, centerY, radiusX, radiusY, startAngle, length);
//    }

    //    @Override
    //    public void arcTo(double x1, double y1, double x2, double y2, double radius) {
    //        path.arcTo(x1, y1, x2, y2, radius);
    //    }
    //    @Override
    //    public void arc(double centerX, double centerY, double radiusX, double radiusY, double startAngle, double length) {
    //        gc.arc(centerX, centerY, radiusX, radiusY, startAngle, length);
    //    }
    override fun rect(x: Double, y: Double, w: Double, h: Double) {
        path!!.moveTo(x, y)
        path!!.lineTo(x + w, y)
        path!!.lineTo(x + w, y + h)
        path!!.lineTo(x, y + h)
        path!!.lineTo(x, y)
    }

    //    @Override
//    public void appendSVGPath(String svgpath) {
//        gc.appendSVGPath(svgpath);
//    }

    //    @Override
    //    public void appendSVGPath(String svgpath) {
    //        gc.appendSVGPath(svgpath);
    //    }
    override fun closePath() {
        path!!.closePath()
    }

    override fun fill() {
        gc.fill(path)
    }

    override fun stroke() {
        gc.draw(path)
    }

    override fun clip() {
        gc.clip(path)
    }

//    @Override
//    public boolean isPointInPath(double x, double y) {
//        return gc.isPointInPath(x, y);
//    }

//    @Override
//    public void clearRect(double x, double y, double w, double h) {
//        gc.clearRect(x, y, w, h);
//    }

    //    @Override
    //    public boolean isPointInPath(double x, double y) {
    //        return gc.isPointInPath(x, y);
    //    }
    //    @Override
    //    public void clearRect(double x, double y, double w, double h) {
    //        gc.clearRect(x, y, w, h);
    //    }
    override fun fillRect(x: Double, y: Double, w: Double, h: Double) {
        gc.fill(Rectangle2D.Double(x, y, w, h))
    }

    override fun strokeRect(x: Double, y: Double, w: Double, h: Double) {
        gc.draw(Rectangle2D.Double(x, y, w, h))
    }

    //    @Override
//    public void fillOval(double x, double y, double w, double h) {
//        gc.fillOval(x, y, w, h);
//    }

    //    @Override
//    public void strokeOval(double x, double y, double w, double h) {
//        gc.strokeOval(x, y, w, h);
//    }

    //    @Override
//    public void fillArc(double x, double y, double w, double h, double startAngle, double arcExtent, ArcType closure) {
//        gc.fillArc(x, y, w, h, startAngle, arcExtent, closure);
//    }

    //    @Override
//    public void strokeArc(double x, double y, double w, double h, double startAngle, double arcExtent, ArcType closure) {
//        gc.strokeArc(x, y, w, h, startAngle, arcExtent, closure);
//    }

    //    @Override
    //    public void fillOval(double x, double y, double w, double h) {
    //        gc.fillOval(x, y, w, h);
    //    }
    //    @Override
    //    public void strokeOval(double x, double y, double w, double h) {
    //        gc.strokeOval(x, y, w, h);
    //    }
    //    @Override
    //    public void fillArc(double x, double y, double w, double h, double startAngle, double arcExtent, ArcType closure) {
    //        gc.fillArc(x, y, w, h, startAngle, arcExtent, closure);
    //    }
    //    @Override
    //    public void strokeArc(double x, double y, double w, double h, double startAngle, double arcExtent, ArcType closure) {
    //        gc.strokeArc(x, y, w, h, startAngle, arcExtent, closure);
    //    }
    override fun strokeLine(x1: Double, y1: Double, x2: Double, y2: Double) {
        gc.draw(Line2D.Double(x1, y1, x2, y2))
    }

    //    @Override
//    public void strokeRoundRect(double x, double y, double w, double h, double arcWidth, double arcHeight) {
//        gc.strokeRoundRect(x, y, w, h, arcWidth, arcHeight);
//    }

    //    @Override
    //    public void strokeRoundRect(double x, double y, double w, double h, double arcWidth, double arcHeight) {
    //        gc.strokeRoundRect(x, y, w, h, arcWidth, arcHeight);
    //    }
    //    @Override
    fun fillRoundRect(x: Double, y: Double, w: Double, h: Double, arcWidth: Double, arcHeight: Double) {
        gc.fill(RoundRectangle2D.Double(x, y, w, h, arcWidth, arcHeight))
    }

    //    @Override
//    public void fillPolygon(double[] xPoints, double[] yPoints, int nPoints) {
//        gc.fillPolygon(xPoints, yPoints, nPoints);
//    }

    //    @Override
//    public void strokePolygon(double[] xPoints, double[] yPoints, int nPoints) {
//        gc.strokePolygon(xPoints, yPoints, nPoints);
//    }

    //    @Override
//    public void strokePolyline(double[] xPoints, double[] yPoints, int nPoints) {
//        gc.strokePolyline(xPoints, yPoints, nPoints);
//    }

}