/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom;

import com.macrofocus.common.math.MathKt;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.geom.AffineTransform;
import org.kamaeleo.geom.Arc2D;
import org.kamaeleo.geom.PathIterator;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0013\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 42\u00020\u0001:\u00014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u000201H\u0016J\t\u00102\u001a\u000203H\u0096\u0002R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\r\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\rR\u001a\u0010\u001a\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\r\"\u0004\b\u001c\u0010\u0017R\u001a\u0010\u001d\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0011\"\u0004\b\u001f\u0010\u0013R\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\"R\u001a\u0010#\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0011\"\u0004\b%\u0010\u0013R\u0011\u0010&\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\rR\u0014\u0010(\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0011R\u0011\u0010*\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\rR\u0011\u0010,\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\r\u00a8\u00065"}, d2={"Lorg/kamaeleo/geom/ArcIterator;", "Lorg/kamaeleo/geom/PathIterator;", "a", "Lorg/kamaeleo/geom/Arc2D;", "at", "Lorg/kamaeleo/geom/AffineTransform;", "(Lorg/kamaeleo/geom/Arc2D;Lorg/kamaeleo/geom/AffineTransform;)V", "affine", "getAffine", "()Lorg/kamaeleo/geom/AffineTransform;", "angStRad", "", "getAngStRad", "()D", "arcSegs", "", "getArcSegs", "()I", "setArcSegs", "(I)V", "cv", "getCv", "setCv", "(D)V", "h", "getH", "increment", "getIncrement", "setIncrement", "index", "getIndex", "setIndex", "isDone", "", "()Z", "lineSegs", "getLineSegs", "setLineSegs", "w", "getW", "windingRule", "getWindingRule", "x", "getX", "y", "getY", "currentSegment", "coords", "", "", "next", "", "Companion", "kamaeleo"})
public final class ArcIterator
implements PathIterator {
    private final double x;
    private final double y;
    private final double w;
    private final double h;
    private final double angStRad;
    @Nullable
    private final AffineTransform affine;
    private double increment;
    private double cv;
    private int index;
    private int arcSegs;
    private int lineSegs;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getW() {
        return this.w;
    }

    public final double getH() {
        return this.h;
    }

    public final double getAngStRad() {
        return this.angStRad;
    }

    @Nullable
    public final AffineTransform getAffine() {
        return this.affine;
    }

    public final double getIncrement() {
        return this.increment;
    }

    public final void setIncrement(double d) {
        this.increment = d;
    }

    public final double getCv() {
        return this.cv;
    }

    public final void setCv(double d) {
        this.cv = d;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    public final int getArcSegs() {
        return this.arcSegs;
    }

    public final void setArcSegs(int n) {
        this.arcSegs = n;
    }

    public final int getLineSegs() {
        return this.lineSegs;
    }

    public final void setLineSegs(int n) {
        this.lineSegs = n;
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.index > this.arcSegs + this.lineSegs;
    }

    @Override
    public void next() {
        int n = this.index;
        this.index = n + 1;
    }

    @Override
    public int currentSegment(@NotNull float[] coords) {
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        if (this.isDone()) {
            throw (Throwable)new NoSuchElementException("arc iterator out of bounds");
        }
        double angle = this.angStRad;
        if (this.index == 0) {
            boolean bl = false;
            coords[0] = ((Float)(this.x + Math.cos(angle) * this.w)).floatValue();
            bl = false;
            coords[1] = ((Float)(this.y + Math.sin(angle) * this.h)).floatValue();
            if (this.affine != null) {
                this.affine.transform(coords, 0, coords, 0, 1);
            }
            return 0;
        }
        if (this.index > this.arcSegs) {
            if (this.index == this.arcSegs + this.lineSegs) {
                return 4;
            }
            coords[0] = (float)this.x;
            coords[1] = (float)this.y;
            if (this.affine != null) {
                this.affine.transform(coords, 0, coords, 0, 1);
            }
            return 1;
        }
        boolean bl = false;
        double relx = Math.cos(angle += this.increment * (double)(this.index - 1));
        boolean bl2 = false;
        double rely = Math.sin(angle);
        coords[0] = (float)(this.x + (relx - this.cv * rely) * this.w);
        coords[1] = (float)(this.y + (rely + this.cv * relx) * this.h);
        bl2 = false;
        relx = Math.cos(angle += this.increment);
        bl2 = false;
        rely = Math.sin(angle);
        coords[2] = (float)(this.x + (relx + this.cv * rely) * this.w);
        coords[3] = (float)(this.y + (rely - this.cv * relx) * this.h);
        coords[4] = (float)(this.x + relx * this.w);
        coords[5] = (float)(this.y + rely * this.h);
        if (this.affine != null) {
            this.affine.transform(coords, 0, coords, 0, 3);
        }
        return 3;
    }

    @Override
    public int currentSegment(@NotNull double[] coords) {
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        if (this.isDone()) {
            throw (Throwable)new NoSuchElementException("arc iterator out of bounds");
        }
        double angle = this.angStRad;
        if (this.index == 0) {
            boolean bl = false;
            coords[0] = this.x + Math.cos(angle) * this.w;
            bl = false;
            coords[1] = this.y + Math.sin(angle) * this.h;
            if (this.affine != null) {
                this.affine.transform(coords, 0, coords, 0, 1);
            }
            return 0;
        }
        if (this.index > this.arcSegs) {
            if (this.index == this.arcSegs + this.lineSegs) {
                return 4;
            }
            coords[0] = this.x;
            coords[1] = this.y;
            if (this.affine != null) {
                this.affine.transform(coords, 0, coords, 0, 1);
            }
            return 1;
        }
        boolean bl = false;
        double relx = Math.cos(angle += this.increment * (double)(this.index - 1));
        boolean bl2 = false;
        double rely = Math.sin(angle);
        coords[0] = this.x + (relx - this.cv * rely) * this.w;
        coords[1] = this.y + (rely + this.cv * relx) * this.h;
        bl2 = false;
        relx = Math.cos(angle += this.increment);
        bl2 = false;
        rely = Math.sin(angle);
        coords[2] = this.x + (relx + this.cv * rely) * this.w;
        coords[3] = this.y + (rely - this.cv * relx) * this.h;
        coords[4] = this.x + relx * this.w;
        coords[5] = this.y + rely * this.h;
        if (this.affine != null) {
            this.affine.transform(coords, 0, coords, 0, 3);
        }
        return 3;
    }

    public ArcIterator(@NotNull Arc2D a, @Nullable AffineTransform at) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        this.w = a.getWidth() / (double)2;
        this.h = a.getHeight() / (double)2;
        this.x = a.getX() + this.w;
        this.y = a.getY() + this.h;
        this.angStRad = -MathKt.convertDegreesToRadians((double)a.getAngleStart());
        this.affine = at;
        double ext = -a.getAngleExtent();
        if (ext >= 360.0 || ext <= (double)-360) {
            this.arcSegs = 4;
            this.increment = 1.5707963267948966;
            this.cv = 0.5522847498307933;
            if (ext < 0.0) {
                this.increment = -this.increment;
                this.cv = -this.cv;
            }
        } else {
            boolean bl = false;
            double d = Math.abs(ext) / 90.0;
            boolean bl2 = false;
            this.arcSegs = (int)Math.ceil(d);
            this.increment = MathKt.convertDegreesToRadians((double)(ext / (double)this.arcSegs));
            this.cv = ArcIterator.Companion.btan(this.increment);
            if (this.cv == 0.0) {
                this.arcSegs = 0;
            }
        }
        switch (a.getArcType()) {
            case 0: {
                this.lineSegs = 0;
                break;
            }
            case 1: {
                this.lineSegs = 1;
                break;
            }
            case 2: {
                this.lineSegs = 2;
                break;
            }
        }
        if (this.w < 0.0 || this.h < 0.0) {
            this.arcSegs = this.lineSegs = -1;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a8\u0006\u0006"}, d2={"Lorg/kamaeleo/geom/ArcIterator$Companion;", "", "()V", "btan", "", "increment", "kamaeleo"})
    public static final class Companion {
        private final double btan(double increment) {
            double increment2 = increment;
            boolean bl = false;
            bl = false;
            return 1.3333333333333333 * Math.sin(increment2 /= 2.0) / (1.0 + Math.cos(increment2));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

