/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.geom.AffineTransform;
import org.kamaeleo.geom.AreaOp;
import org.kamaeleo.geom.Crossings;
import org.kamaeleo.geom.Curve;
import org.kamaeleo.geom.FlatteningPathIterator;
import org.kamaeleo.geom.PathIterator;
import org.kamaeleo.geom.Point2D;
import org.kamaeleo.geom.Rectangle;
import org.kamaeleo.geom.Rectangle2D;
import org.kamaeleo.geom.Shape;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 32\u00020\u0001:\u000223B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0000J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eJ&\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001eJ\u0011\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#H\u0096\u0002J\u0011\u0010\u001c\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u0006H\u0086\u0002J\u0010\u0010%\u001a\u00020\u000e2\b\u0010&\u001a\u0004\u0018\u00010\u0000J\u000e\u0010'\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0000J\b\u0010(\u001a\u00020\u0006H\u0002J\u0010\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u001eH\u0016J\u0012\u0010\u0015\u001a\u00020\u00142\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J\u000e\u0010-\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0000J&\u0010.\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001eJ\u0010\u0010.\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u0006H\u0016J\b\u0010/\u001a\u00020\u0018H\u0002J\u0006\u00100\u001a\u00020\u0018J\u000e\u00101\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0011\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000fR\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00064"}, d2={"Lorg/kamaeleo/geom/Area;", "Lorg/kamaeleo/geom/Shape;", "()V", "s", "(Lorg/kamaeleo/geom/Shape;)V", "bounds2D", "Lorg/kamaeleo/geom/Rectangle2D;", "getBounds2D", "()Lorg/kamaeleo/geom/Rectangle2D;", "cachedBounds", "curves", "", "Lorg/kamaeleo/geom/Curve;", "isEmpty", "", "()Z", "isPolygonal", "isRectangular", "isSingular", "pathIterator", "Lorg/kamaeleo/geom/PathIterator;", "getPathIterator", "()Lorg/kamaeleo/geom/PathIterator;", "add", "", "rhs", "clone", "", "contains", "x", "", "y", "w", "h", "p", "Lorg/kamaeleo/geom/Point2D;", "r", "equals", "other", "exclusiveOr", "getCachedBounds", "getFlattenPathIterator", "flatness", "at", "Lorg/kamaeleo/geom/AffineTransform;", "intersect", "intersects", "invalidateBounds", "reset", "subtract", "AreaIterator", "Companion", "kamaeleo"})
public final class Area
implements Shape {
    private List<Curve> curves;
    private Rectangle2D cachedBounds;
    private static final List<Curve> EmptyCurves;
    @NotNull
    public static final Companion Companion;

    public final void add(@NotNull Area rhs) {
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        AreaOp.AddOp addOp = new AreaOp.AddOp();
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        List<Curve> list2 = rhs.curves;
        Intrinsics.checkNotNull(list2);
        this.curves = addOp.calculate(list, list2);
        this.invalidateBounds();
    }

    private final void invalidateBounds() {
        this.cachedBounds = null;
    }

    public final void subtract(@NotNull Area rhs) {
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        AreaOp.SubOp subOp = new AreaOp.SubOp();
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        List<Curve> list2 = rhs.curves;
        Intrinsics.checkNotNull(list2);
        this.curves = subOp.calculate(list, list2);
        this.invalidateBounds();
    }

    public final void intersect(@NotNull Area rhs) {
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        AreaOp.IntOp intOp = new AreaOp.IntOp();
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        List<Curve> list2 = rhs.curves;
        Intrinsics.checkNotNull(list2);
        this.curves = intOp.calculate(list, list2);
        this.invalidateBounds();
    }

    public final void exclusiveOr(@NotNull Area rhs) {
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        AreaOp.XorOp xorOp = new AreaOp.XorOp();
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        List<Curve> list2 = rhs.curves;
        Intrinsics.checkNotNull(list2);
        this.curves = xorOp.calculate(list, list2);
        this.invalidateBounds();
    }

    public final void reset() {
        this.curves = new ArrayList();
        this.invalidateBounds();
    }

    public final boolean isEmpty() {
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        return list.size() == 0;
    }

    public final boolean isPolygonal() {
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        for (Curve c2 : list) {
            if (c2.getOrder() <= 1) continue;
            return false;
        }
        return true;
    }

    public final boolean isRectangular() {
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        int size = list.size();
        if (size == 0) {
            return true;
        }
        if (size > 3) {
            return false;
        }
        List<Curve> list2 = this.curves;
        Intrinsics.checkNotNull(list2);
        Curve curve = list2.get(1);
        Intrinsics.checkNotNull((Object)curve);
        Curve c1 = curve;
        List<Curve> list3 = this.curves;
        Intrinsics.checkNotNull(list3);
        Curve curve2 = list3.get(2);
        Intrinsics.checkNotNull((Object)curve2);
        Curve c2 = curve2;
        if (c1.getOrder() != 1 || c2.getOrder() != 1) {
            return false;
        }
        return c1.getXTop() != c1.getXBot() || c2.getXTop() != c2.getXBot() ? false : c1.getYTop() == c2.getYTop() && c1.getYBot() == c2.getYBot();
    }

    public final boolean isSingular() {
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        if (list.size() < 3) {
            return true;
        }
        List<Curve> list2 = this.curves;
        Intrinsics.checkNotNull(list2);
        Iterator<Curve> iterator = list2.iterator();
        while (iterator.hasNext()) {
            Curve c2;
            Curve curve = c2 = iterator.next();
            Intrinsics.checkNotNull((Object)curve);
            if (curve.getOrder() != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Rectangle2D getBounds2D() {
        return this.getCachedBounds().getBounds2D();
    }

    /*
     * WARNING - void declaration
     */
    private final Rectangle2D getCachedBounds() {
        int n;
        int n2;
        if (this.cachedBounds != null) {
            Rectangle2D rectangle2D = this.cachedBounds;
            Intrinsics.checkNotNull((Object)rectangle2D);
            return rectangle2D;
        }
        Rectangle2D r = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        if (list.size() > 0) {
            List<Curve> list2 = this.curves;
            Intrinsics.checkNotNull(list2);
            Curve c2 = list2.get(0);
            r = new Rectangle2D.Double(c2.getX0(), c2.getY0(), 0.0, 0.0);
            n2 = 1;
            List<Curve> list3 = this.curves;
            Intrinsics.checkNotNull(list3);
            n = list3.size();
            while (n2 < n) {
                void i;
                List<Curve> list4 = this.curves;
                Intrinsics.checkNotNull(list4);
                Curve curve = list4.get((int)i);
                if (curve == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.kamaeleo.geom.Curve");
                }
                r = curve.enlarge(new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight()));
                ++i;
            }
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        n2 = 0;
        n = 0;
        Rectangle2D.Double it = double_;
        boolean bl = false;
        this.cachedBounds = it;
        return double_;
    }

    @Override
    public boolean contains(@NotNull Point2D p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this.contains(p.getX(), p.getY());
    }

    public final boolean contains(double x, double y) {
        if (!this.getCachedBounds().contains(x, y)) {
            return false;
        }
        int crossings = 0;
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        for (Curve c2 : list) {
            crossings += c2.crossingsFor(x, y);
        }
        return crossings & true;
    }

    @Override
    public boolean intersects(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public final boolean intersects(double x, double y, double w, double h) {
        if (w < 0.0 || h < 0.0) {
            return false;
        }
        if (!this.getCachedBounds().intersects(x, y, w, h)) {
            return false;
        }
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        Crossings c2 = Crossings.Companion.findCrossings(list, x, y, x + w, y + h);
        return c2 == null || !c2.isEmpty();
    }

    @Override
    @NotNull
    public PathIterator getPathIterator() {
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        return new AreaIterator(list, null);
    }

    @Override
    @NotNull
    public PathIterator getPathIterator(@Nullable AffineTransform at) {
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        return new AreaIterator(list, at);
    }

    @Override
    @NotNull
    public PathIterator getFlattenPathIterator(double flatness) {
        return new FlatteningPathIterator(this.getPathIterator(), flatness);
    }

    @NotNull
    public final Object clone() {
        return new Area(this);
    }

    public final boolean equals(@Nullable Area other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        AreaOp.XorOp xorOp = new AreaOp.XorOp();
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        List<Curve> list2 = other.curves;
        Intrinsics.checkNotNull(list2);
        List<Curve> c2 = xorOp.calculate(list, list2);
        return c2.isEmpty();
    }

    public final boolean contains(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public final boolean contains(double x, double y, double w, double h) {
        if (w < 0.0 || h < 0.0) {
            return false;
        }
        if (!this.getCachedBounds().contains(x, y, w, h)) {
            return false;
        }
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        Crossings c2 = Crossings.Companion.findCrossings(list, x, y, x + w, y + h);
        return c2 != null && c2.covers(y, y + h);
    }

    public Area() {
        this.curves = EmptyCurves;
    }

    public Area(@NotNull Shape s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.curves = s instanceof Area ? ((Area)s).curves : Area.Companion.pathToCurves(s.getPathIterator());
    }

    static {
        Companion = new Companion(null);
        EmptyCurves = new ArrayList();
    }

    @Override
    @Nullable
    public Rectangle getBounds() {
        return Shape.DefaultImpls.getBounds(this);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0013\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0018H\u0096\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lorg/kamaeleo/geom/Area$AreaIterator;", "Lorg/kamaeleo/geom/PathIterator;", "curves", "", "Lorg/kamaeleo/geom/Curve;", "at", "Lorg/kamaeleo/geom/AffineTransform;", "(Ljava/util/List;Lorg/kamaeleo/geom/AffineTransform;)V", "index", "", "isDone", "", "()Z", "prevcurve", "thiscurve", "transform", "windingRule", "getWindingRule", "()I", "currentSegment", "coords", "", "", "next", "", "kamaeleo"})
    public static final class AreaIterator
    implements PathIterator {
        private final AffineTransform transform;
        private final List<Curve> curves;
        private int index;
        private Curve prevcurve;
        private Curve thiscurve;

        @Override
        public int getWindingRule() {
            return 1;
        }

        @Override
        public boolean isDone() {
            return this.prevcurve == null && this.thiscurve == null;
        }

        @Override
        public void next() {
            if (this.prevcurve != null) {
                this.prevcurve = null;
            } else {
                this.prevcurve = this.thiscurve;
                int n = this.index;
                this.index = n + 1;
                if (this.index < this.curves.size()) {
                    Curve curve = this.thiscurve = this.curves.get(this.index);
                    Intrinsics.checkNotNull((Object)curve);
                    if (curve.getOrder() != 0) {
                        Curve curve2 = this.prevcurve;
                        Intrinsics.checkNotNull((Object)curve2);
                        double d = curve2.getX1();
                        Curve curve3 = this.thiscurve;
                        Intrinsics.checkNotNull((Object)curve3);
                        if (d == curve3.getX0()) {
                            Curve curve4 = this.prevcurve;
                            Intrinsics.checkNotNull((Object)curve4);
                            double d2 = curve4.getY1();
                            Curve curve5 = this.thiscurve;
                            Intrinsics.checkNotNull((Object)curve5);
                            if (d2 == curve5.getY0()) {
                                this.prevcurve = null;
                            }
                        }
                    }
                } else {
                    this.thiscurve = null;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int currentSegment(@NotNull float[] coords) {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            double[] dcoords = new double[6];
            int segtype = this.currentSegment(dcoords);
            int numpoints = segtype == 4 ? 0 : (segtype == 2 ? 2 : (segtype == 3 ? 3 : 1));
            int n = 0;
            int n2 = numpoints * 2;
            while (n < n2) {
                void i;
                coords[i] = (float)dcoords[i];
                ++i;
            }
            return segtype;
        }

        @Override
        public int currentSegment(@NotNull double[] coords) {
            int numpoints;
            int segtype;
            block9: {
                block6: {
                    block8: {
                        block7: {
                            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
                            segtype = 0;
                            numpoints = 0;
                            if (this.prevcurve == null) break block6;
                            if (this.thiscurve == null) break block7;
                            Curve curve = this.thiscurve;
                            Intrinsics.checkNotNull((Object)curve);
                            if (curve.getOrder() != 0) break block8;
                        }
                        return 4;
                    }
                    Curve curve = this.thiscurve;
                    Intrinsics.checkNotNull((Object)curve);
                    coords[0] = curve.getX0();
                    Curve curve2 = this.thiscurve;
                    Intrinsics.checkNotNull((Object)curve2);
                    coords[1] = curve2.getY0();
                    segtype = 1;
                    numpoints = 1;
                    break block9;
                }
                if (this.thiscurve == null) {
                    throw (Throwable)new NoSuchElementException("area iterator out of bounds");
                }
                Curve curve = this.thiscurve;
                Intrinsics.checkNotNull((Object)curve);
                segtype = curve.getSegment(coords);
                Curve curve3 = this.thiscurve;
                Intrinsics.checkNotNull((Object)curve3);
                numpoints = curve3.getOrder();
                if (numpoints == 0) {
                    numpoints = 1;
                }
            }
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, numpoints);
            }
            return segtype;
        }

        public AreaIterator(@NotNull List<Curve> curves, @Nullable AffineTransform at) {
            Intrinsics.checkNotNullParameter(curves, (String)"curves");
            this.curves = curves;
            this.transform = at;
            if (curves.size() >= 1) {
                this.thiscurve = curves.get(0);
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/kamaeleo/geom/Area$Companion;", "", "()V", "EmptyCurves", "", "Lorg/kamaeleo/geom/Curve;", "pathToCurves", "pi", "Lorg/kamaeleo/geom/PathIterator;", "kamaeleo"})
    public static final class Companion {
        private final List<Curve> pathToCurves(PathIterator pi) {
            ArrayList curves = new ArrayList();
            int windingRule = pi.getWindingRule();
            double[] coords = new double[23];
            double movx = 0.0;
            double movy = 0.0;
            double curx = 0.0;
            double cury = 0.0;
            while (!pi.isDone()) {
                double newy = 0.0;
                double newx = 0.0;
                switch (pi.currentSegment(coords)) {
                    case 0: {
                        Curve.Companion.insertLine(curves, curx, cury, movx, movy);
                        Companion companion = this;
                        boolean bl = false;
                        boolean bl2 = false;
                        Companion $this$run = companion;
                        boolean bl3 = false;
                        curx = movx = coords[0];
                        companion = this;
                        bl = false;
                        bl2 = false;
                        $this$run = companion;
                        boolean bl4 = false;
                        cury = movy = coords[1];
                        Curve.Companion.insertMove(curves, movx, movy);
                        break;
                    }
                    case 1: {
                        newx = coords[0];
                        newy = coords[1];
                        Curve.Companion.insertLine(curves, curx, cury, newx, newy);
                        curx = newx;
                        cury = newy;
                        break;
                    }
                    case 2: {
                        newx = coords[2];
                        newy = coords[3];
                        Curve.Companion.insertQuad(curves, curx, cury, coords);
                        curx = newx;
                        cury = newy;
                        break;
                    }
                    case 3: {
                        newx = coords[4];
                        newy = coords[5];
                        Curve.Companion.insertCubic(curves, curx, cury, coords);
                        curx = newx;
                        cury = newy;
                        break;
                    }
                    case 4: {
                        Curve.Companion.insertLine(curves, curx, cury, movx, movy);
                        curx = movx;
                        cury = movy;
                        break;
                    }
                }
                pi.next();
            }
            Curve.Companion.insertLine(curves, curx, cury, movx, movy);
            AreaOp operator = null;
            operator = windingRule == 0 ? (AreaOp)new AreaOp.EOWindOp() : (AreaOp)new AreaOp.NZWindOp();
            return operator.calculate(curves, EmptyCurves);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

