/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kamaeleo.geom.Geometry;
import org.kamaeleo.geom.Point2D;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B'\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u001a\u0010\u0007\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\f\u00a8\u0006\u0019"}, d2={"Lorg/kamaeleo/geom/Ellipse;", "Lorg/kamaeleo/geom/Geometry;", "()V", "x", "", "y", "width", "height", "(DDDD)V", "getHeight", "()D", "setHeight", "(D)V", "getWidth", "setWidth", "getX", "setX", "getY", "setY", "contains", "", "point", "Lorg/kamaeleo/geom/Point2D;", "toString", "", "kamaeleo"})
public final class Ellipse
implements Geometry {
    private double x;
    private double y;
    private double width;
    private double height;

    public final double getX() {
        return this.x;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final double getY() {
        return this.y;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public final double getWidth() {
        return this.width;
    }

    public final void setWidth(double d) {
        this.width = d;
    }

    public final double getHeight() {
        return this.height;
    }

    public final void setHeight(double d) {
        this.height = d;
    }

    @Override
    public boolean contains(@NotNull Point2D point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        double ellw = this.width;
        if (ellw <= 0.0) {
            return false;
        }
        double normx = (point.getX() - this.x) / ellw - 0.5;
        double ellh = this.height;
        if (ellh <= 0.0) {
            return false;
        }
        double normy = (point.getY() - this.y) / ellh - 0.5;
        return normx * normx + normy * normy < 0.25;
    }

    @NotNull
    public String toString() {
        return "Ellipse{x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + '}';
    }

    public Ellipse() {
    }

    public Ellipse(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }
}

