/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.geom.Crossings;
import org.kamaeleo.geom.Curve;
import org.kamaeleo.geom.Rectangle2D;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\"\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003H\u0016J\u0010\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0003H\u0016J\u0010\u0010(\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003H\u0016J\u0010\u0010)\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0003H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u00020\u00012\u0006\u00100\u001a\u000201H\u0016J\u0018\u00102\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00032\u0006\u00103\u001a\u00020\bH\u0016J\u0018\u00104\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00032\u0006\u00103\u001a\u00020\bH\u0016J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u000206H\u0016J\u0010\u00108\u001a\u00020\b2\u0006\u00109\u001a\u000201H\u0016J \u0010:\u001a\u00020\u00012\u0006\u0010;\u001a\u00020\u00032\u0006\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\bH\u0016J\u0018\u0010>\u001a\u00020\u00032\u0006\u0010?\u001a\u00020\u00032\u0006\u0010@\u001a\u00020\u0003H\u0016R\u0014\u0010\n\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u001a\u0010\u0016\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0012\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0012\"\u0004\b\u001c\u0010\u0019R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0012R\u0014\u0010\u001e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0012R\u0014\u0010 \u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0012\u00a8\u0006A"}, d2={"Lorg/kamaeleo/geom/Order1;", "Lorg/kamaeleo/geom/Curve;", "xTop", "", "yTop", "xBot", "yBot", "direction", "", "(DDDDI)V", "order", "getOrder", "()I", "reversedCurve", "getReversedCurve", "()Lorg/kamaeleo/geom/Curve;", "x0", "getX0", "()D", "x1", "getX1", "getXBot", "xMax", "getXMax", "setXMax", "(D)V", "xMin", "getXMin", "setXMin", "getXTop", "y0", "getY0", "y1", "getY1", "getYBot", "getYTop", "TforY", "y", "XforT", "t", "XforY", "YforT", "accumulateCrossings", "", "c", "Lorg/kamaeleo/geom/Crossings;", "compareTo", "other", "yrange", "", "dXforT", "deriv", "dYforT", "enlarge", "Lorg/kamaeleo/geom/Rectangle2D;", "r", "getSegment", "coords", "getSubCurve", "ystart", "yend", "dir", "nextVertical", "t0", "t1", "kamaeleo"})
public final class Order1
extends Curve {
    private double xMin;
    private double xMax;
    private final double xTop;
    private final double yTop;
    private final double xBot;
    private final double yBot;

    @Override
    public double getXMin() {
        return this.xMin;
    }

    public void setXMin(double d) {
        this.xMin = d;
    }

    @Override
    public double getXMax() {
        return this.xMax;
    }

    public void setXMax(double d) {
        this.xMax = d;
    }

    @Override
    @Nullable
    public Curve getReversedCurve() {
        return new Order1(this.getXTop(), this.getYTop(), this.getXBot(), this.getYBot(), -this.getDirection());
    }

    @Override
    public int getOrder() {
        return 1;
    }

    @Override
    public double getX0() {
        return this.getDirection() == 1 ? this.getXTop() : this.getXBot();
    }

    @Override
    public double getY0() {
        return this.getDirection() == 1 ? this.getYTop() : this.getYBot();
    }

    @Override
    public double getX1() {
        return this.getDirection() == -1 ? this.getXTop() : this.getXBot();
    }

    @Override
    public double getY1() {
        return this.getDirection() == -1 ? this.getYTop() : this.getYBot();
    }

    @Override
    public double YforT(double t) {
        return this.getYTop() + t * (this.getYBot() - this.getYTop());
    }

    @Override
    public double dXforT(double t, int deriv) {
        double d;
        switch (deriv) {
            case 0: {
                d = this.getXTop() + t * (this.getXBot() - this.getXTop());
                break;
            }
            case 1: {
                d = this.getXBot() - this.getXTop();
                break;
            }
            default: {
                d = 0.0;
            }
        }
        return d;
    }

    @Override
    public double dYforT(double t, int deriv) {
        double d;
        switch (deriv) {
            case 0: {
                d = this.getYTop() + t * (this.getYBot() - this.getYTop());
                break;
            }
            case 1: {
                d = this.getYBot() - this.getYTop();
                break;
            }
            default: {
                d = 0.0;
            }
        }
        return d;
    }

    @Override
    public double XforY(double y) {
        if (this.getXTop() == this.getXBot() || y <= this.getYTop()) {
            return this.getXTop();
        }
        return y >= this.getYBot() ? this.getXBot() : this.getXTop() + (y - this.getYTop()) * (this.getXBot() - this.getXTop()) / (this.getYBot() - this.getYTop());
    }

    @Override
    public boolean accumulateCrossings(@NotNull Crossings c2) {
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
        double xlo = c2.getXLo();
        double ylo = c2.getYLo();
        double xhi = c2.getXHi();
        double yhi = c2.getYHi();
        if (this.getXMin() >= xhi) {
            return false;
        }
        double xstart = 0.0;
        double ystart = 0.0;
        if (this.getYTop() < ylo) {
            if (this.getYBot() <= ylo) {
                return false;
            }
            ystart = ylo;
            xstart = this.XforY(ylo);
        } else {
            if (this.getYTop() >= yhi) {
                return false;
            }
            ystart = this.getYTop();
            xstart = this.getXTop();
        }
        double yend = 0.0;
        double xend = 0.0;
        if (this.getYBot() > yhi) {
            yend = yhi;
            xend = this.XforY(yhi);
        } else {
            yend = this.getYBot();
            xend = this.getXBot();
        }
        if (xstart >= xhi && xend >= xhi) {
            return false;
        }
        if (xstart > xlo || xend > xlo) {
            return true;
        }
        c2.record(ystart, yend, this.getDirection());
        return false;
    }

    @Override
    public double TforY(double y) {
        if (y <= this.getYTop()) {
            return 0.0;
        }
        return y >= this.getYBot() ? 1.0 : (y - this.getYTop()) / (this.getYBot() - this.getYTop());
    }

    @Override
    public double XforT(double t) {
        return this.getXTop() + t * (this.getXBot() - this.getXTop());
    }

    @Override
    @NotNull
    public Rectangle2D enlarge(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Rectangle2D r2 = r;
        r2 = r2.add(this.getXTop(), this.getYTop());
        return r2.add(this.getXBot(), this.getYBot());
    }

    @Override
    public double nextVertical(double t0, double t1) {
        return t1;
    }

    @Override
    @NotNull
    public Curve getSubCurve(double ystart, double yend, int dir) {
        if (ystart == this.getYTop() && yend == this.getYBot()) {
            return this.getWithDirection(dir);
        }
        if (this.getXTop() == this.getXBot()) {
            return new Order1(this.getXTop(), ystart, this.getXBot(), yend, dir);
        }
        double num = this.getXTop() - this.getXBot();
        double denom = this.getYTop() - this.getYBot();
        double xstart = this.getXTop() + (ystart - this.getYTop()) * num / denom;
        double xend = this.getXTop() + (yend - this.getYTop()) * num / denom;
        return new Order1(xstart, ystart, xend, yend, dir);
    }

    @Override
    public int compareTo(@NotNull Curve other, @NotNull double[] yrange) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)yrange, (String)"yrange");
        if (!(other instanceof Order1)) {
            return super.compareTo(other, yrange);
        }
        Curve c1 = other;
        if (yrange[1] <= yrange[0]) {
            throw (Throwable)new UnsupportedOperationException("yrange already screwed up...");
        }
        double d = yrange[1];
        double d2 = this.getYBot();
        boolean bl = false;
        d = Math.min(d, d2);
        d2 = c1.getYBot();
        bl = false;
        yrange[1] = Math.min(d, d2);
        if (yrange[1] <= yrange[0]) {
            throw (Throwable)new UnsupportedOperationException("backstepping from " + yrange[0] + " to " + yrange[1]);
        }
        if (this.getXMax() <= ((Order1)c1).getXMin()) {
            return this.getXMin() == ((Order1)c1).getXMax() ? 0 : -1;
        }
        if (this.getXMin() >= ((Order1)c1).getXMax()) {
            return 1;
        }
        double dxa = this.getXBot() - this.getXTop();
        double dya = this.getYBot() - this.getYTop();
        double dxb = c1.getXBot() - c1.getXTop();
        double dyb = c1.getYBot() - c1.getYTop();
        double denom = dxb * dya - dxa * dyb;
        double y = 0.0;
        if (denom != 0.0) {
            double num = (this.getXTop() - c1.getXTop()) * dya * dyb - this.getYTop() * dxa * dyb + c1.getYTop() * dxb * dya;
            y = num / denom;
            if (y <= yrange[0]) {
                double d3 = this.getYBot();
                double d4 = c1.getYBot();
                boolean bl2 = false;
                y = Math.min(d3, d4);
            } else {
                if (y < yrange[1]) {
                    yrange[1] = y;
                }
                double d5 = this.getYTop();
                double d6 = c1.getYTop();
                boolean bl3 = false;
                y = Math.max(d5, d6);
            }
        } else {
            double d7 = this.getYTop();
            double d8 = c1.getYTop();
            boolean bl4 = false;
            y = Math.max(d7, d8);
        }
        return Curve.Companion.orderof(this.XforY(y), c1.XforY(y));
    }

    @Override
    public int getSegment(@NotNull double[] coords) {
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        if (this.getDirection() == 1) {
            coords[0] = this.getXBot();
            coords[1] = this.getYBot();
        } else {
            coords[0] = this.getXTop();
            coords[1] = this.getYTop();
        }
        return 1;
    }

    @Override
    public double getXTop() {
        return this.xTop;
    }

    @Override
    public double getYTop() {
        return this.yTop;
    }

    @Override
    public double getXBot() {
        return this.xBot;
    }

    @Override
    public double getYBot() {
        return this.yBot;
    }

    public Order1(double xTop, double yTop, double xBot, double yBot, int direction) {
        super(direction);
        this.xTop = xTop;
        this.yTop = yTop;
        this.xBot = xBot;
        this.yBot = yBot;
        if (this.getXTop() < this.getXBot()) {
            this.setXMin(this.getXTop());
            this.setXMax(this.getXBot());
        } else {
            this.setXMin(this.getXBot());
            this.setXMax(this.getXTop());
        }
    }
}

