/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.geom.AffineTransform;
import org.kamaeleo.geom.Crossings;
import org.kamaeleo.geom.Path2D;
import org.kamaeleo.geom.PathIterator;
import org.kamaeleo.geom.Point;
import org.kamaeleo.geom.Point2D;
import org.kamaeleo.geom.Rectangle;
import org.kamaeleo.geom.Rectangle2D;
import org.kamaeleo.geom.Shape;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 @2\u00020\u0001:\u0002@AB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0007J\u001e\u0010'\u001a\u00020$2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020*2\u0006\u0010&\u001a\u00020*J&\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020*2\u0006\u0010&\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020*J\u0016\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0007J\u0011\u0010(\u001a\u00020)2\u0006\u0010-\u001a\u00020.H\u0086\u0002J\u0011\u0010(\u001a\u00020)2\u0006\u0010-\u001a\u00020/H\u0096\u0002J\u0011\u0010(\u001a\u00020)2\u0006\u00100\u001a\u00020\nH\u0086\u0002J*\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u00020*2\u0006\u00104\u001a\u00020*2\u0006\u00105\u001a\u00020*2\u0006\u00106\u001a\u00020*H\u0002J\u0010\u00107\u001a\u00020\u001a2\u0006\u00108\u001a\u00020*H\u0016J\u0012\u0010\u001b\u001a\u00020\u001a2\b\u00109\u001a\u0004\u0018\u00010:H\u0016J\u0018\u0010\u001b\u001a\u00020\u001a2\b\u00109\u001a\u0004\u0018\u00010:2\u0006\u00108\u001a\u00020*J\u0018\u0010;\u001a\u00020)2\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0007H\u0007J&\u0010<\u001a\u00020)2\u0006\u0010%\u001a\u00020*2\u0006\u0010&\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020*J\u0010\u0010<\u001a\u00020)2\u0006\u00100\u001a\u00020\nH\u0016J\u0006\u0010=\u001a\u00020$J\u0006\u0010>\u001a\u00020$J\u0016\u0010?\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0007R\u0011\u0010\t\u001a\u00020\n8G\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010\u0005\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001e\"\u0004\b\"\u0010 \u00a8\u0006B"}, d2={"Lorg/kamaeleo/geom/Polygon;", "Lorg/kamaeleo/geom/Shape;", "()V", "xpoints", "", "ypoints", "npoints", "", "([I[II)V", "boundingBox", "Lorg/kamaeleo/geom/Rectangle2D;", "getBoundingBox", "()Lorg/kamaeleo/geom/Rectangle2D;", "bounds", "Lorg/kamaeleo/geom/Rectangle;", "getBounds", "()Lorg/kamaeleo/geom/Rectangle;", "setBounds", "(Lorg/kamaeleo/geom/Rectangle;)V", "bounds2D", "getBounds2D", "getNpoints", "()I", "setNpoints", "(I)V", "pathIterator", "Lorg/kamaeleo/geom/PathIterator;", "getPathIterator", "()Lorg/kamaeleo/geom/PathIterator;", "getXpoints", "()[I", "setXpoints", "([I)V", "getYpoints", "setYpoints", "addPoint", "", "x", "y", "calculateBounds", "contains", "", "", "w", "h", "p", "Lorg/kamaeleo/geom/Point;", "Lorg/kamaeleo/geom/Point2D;", "r", "getCrossings", "Lorg/kamaeleo/geom/Crossings;", "xlo", "ylo", "xhi", "yhi", "getFlattenPathIterator", "flatness", "at", "Lorg/kamaeleo/geom/AffineTransform;", "inside", "intersects", "invalidate", "reset", "updateBounds", "Companion", "PolygonPathIterator", "kamaeleo"})
public final class Polygon
implements Shape {
    private int npoints;
    @NotNull
    private int[] xpoints;
    @NotNull
    private int[] ypoints;
    @Nullable
    private Rectangle bounds;
    private static final long serialVersionUID = -6460061437900069969L;
    private static final int MIN_LENGTH = 4;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final int getNpoints() {
        return this.npoints;
    }

    public final void setNpoints(int n) {
        this.npoints = n;
    }

    @NotNull
    public final int[] getXpoints() {
        return this.xpoints;
    }

    public final void setXpoints(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.xpoints = nArray;
    }

    @NotNull
    public final int[] getYpoints() {
        return this.ypoints;
    }

    public final void setYpoints(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.ypoints = nArray;
    }

    @Override
    @Nullable
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(@Nullable Rectangle rectangle) {
        this.bounds = rectangle;
    }

    public final void reset() {
        this.npoints = 0;
        this.setBounds(null);
    }

    public final void invalidate() {
        this.setBounds(null);
    }

    public final void addPoint(int x, int y) {
        if (this.npoints >= this.xpoints.length || this.npoints >= this.ypoints.length) {
            int newLength = this.npoints * 2;
            if (newLength < 4) {
                newLength = 4;
            } else if ((newLength & newLength - 1) != 0) {
                int n = newLength;
                boolean bl = false;
                newLength = Integer.highestOneBit(n);
            }
            this.xpoints = Path2D.Companion.copyOf(this.xpoints, newLength);
            this.ypoints = Path2D.Companion.copyOf(this.ypoints, newLength);
        }
        this.xpoints[this.npoints] = x;
        this.ypoints[this.npoints] = y;
        int n = this.npoints;
        this.npoints = n + 1;
        if (this.getBounds() != null) {
            this.updateBounds(x, y);
        }
    }

    public final void updateBounds(int x, int y) {
        boolean bl;
        int n;
        int n2;
        double d = x;
        Rectangle rectangle = this.getBounds();
        Intrinsics.checkNotNull((Object)rectangle);
        if (d < rectangle.getX()) {
            Rectangle rectangle2 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle2);
            Rectangle rectangle3 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle3);
            int n3 = rectangle3.getIwidth();
            Rectangle rectangle4 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle4);
            rectangle2.setIwidth(n3 + (rectangle4.getIx() - x));
            Rectangle rectangle5 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle5);
            rectangle5.setIx(x);
        } else {
            Rectangle rectangle6 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle6);
            Rectangle rectangle7 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle7);
            n2 = rectangle7.getIwidth();
            Rectangle rectangle8 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle8);
            n = x - rectangle8.getIx();
            bl = false;
            rectangle6.setIwidth(Math.max(n2, n));
        }
        double d2 = y;
        Rectangle rectangle9 = this.getBounds();
        Intrinsics.checkNotNull((Object)rectangle9);
        if (d2 < rectangle9.getY()) {
            Rectangle rectangle10 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle10);
            Rectangle rectangle11 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle11);
            int n4 = rectangle11.getIheight();
            Rectangle rectangle12 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle12);
            rectangle10.setIheight(n4 + (rectangle12.getIy() - y));
            Rectangle rectangle13 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle13);
            rectangle13.setIy(y);
        } else {
            Rectangle rectangle14 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle14);
            Rectangle rectangle15 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle15);
            n2 = rectangle15.getIheight();
            Rectangle rectangle16 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle16);
            n = y - rectangle16.getIy();
            bl = false;
            rectangle14.setIheight(Math.max(n2, n));
        }
    }

    public final boolean contains(@NotNull Point p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this.contains(p.getX(), p.getY());
    }

    public final boolean contains(int x, int y) {
        return this.contains((double)x, (double)y);
    }

    public final boolean contains(double x, double y) {
        if (this.npoints <= 2 || !this.getBoundingBox().contains(x, y)) {
            return false;
        }
        int hits = 0;
        int lastx = this.xpoints[this.npoints - 1];
        int lasty = this.ypoints[this.npoints - 1];
        int curx = 0;
        int cury = 0;
        int i = 0;
        while (i < this.npoints) {
            curx = this.xpoints[i];
            cury = this.ypoints[i];
            if (cury == lasty) {
                lastx = curx;
                lasty = cury;
                ++i;
                continue;
            }
            int leftx = 0;
            if (curx < lastx) {
                if (x >= (double)lastx) {
                    lastx = curx;
                    lasty = cury;
                    ++i;
                    continue;
                }
                leftx = curx;
            } else {
                if (x >= (double)curx) {
                    lastx = curx;
                    lasty = cury;
                    ++i;
                    continue;
                }
                leftx = lastx;
            }
            double test1 = 0.0;
            double test2 = 0.0;
            if (cury < lasty) {
                if (y < (double)cury || y >= (double)lasty) {
                    lastx = curx;
                    lasty = cury;
                    ++i;
                    continue;
                }
                if (x < (double)leftx) {
                    ++hits;
                    lastx = curx;
                    lasty = cury;
                    ++i;
                    continue;
                }
                test1 = x - (double)curx;
                test2 = y - (double)cury;
            } else {
                if (y < (double)lasty || y >= (double)cury) {
                    lastx = curx;
                    lasty = cury;
                    ++i;
                    continue;
                }
                if (x < (double)leftx) {
                    ++hits;
                    lastx = curx;
                    lasty = cury;
                    ++i;
                    continue;
                }
                test1 = x - (double)lastx;
                test2 = y - (double)lasty;
            }
            if (test1 < test2 / (double)(lasty - cury) * (double)(lastx - curx)) {
                ++hits;
            }
            lastx = curx;
            lasty = cury;
            ++i;
        }
        return hits & true;
    }

    @Deprecated(message="As of JDK version 1.1,\n      replaced by <code>getBounds()</code>.")
    @NotNull
    public final Rectangle2D getBoundingBox() {
        if (this.npoints == 0) {
            return new Rectangle();
        }
        if (this.getBounds() == null) {
            this.calculateBounds(this.xpoints, this.ypoints, this.npoints);
        }
        Rectangle rectangle = this.getBounds();
        Intrinsics.checkNotNull((Object)rectangle);
        return rectangle.getBounds2D();
    }

    /*
     * WARNING - void declaration
     */
    public final void calculateBounds(@NotNull int[] xpoints, @NotNull int[] ypoints, int npoints) {
        Intrinsics.checkNotNullParameter((Object)xpoints, (String)"xpoints");
        Intrinsics.checkNotNullParameter((Object)ypoints, (String)"ypoints");
        int boundsMinX = Integer.MAX_VALUE;
        int boundsMinY = Integer.MAX_VALUE;
        int boundsMaxX = Integer.MIN_VALUE;
        int boundsMaxY = Integer.MIN_VALUE;
        int n = 0;
        int n2 = npoints;
        while (n < n2) {
            void i;
            int x = xpoints[i];
            boolean bl = false;
            boundsMinX = Math.min(boundsMinX, x);
            bl = false;
            boundsMaxX = Math.max(boundsMaxX, x);
            int y = ypoints[i];
            boolean bl2 = false;
            boundsMinY = Math.min(boundsMinY, y);
            bl2 = false;
            boundsMaxY = Math.max(boundsMaxY, y);
            ++i;
        }
        this.setBounds(new Rectangle(boundsMinX, boundsMinY, boundsMaxX - boundsMinX, boundsMaxY - boundsMinY));
    }

    @Deprecated(message="As of JDK version 1.1,\n      replaced by <code>contains(int, int)</code>.")
    public final boolean inside(int x, int y) {
        return this.contains((double)x, (double)y);
    }

    @Override
    @NotNull
    public Rectangle2D getBounds2D() {
        return this.getBoundingBox();
    }

    @Override
    public boolean contains(@NotNull Point2D p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean intersects(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public final boolean intersects(double x, double y, double w, double h) {
        if (this.npoints <= 0 || !this.getBoundingBox().intersects(x, y, w, h)) {
            return false;
        }
        Crossings cross = this.getCrossings(x, y, x + w, y + h);
        return cross == null || !cross.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private final Crossings getCrossings(double xlo, double ylo, double xhi, double yhi) {
        Crossings cross = new Crossings.EvenOdd(xlo, ylo, xhi, yhi);
        int lastx = this.xpoints[this.npoints - 1];
        int lasty = this.ypoints[this.npoints - 1];
        int n = 0;
        int n2 = this.npoints;
        while (n < n2) {
            void i;
            int curx = this.xpoints[i];
            int cury = this.ypoints[i];
            if (cross.accumulateLine(lastx, lasty, curx, cury)) {
                return null;
            }
            lastx = curx;
            lasty = cury;
            ++i;
        }
        return cross;
    }

    @Override
    @NotNull
    public PathIterator getPathIterator() {
        return this.getPathIterator(null);
    }

    @Override
    @NotNull
    public PathIterator getPathIterator(@Nullable AffineTransform at) {
        return new PolygonPathIterator(this, at);
    }

    @Override
    @NotNull
    public PathIterator getFlattenPathIterator(double flatness) {
        return this.getPathIterator(null, flatness);
    }

    @NotNull
    public final PathIterator getPathIterator(@Nullable AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    public final boolean contains(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public final boolean contains(double x, double y, double w, double h) {
        if (this.npoints <= 0 || !this.getBoundingBox().intersects(x, y, w, h)) {
            return false;
        }
        Crossings cross = this.getCrossings(x, y, x + w, y + h);
        return cross != null && cross.covers(y, y + h);
    }

    public Polygon() {
        this.xpoints = new int[4];
        this.ypoints = new int[4];
    }

    public Polygon(@NotNull int[] xpoints, @NotNull int[] ypoints, int npoints) {
        Intrinsics.checkNotNullParameter((Object)xpoints, (String)"xpoints");
        Intrinsics.checkNotNullParameter((Object)ypoints, (String)"ypoints");
        if (npoints > xpoints.length || npoints > ypoints.length) {
            throw (Throwable)new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        if (npoints < 0) {
            throw (Throwable)new RuntimeException("npoints < 0");
        }
        this.npoints = npoints;
        this.xpoints = Path2D.Companion.copyOf(xpoints, npoints);
        this.ypoints = Path2D.Companion.copyOf(ypoints, npoints);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0013\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u001aH\u0016J\t\u0010\u001b\u001a\u00020\u001cH\u0096\u0002R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\n\u00a8\u0006\u001d"}, d2={"Lorg/kamaeleo/geom/Polygon$PolygonPathIterator;", "Lorg/kamaeleo/geom/PathIterator;", "poly", "Lorg/kamaeleo/geom/Polygon;", "at", "Lorg/kamaeleo/geom/AffineTransform;", "(Lorg/kamaeleo/geom/Polygon;Lorg/kamaeleo/geom/AffineTransform;)V", "index", "", "getIndex", "()I", "setIndex", "(I)V", "isDone", "", "()Z", "getPoly", "()Lorg/kamaeleo/geom/Polygon;", "transform", "getTransform", "()Lorg/kamaeleo/geom/AffineTransform;", "windingRule", "getWindingRule", "currentSegment", "coords", "", "", "next", "", "kamaeleo"})
    public static final class PolygonPathIterator
    implements PathIterator {
        @Nullable
        private final AffineTransform transform;
        private int index;
        @NotNull
        private final Polygon poly;

        @Nullable
        public final AffineTransform getTransform() {
            return this.transform;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        @Override
        public int getWindingRule() {
            return Path2D.Companion.getWIND_EVEN_ODD();
        }

        @Override
        public boolean isDone() {
            return this.index > this.poly.getNpoints();
        }

        @Override
        public void next() {
            int n = this.index;
            this.index = n + 1;
        }

        @Override
        public int currentSegment(@NotNull float[] coords) {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            if (this.index >= this.poly.getNpoints()) {
                return 4;
            }
            coords[0] = this.poly.getXpoints()[this.index];
            coords[1] = this.poly.getYpoints()[this.index];
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }

        @Override
        public int currentSegment(@NotNull double[] coords) {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            if (this.index >= this.poly.getNpoints()) {
                return 4;
            }
            coords[0] = this.poly.getXpoints()[this.index];
            coords[1] = this.poly.getYpoints()[this.index];
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }

        @NotNull
        public final Polygon getPoly() {
            return this.poly;
        }

        public PolygonPathIterator(@NotNull Polygon poly, @Nullable AffineTransform at) {
            Intrinsics.checkNotNullParameter((Object)poly, (String)"poly");
            this.poly = poly;
            this.transform = at;
            if (this.poly.getNpoints() == 0) {
                this.index = 1;
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/kamaeleo/geom/Polygon$Companion;", "", "()V", "MIN_LENGTH", "", "serialVersionUID", "", "kamaeleo"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

