/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom.curve;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.geom.curve.BinaryCurveApproximationAlgorithm;
import org.kamaeleo.geom.curve.ControlPath;
import org.kamaeleo.geom.curve.GroupIterator;
import org.kamaeleo.geom.curve.MultiPath;
import org.kamaeleo.geom.curve.ParametricCurve;
import org.kamaeleo.geom.curve.Point;
import org.kamaeleo.geom.curve.ValueVector;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\n\b\u0016\u0018\u0000 -2\u00020\u0001:\u0001-B\u001b\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\bJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$H\u0016J\u0006\u0010%\u001a\u00020\bJ\u0006\u0010&\u001a\u00020\bJ\b\u0010'\u001a\u00020\u001fH\u0016J\u000e\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\bJ\u0016\u0010*\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020\bJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006."}, d2={"Lorg/kamaeleo/geom/curve/BSpline;", "Lorg/kamaeleo/geom/curve/ParametricCurve;", "cp", "Lorg/kamaeleo/geom/curve/ControlPath;", "gi", "Lorg/kamaeleo/geom/curve/GroupIterator;", "(Lorg/kamaeleo/geom/curve/ControlPath;Lorg/kamaeleo/geom/curve/GroupIterator;)V", "degree", "", "knotVector", "Lorg/kamaeleo/geom/curve/ValueVector;", "knotVectorType", "limit", "sampleLimit", "getSampleLimit", "()I", "setSampleLimit", "(I)V", "t_max", "", "t_min", "useDefaultInterval", "", "getUseDefaultInterval", "()Z", "setUseDefaultInterval", "(Z)V", "N", "t", "i", "appendTo", "", "mp", "Lorg/kamaeleo/geom/curve/MultiPath;", "eval", "p", "", "getDegree", "getKnotVectorType", "resetMemory", "setDegree", "d", "setInterval", "setKnotVectorType", "type", "Companion", "kamaeleo"})
public class BSpline
extends ParametricCurve {
    private final ValueVector knotVector = new ValueVector(new double[]{0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0}, 8);
    private double t_min;
    private double t_max = 1.0;
    private int sampleLimit = 1;
    private int degree = 4;
    private int knotVectorType;
    private boolean useDefaultInterval = true;
    private static final int UNIFORM_CLAMPED = 0;
    private static final int UNIFORM_UNCLAMPED = 1;
    private static final int NON_UNIFORM = 2;
    private static int[] a;
    private static int[] c;
    private static double[] knot;
    @NotNull
    public static final Companion Companion;

    @Override
    public int getSampleLimit() {
        return this.sampleLimit;
    }

    public void setSampleLimit(int limit) {
        this.sampleLimit = limit;
    }

    public final boolean getUseDefaultInterval() {
        return this.useDefaultInterval;
    }

    public final void setUseDefaultInterval(boolean bl) {
        this.useDefaultInterval = bl;
    }

    public final void setInterval(double t_min, double t_max) {
        this.t_min = t_min;
        this.t_max = t_max;
    }

    public final double t_min() {
        return this.t_min;
    }

    public final double t_max() {
        return this.t_max;
    }

    public final int getDegree() {
        return this.degree - 1;
    }

    public final void setDegree(int d) {
        this.degree = d + 1;
    }

    public final int getKnotVectorType() {
        return this.knotVectorType;
    }

    public final void setKnotVectorType(int type) {
        this.knotVectorType = type;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void appendTo(@NotNull MultiPath mp) {
        Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
        GroupIterator groupIterator = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator);
        ControlPath controlPath = this.getCp();
        Intrinsics.checkNotNull((Object)controlPath);
        if (!groupIterator.isInRange(0, controlPath.numPoints())) {
            return;
        }
        GroupIterator groupIterator2 = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator2);
        int numPts = groupIterator2.getGroupSize();
        int f = numPts - this.degree;
        if (f < 0) {
            return;
        }
        int x = numPts + this.degree;
        if (knot.length < x) {
            knot = new double[2 * x];
        }
        double t1 = this.t_min;
        double t2 = this.t_max;
        if (this.knotVectorType == 2) {
            if (this.knotVector.size() != x) {
                return;
            }
            BSpline.knot[0] = this.knotVector.get(0);
            int n = 1;
            int n2 = x;
            while (n < n2) {
                void i;
                BSpline.knot[i] = this.knotVector.get((int)i);
                if (knot[i] < knot[i - true]) {
                    return;
                }
                ++i;
            }
        } else if (this.knotVectorType == 1) {
            double grad = 1.0 / (double)(x - 1);
            int n = 0;
            int n3 = x;
            while (n < n3) {
                void i;
                BSpline.knot[i] = (double)i * grad;
                ++i;
            }
            if (this.useDefaultInterval) {
                t1 = (double)(this.degree - 1) * grad;
                t2 = 1.0 - (double)(this.degree - 1) * grad;
            }
        } else if (this.knotVectorType == 0) {
            int i;
            int grad = 0;
            int n = this.degree;
            while (grad < n) {
                void i2;
                BSpline.knot[i2] = 0.0;
                ++i2;
            }
            int j = this.degree;
            double grad2 = 1.0 / (double)(f + 1);
            int n4 = 1;
            int n5 = f;
            if (n4 <= n5) {
                while (true) {
                    BSpline.knot[j++] = (double)i * grad2;
                    if (i == n5) break;
                    ++i;
                }
            }
            n5 = x;
            for (i = j; i < n5; ++i) {
                BSpline.knot[i] = 1.0;
            }
            if (this.useDefaultInterval) {
                t1 = 0.0;
                t2 = 1.0;
            }
        }
        if (a.length < this.degree) {
            a = new int[2 * this.degree];
            c = new int[2 * this.degree];
        }
        double[] p = new double[mp.getDimension() + 1];
        p[mp.getDimension()] = t1;
        this.eval(p);
        if (this.getConnect()) {
            mp.lineTo(p);
        } else {
            mp.moveTo(p);
        }
        BinaryCurveApproximationAlgorithm.INSTANCE.genPts(this, t1, t2, mp);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void eval(@NotNull double[] p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        int dim = p.length - 1;
        double t = p[dim];
        GroupIterator groupIterator = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator);
        int numPts = groupIterator.getGroupSize();
        GroupIterator groupIterator2 = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator2);
        groupIterator2.set(0, 0);
        int n = 0;
        int n2 = numPts;
        while (n < n2) {
            void i;
            double w = this.N(t, (int)i);
            ControlPath controlPath = this.getCp();
            Intrinsics.checkNotNull((Object)controlPath);
            GroupIterator groupIterator3 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator3);
            Point point = controlPath.getPoint(groupIterator3.next());
            Intrinsics.checkNotNull((Object)point);
            double[] loc = point.getLocation();
            int n3 = 0;
            int n4 = dim;
            while (n3 < n4) {
                void j;
                void v5 = j;
                p[v5] = p[v5] + loc[j] * w;
                ++j;
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final double N(double t, int i) {
        double d = 0.0;
        int n = 0;
        int n2 = this.degree;
        block0: while (n < n2) {
            void j;
            double t1 = knot[i + j];
            double t2 = knot[i + j + 1];
            if (t >= t1 && t <= t2 && t1 != t2) {
                int k;
                int dm2 = this.degree - 2;
                int n3 = this.degree - j - 1;
                int n4 = 0;
                while (n3 >= 0) {
                    BSpline.a[k] = 0;
                    --k;
                }
                if (j > 0) {
                    n4 = j;
                    for (k = 0; k < n4; ++k) {
                        BSpline.c[k] = k;
                    }
                    BSpline.c[j] = Integer.MAX_VALUE;
                } else {
                    BSpline.c[0] = dm2;
                    BSpline.c[1] = this.degree;
                }
                int z = 0;
                while (true) {
                    if (c[z] < c[z + 1] - 1) {
                        int g;
                        double e = 1.0;
                        int bc = 0;
                        int y = dm2 - j;
                        void p = j - true;
                        int m = dm2;
                        int n5 = this.degree;
                        while (m >= 0) {
                            int w;
                            if (p >= 0 && c[p] == m) {
                                w = i + bc;
                                double kd = knot[w + n5];
                                e *= (kd - t) / (kd - knot[w + 1]);
                                ++bc;
                                --p;
                            } else {
                                w = i + a[y];
                                double kw = knot[w];
                                e *= (t - kw) / (knot[w + n5 - 1] - kw);
                                --y;
                            }
                            --m;
                            --n5;
                        }
                        if (j > 0) {
                            int n6;
                            g = 0;
                            boolean reset = false;
                            while (true) {
                                int n7 = ++g;
                                n6 = a[n7];
                                a[n7] = n6 + 1;
                                if (a[g] <= j) break;
                                reset = true;
                            }
                            if (reset) {
                                n6 = g - 1;
                                boolean bl = false;
                                while (n6 >= 0) {
                                    void h;
                                    BSpline.a[h] = a[g];
                                    --h;
                                }
                            }
                        }
                        d += e;
                        int n8 = z;
                        g = c[n8];
                        c[n8] = g + 1;
                        if (c[z] > dm2) break block0;
                        g = 0;
                        int n9 = z;
                        while (g < n9) {
                            void k2;
                            BSpline.c[k2] = k2;
                            ++k2;
                        }
                        z = 0;
                        continue;
                    }
                    ++z;
                }
            }
            ++j;
        }
        return d;
    }

    @Override
    public void resetMemory() {
        if (a.length > 0) {
            a = new int[0];
            c = new int[0];
        }
        if (knot.length > 0) {
            knot = new double[0];
        }
    }

    public BSpline(@Nullable ControlPath cp, @Nullable GroupIterator gi) {
        super(cp, gi);
    }

    static {
        Companion = new Companion(null);
        a = new int[0];
        c = new int[0];
        knot = new double[0];
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/kamaeleo/geom/curve/BSpline$Companion;", "", "()V", "NON_UNIFORM", "", "UNIFORM_CLAMPED", "UNIFORM_UNCLAMPED", "a", "", "c", "knot", "", "kamaeleo"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

