/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom.curve;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.geom.curve.BinaryCurveApproximationAlgorithm;
import org.kamaeleo.geom.curve.ControlPath;
import org.kamaeleo.geom.curve.GroupIterator;
import org.kamaeleo.geom.curve.MultiPath;
import org.kamaeleo.geom.curve.ParametricCurve;
import org.kamaeleo.geom.curve.Point;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/kamaeleo/geom/curve/CardinalSpline;", "Lorg/kamaeleo/geom/curve/ParametricCurve;", "cp", "Lorg/kamaeleo/geom/curve/ControlPath;", "gi", "Lorg/kamaeleo/geom/curve/GroupIterator;", "(Lorg/kamaeleo/geom/curve/ControlPath;Lorg/kamaeleo/geom/curve/GroupIterator;)V", "alpha", "", "getAlpha", "()D", "setAlpha", "(D)V", "sampleLimit", "", "getSampleLimit", "()I", "appendTo", "", "mp", "Lorg/kamaeleo/geom/curve/MultiPath;", "eval", "p", "", "Companion", "kamaeleo"})
public final class CardinalSpline
extends ParametricCurve {
    private double alpha = 0.5;
    private static final double[][] pt;
    @NotNull
    public static final Companion Companion;

    public final double getAlpha() {
        return this.alpha;
    }

    public final void setAlpha(double d) {
        this.alpha = d;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void appendTo(@NotNull MultiPath mp) {
        Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
        GroupIterator groupIterator = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator);
        ControlPath controlPath = this.getCp();
        Intrinsics.checkNotNull((Object)controlPath);
        if (!groupIterator.isInRange(0, controlPath.numPoints())) {
            return;
        }
        GroupIterator groupIterator2 = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator2);
        if (groupIterator2.getGroupSize() < 4) {
            return;
        }
        GroupIterator groupIterator3 = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator3);
        groupIterator3.set(0, 0);
        int n = 0;
        int n2 = 3;
        while (n <= n2) {
            void i;
            ControlPath controlPath2 = this.getCp();
            Intrinsics.checkNotNull((Object)controlPath2);
            GroupIterator groupIterator4 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator4);
            Point point = controlPath2.getPoint(groupIterator4.next());
            Intrinsics.checkNotNull((Object)point);
            CardinalSpline.pt[i] = point.getLocation();
            ++i;
        }
        double[] d = new double[mp.getDimension() + 1];
        this.eval(d);
        if (this.getConnect()) {
            mp.lineTo(d);
        } else {
            mp.moveTo(d);
        }
        GroupIterator groupIterator5 = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator5);
        groupIterator5.set(0, 0);
        while (true) {
            GroupIterator groupIterator6 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator6);
            int index_i = groupIterator6.index_i();
            GroupIterator groupIterator7 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator7);
            int count_j = groupIterator7.count_j();
            int n3 = 0;
            int n4 = 3;
            while (n3 <= n4) {
                void i;
                GroupIterator groupIterator8 = this.getGi();
                Intrinsics.checkNotNull((Object)groupIterator8);
                if (!groupIterator8.hasNext()) {
                    return;
                }
                ControlPath controlPath3 = this.getCp();
                Intrinsics.checkNotNull((Object)controlPath3);
                GroupIterator groupIterator9 = this.getGi();
                Intrinsics.checkNotNull((Object)groupIterator9);
                Point point = controlPath3.getPoint(groupIterator9.next());
                Intrinsics.checkNotNull((Object)point);
                CardinalSpline.pt[i] = point.getLocation();
                ++i;
            }
            GroupIterator groupIterator10 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator10);
            groupIterator10.set(index_i, count_j);
            GroupIterator groupIterator11 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator11);
            groupIterator11.next();
            BinaryCurveApproximationAlgorithm.INSTANCE.genPts(this, 0.0, 1.0, mp);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void eval(@NotNull double[] p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        double t = p[p.length - 1];
        double t2 = t * t;
        double t3 = t2 * t;
        double a = (double)2 * t3 - (double)3 * t2 + 1.0;
        double b = (double)-2 * t3 + (double)3 * t2;
        double c2 = this.alpha * (t3 - (double)2 * t2 + t);
        double d = this.alpha * (t3 - t2);
        int n = 0;
        int n2 = p.length - 1;
        while (n < n2) {
            void i;
            double[] dArray = pt[1];
            Intrinsics.checkNotNull((Object)dArray);
            double d2 = a * dArray[i];
            double[] dArray2 = pt[2];
            Intrinsics.checkNotNull((Object)dArray2);
            double d3 = d2 + b * dArray2[i];
            double[] dArray3 = pt[2];
            Intrinsics.checkNotNull((Object)dArray3);
            double d4 = dArray3[i];
            double[] dArray4 = pt[0];
            Intrinsics.checkNotNull((Object)dArray4);
            double d5 = d3 + c2 * (d4 - dArray4[i]);
            double[] dArray5 = pt[3];
            Intrinsics.checkNotNull((Object)dArray5);
            double d6 = dArray5[i];
            double[] dArray6 = pt[1];
            Intrinsics.checkNotNull((Object)dArray6);
            p[i] = d5 + d * (d6 - dArray6[i]);
            ++i;
        }
    }

    @Override
    public int getSampleLimit() {
        return 1;
    }

    public CardinalSpline(@Nullable ControlPath cp, @Nullable GroupIterator gi) {
        super(cp, gi);
    }

    static {
        Companion = new Companion(null);
        pt = new double[4][];
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/kamaeleo/geom/curve/CardinalSpline$Companion;", "", "()V", "pt", "", "", "[[D", "kamaeleo"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

