/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom.curve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.geom.curve.BinaryCurveApproximationAlgorithm;
import org.kamaeleo.geom.curve.ControlPath;
import org.kamaeleo.geom.curve.GroupIterator;
import org.kamaeleo.geom.curve.MultiPath;
import org.kamaeleo.geom.curve.ParametricCurve;
import org.kamaeleo.geom.curve.Point;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\tH\u0016R\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/kamaeleo/geom/curve/CatmullRomSpline;", "Lorg/kamaeleo/geom/curve/ParametricCurve;", "cp", "Lorg/kamaeleo/geom/curve/ControlPath;", "gi", "Lorg/kamaeleo/geom/curve/GroupIterator;", "(Lorg/kamaeleo/geom/curve/ControlPath;Lorg/kamaeleo/geom/curve/GroupIterator;)V", "pt", "", "", "[[D", "sampleLimit", "", "getSampleLimit", "()I", "appendTo", "", "mp", "Lorg/kamaeleo/geom/curve/MultiPath;", "eval", "p", "kamaeleo"})
public final class CatmullRomSpline
extends ParametricCurve {
    private final double[][] pt = new double[4][];

    /*
     * WARNING - void declaration
     */
    @Override
    public void appendTo(@NotNull MultiPath mp) {
        Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
        GroupIterator groupIterator = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator);
        ControlPath controlPath = this.getCp();
        Intrinsics.checkNotNull((Object)controlPath);
        if (!groupIterator.isInRange(0, controlPath.numPoints())) {
            return;
        }
        GroupIterator groupIterator2 = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator2);
        if (groupIterator2.getGroupSize() < 4) {
            return;
        }
        GroupIterator groupIterator3 = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator3);
        groupIterator3.set(0, 0);
        int n = 0;
        int n2 = 3;
        while (n <= n2) {
            void i;
            ControlPath controlPath2 = this.getCp();
            Intrinsics.checkNotNull((Object)controlPath2);
            GroupIterator groupIterator4 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator4);
            Point point = controlPath2.getPoint(groupIterator4.next());
            Intrinsics.checkNotNull((Object)point);
            this.pt[i] = point.getLocation();
            ++i;
        }
        double[] d = new double[mp.getDimension() + 1];
        this.eval(d);
        if (this.getConnect()) {
            mp.lineTo(d);
        } else {
            mp.moveTo(d);
        }
        GroupIterator groupIterator5 = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator5);
        groupIterator5.set(0, 0);
        while (true) {
            GroupIterator groupIterator6 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator6);
            int index_i = groupIterator6.index_i();
            GroupIterator groupIterator7 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator7);
            int count_j = groupIterator7.count_j();
            int n3 = 0;
            int n4 = 3;
            while (n3 <= n4) {
                void i;
                GroupIterator groupIterator8 = this.getGi();
                Intrinsics.checkNotNull((Object)groupIterator8);
                if (!groupIterator8.hasNext()) {
                    return;
                }
                ControlPath controlPath3 = this.getCp();
                Intrinsics.checkNotNull((Object)controlPath3);
                GroupIterator groupIterator9 = this.getGi();
                Intrinsics.checkNotNull((Object)groupIterator9);
                Point point = controlPath3.getPoint(groupIterator9.next());
                Intrinsics.checkNotNull((Object)point);
                this.pt[i] = point.getLocation();
                ++i;
            }
            GroupIterator groupIterator10 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator10);
            groupIterator10.set(index_i, count_j);
            GroupIterator groupIterator11 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator11);
            groupIterator11.next();
            BinaryCurveApproximationAlgorithm.INSTANCE.genPts(this, 0.0, 1.0, mp);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void eval(@NotNull double[] p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        double t = p[p.length - 1];
        double t2 = t * t;
        double t3 = t2 * t;
        int n = 0;
        int n2 = p.length - 1;
        while (n < n2) {
            void i;
            double[] dArray = this.pt[3];
            Intrinsics.checkNotNull((Object)dArray);
            double d = dArray[i];
            double[] dArray2 = this.pt[0];
            Intrinsics.checkNotNull((Object)dArray2);
            double d2 = d - dArray2[i];
            double d3 = 3;
            double[] dArray3 = this.pt[1];
            Intrinsics.checkNotNull((Object)dArray3);
            double d4 = dArray3[i];
            double[] dArray4 = this.pt[2];
            Intrinsics.checkNotNull((Object)dArray4);
            double d5 = (d2 + d3 * (d4 - dArray4[i])) * t3;
            double d6 = 2;
            double[] dArray5 = this.pt[0];
            Intrinsics.checkNotNull((Object)dArray5);
            double d7 = dArray5[i];
            double d8 = 2;
            double[] dArray6 = this.pt[2];
            Intrinsics.checkNotNull((Object)dArray6);
            double d9 = d6 * (d7 + d8 * dArray6[i]);
            double d10 = 5;
            double[] dArray7 = this.pt[1];
            Intrinsics.checkNotNull((Object)dArray7);
            double d11 = d9 - d10 * dArray7[i];
            double[] dArray8 = this.pt[3];
            Intrinsics.checkNotNull((Object)dArray8);
            double d12 = d5 + (d11 - dArray8[i]) * t2;
            double[] dArray9 = this.pt[2];
            Intrinsics.checkNotNull((Object)dArray9);
            double d13 = dArray9[i];
            double[] dArray10 = this.pt[0];
            Intrinsics.checkNotNull((Object)dArray10);
            double d14 = 0.5 * (d12 + (d13 - dArray10[i]) * t);
            double[] dArray11 = this.pt[1];
            Intrinsics.checkNotNull((Object)dArray11);
            p[i] = d14 + dArray11[i];
            ++i;
        }
    }

    @Override
    public int getSampleLimit() {
        return 1;
    }

    public CatmullRomSpline(@Nullable ControlPath cp, @Nullable GroupIterator gi) {
        super(cp, gi);
    }
}

