/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom.curve;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.geom.curve.BinaryCurveApproximationAlgorithm;
import org.kamaeleo.geom.curve.ControlPath;
import org.kamaeleo.geom.curve.GroupIterator;
import org.kamaeleo.geom.curve.MultiPath;
import org.kamaeleo.geom.curve.ParametricCurve;
import org.kamaeleo.geom.curve.Point;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/kamaeleo/geom/curve/CubicBSpline;", "Lorg/kamaeleo/geom/curve/ParametricCurve;", "cp", "Lorg/kamaeleo/geom/curve/ControlPath;", "gi", "Lorg/kamaeleo/geom/curve/GroupIterator;", "(Lorg/kamaeleo/geom/curve/ControlPath;Lorg/kamaeleo/geom/curve/GroupIterator;)V", "interpolateEndpoints", "", "getInterpolateEndpoints", "()Z", "setInterpolateEndpoints", "(Z)V", "sampleLimit", "", "getSampleLimit", "()I", "appendTo", "", "mp", "Lorg/kamaeleo/geom/curve/MultiPath;", "eval", "p", "", "Companion", "kamaeleo"})
public final class CubicBSpline
extends ParametricCurve {
    private boolean interpolateEndpoints;
    private static final int FIRST_SECTION = 0;
    private static final int SECOND_SECTION = 1;
    private static final int MIDDLE_SECTION = 2;
    private static final int SECOND_LAST_SECTION = 3;
    private static final int LAST_SECTION = 4;
    private static final double[][] pt;
    private static final double[] b;
    private static int currentSection;
    @NotNull
    public static final Companion Companion;

    public final boolean getInterpolateEndpoints() {
        return this.interpolateEndpoints;
    }

    public final void setInterpolateEndpoints(boolean bl) {
        this.interpolateEndpoints = bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void appendTo(@NotNull MultiPath mp) {
        Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
        GroupIterator groupIterator = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator);
        ControlPath controlPath = this.getCp();
        Intrinsics.checkNotNull((Object)controlPath);
        if (!groupIterator.isInRange(0, controlPath.numPoints())) {
            return;
        }
        GroupIterator groupIterator2 = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator2);
        int n = groupIterator2.getGroupSize();
        if (n < 4) {
            return;
        }
        if (this.interpolateEndpoints) {
            if (n < 7) {
                return;
            }
            currentSection = 0;
        } else {
            currentSection = 2;
        }
        GroupIterator groupIterator3 = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator3);
        groupIterator3.set(0, 0);
        int n2 = 0;
        int n3 = 3;
        while (n2 <= n3) {
            void i;
            ControlPath controlPath2 = this.getCp();
            Intrinsics.checkNotNull((Object)controlPath2);
            GroupIterator groupIterator4 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator4);
            Point point = controlPath2.getPoint(groupIterator4.next());
            Intrinsics.checkNotNull((Object)point);
            CubicBSpline.pt[i] = point.getLocation();
            ++i;
        }
        double[] d = new double[mp.getDimension() + 1];
        this.eval(d);
        if (this.getConnect()) {
            mp.lineTo(d);
        } else {
            mp.moveTo(d);
        }
        GroupIterator groupIterator5 = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator5);
        groupIterator5.set(0, 0);
        int j = 0;
        while (true) {
            GroupIterator groupIterator6 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator6);
            int index_i = groupIterator6.index_i();
            GroupIterator groupIterator7 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator7);
            int count_j = groupIterator7.count_j();
            int n4 = 0;
            int n5 = 3;
            while (n4 <= n5) {
                void i;
                GroupIterator groupIterator8 = this.getGi();
                Intrinsics.checkNotNull((Object)groupIterator8);
                if (!groupIterator8.hasNext()) {
                    return;
                }
                ControlPath controlPath3 = this.getCp();
                Intrinsics.checkNotNull((Object)controlPath3);
                GroupIterator groupIterator9 = this.getGi();
                Intrinsics.checkNotNull((Object)groupIterator9);
                Point point = controlPath3.getPoint(groupIterator9.next());
                Intrinsics.checkNotNull((Object)point);
                CubicBSpline.pt[i] = point.getLocation();
                ++i;
            }
            GroupIterator groupIterator10 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator10);
            groupIterator10.set(index_i, count_j);
            GroupIterator groupIterator11 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator11);
            groupIterator11.next();
            BinaryCurveApproximationAlgorithm.INSTANCE.genPts(this, 0.0, 1.0, mp);
            if (!this.interpolateEndpoints) continue;
            if (currentSection != 2) {
                n4 = currentSection;
                currentSection = n4 + 1;
            }
            if (currentSection == 2 && j == n - 6) {
                n4 = currentSection;
                currentSection = n4 + 1;
            }
            ++j;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void eval(@NotNull double[] p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        double t = p[p.length - 1];
        if (currentSection == 3 || currentSection == 4) {
            t = 1.0 - t;
        }
        double t2 = t * t;
        double t3 = t2 * t;
        double u = 1.0 - t;
        double u3 = u * u * u;
        if (currentSection == 0) {
            CubicBSpline.b[0] = u3;
            CubicBSpline.b[1] = (double)21 * t3 / (double)12 - (double)9 * t2 / (double)2 + (double)3 * t;
            CubicBSpline.b[2] = (double)-11 * t3 / (double)12 + (double)3 * t2 / (double)2;
            CubicBSpline.b[3] = t3 / (double)6;
        } else if (currentSection == 1) {
            CubicBSpline.b[0] = u3 / (double)4;
            CubicBSpline.b[1] = (double)7 * t3 / (double)12 - (double)5 * t2 / (double)4 + t / (double)4 + 0.5833333333333334;
            CubicBSpline.b[2] = -t3 / (double)2 + t2 / (double)2 + t / (double)2 + 0.16666666666666666;
            CubicBSpline.b[3] = t3 / (double)6;
        } else if (currentSection == 2) {
            CubicBSpline.b[0] = u3 / (double)6;
            CubicBSpline.b[1] = t3 / (double)2 - t2 + 0.6666666666666666;
            CubicBSpline.b[2] = (-t3 + t2 + t) / (double)2 + 0.16666666666666666;
            CubicBSpline.b[3] = t3 / (double)6;
        } else if (currentSection == 3) {
            CubicBSpline.b[0] = t3 / (double)6;
            CubicBSpline.b[1] = -t3 / (double)2 + t2 / (double)2 + t / (double)2 + 0.16666666666666666;
            CubicBSpline.b[2] = (double)7 * t3 / (double)12 - (double)5 * t2 / (double)4 + t / (double)4 + 0.5833333333333334;
            CubicBSpline.b[3] = u3 / (double)4;
        } else if (currentSection == 4) {
            CubicBSpline.b[0] = t3 / (double)6;
            CubicBSpline.b[1] = (double)-11 * t3 / (double)12 + (double)3 * t2 / (double)2;
            CubicBSpline.b[2] = (double)21 * t3 / (double)12 - (double)9 * t2 / (double)2 + (double)3 * t;
            CubicBSpline.b[3] = u3;
        }
        int n = 0;
        int n2 = 3;
        while (n <= n2) {
            void i;
            int n3 = 0;
            int n4 = p.length - 1;
            while (n3 < n4) {
                void j;
                void v0 = j;
                double d = p[v0];
                double[] dArray = pt[i];
                Intrinsics.checkNotNull((Object)dArray);
                p[v0] = d + dArray[j] * b[i];
                ++j;
            }
            ++i;
        }
    }

    @Override
    public int getSampleLimit() {
        return 1;
    }

    public CubicBSpline(@Nullable ControlPath cp, @Nullable GroupIterator gi) {
        super(cp, gi);
    }

    static {
        Companion = new Companion(null);
        pt = new double[4][];
        b = new double[4];
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/kamaeleo/geom/curve/CubicBSpline$Companion;", "", "()V", "FIRST_SECTION", "", "LAST_SECTION", "MIDDLE_SECTION", "SECOND_LAST_SECTION", "SECOND_SECTION", "b", "", "currentSection", "pt", "", "[[D", "kamaeleo"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

