/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom.curve;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.geom.curve.BSpline;
import org.kamaeleo.geom.curve.ControlPath;
import org.kamaeleo.geom.curve.GroupIterator;
import org.kamaeleo.geom.curve.MultiPath;
import org.kamaeleo.geom.curve.Point;
import org.kamaeleo.geom.curve.ValueVector;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0006\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u0004\u0018\u00010\u000eJ\b\u0010\u0017\u001a\u00020\u0010H\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\u000eR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/kamaeleo/geom/curve/NURBSpline;", "Lorg/kamaeleo/geom/curve/BSpline;", "cp", "Lorg/kamaeleo/geom/curve/ControlPath;", "gi", "Lorg/kamaeleo/geom/curve/GroupIterator;", "(Lorg/kamaeleo/geom/curve/ControlPath;Lorg/kamaeleo/geom/curve/GroupIterator;)V", "useWeightVector", "", "getUseWeightVector", "()Z", "setUseWeightVector", "(Z)V", "weightVector", "Lorg/kamaeleo/geom/curve/ValueVector;", "appendTo", "", "mp", "Lorg/kamaeleo/geom/curve/MultiPath;", "eval", "p", "", "getWeightVector", "resetMemory", "setWeightVector", "v", "Companion", "kamaeleo"})
public final class NURBSpline
extends BSpline {
    private ValueVector weightVector = new ValueVector(new double[]{1.0, 1.0, 1.0, 1.0}, 4);
    private boolean useWeightVector = true;
    private static double[] nw;
    private static double[] weight;
    @NotNull
    public static final Companion Companion;

    public final boolean getUseWeightVector() {
        return this.useWeightVector;
    }

    public final void setUseWeightVector(boolean bl) {
        this.useWeightVector = bl;
    }

    @Nullable
    public final ValueVector getWeightVector() {
        return this.weightVector;
    }

    public final void setWeightVector(@Nullable ValueVector v) {
        this.weightVector = v;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void appendTo(@NotNull MultiPath mp) {
        Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
        GroupIterator groupIterator = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator);
        ControlPath controlPath = this.getCp();
        Intrinsics.checkNotNull((Object)controlPath);
        if (!groupIterator.isInRange(0, controlPath.numPoints())) {
            return;
        }
        GroupIterator groupIterator2 = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator2);
        int numPts = groupIterator2.getGroupSize();
        if (nw.length < numPts) {
            nw = new double[2 * numPts];
            weight = new double[2 * numPts];
        }
        if (this.useWeightVector) {
            ValueVector valueVector = this.weightVector;
            Intrinsics.checkNotNull((Object)valueVector);
            if (valueVector.size() != numPts) {
                return;
            }
            int n = 0;
            int n2 = numPts;
            while (n < n2) {
                void i;
                ValueVector valueVector2 = this.weightVector;
                Intrinsics.checkNotNull((Object)valueVector2);
                NURBSpline.weight[i] = valueVector2.get((int)i);
                if (weight[i] < 0.0) {
                    return;
                }
                ++i;
            }
        } else {
            int n = numPts;
            for (int i = 0; i < n; ++i) {
                NURBSpline.weight[i] = 1.0;
            }
        }
        super.appendTo(mp);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void eval(@NotNull double[] p) {
        int i;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        int dim = p.length - 1;
        double t = p[dim];
        double sum2 = 0.0;
        GroupIterator groupIterator = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator);
        int numPts = groupIterator.getGroupSize();
        int n = 0;
        int n2 = numPts;
        while (n < n2) {
            NURBSpline.nw[i] = this.N(t, i) * weight[i];
            sum2 += nw[i];
            ++i;
        }
        if (sum2 == 0.0) {
            sum2 = 1.0;
        }
        n2 = dim;
        for (i = 0; i < n2; ++i) {
            GroupIterator groupIterator2 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator2);
            groupIterator2.set(0, 0);
            double sum1 = 0.0;
            int n3 = 0;
            int n4 = numPts;
            while (n3 < n4) {
                void j;
                double d = nw[j];
                ControlPath controlPath = this.getCp();
                Intrinsics.checkNotNull((Object)controlPath);
                GroupIterator groupIterator3 = this.getGi();
                Intrinsics.checkNotNull((Object)groupIterator3);
                Point point = controlPath.getPoint(groupIterator3.next());
                Intrinsics.checkNotNull((Object)point);
                sum1 += d * point.getLocation()[i];
                ++j;
            }
            p[i] = sum1 / sum2;
        }
    }

    @Override
    public void resetMemory() {
        super.resetMemory();
        if (nw.length > 0) {
            nw = new double[0];
            weight = new double[0];
        }
    }

    public NURBSpline(@Nullable ControlPath cp, @Nullable GroupIterator gi) {
        super(cp, gi);
    }

    static {
        Companion = new Companion(null);
        nw = new double[0];
        weight = new double[0];
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/kamaeleo/geom/curve/NURBSpline$Companion;", "", "()V", "nw", "", "weight", "kamaeleo"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

