/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.graphics;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.geom.Point2D;
import org.kamaeleo.geom.Rectangle2D;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0096\u0002J\u0011\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0096\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0016J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/kamaeleo/graphics/GeometryShape;", "Ljava/awt/Shape;", "geometry", "Lorg/kamaeleo/geom/Shape;", "(Lorg/kamaeleo/geom/Shape;)V", "contains", "", "p", "Ljava/awt/geom/Point2D;", "r", "Ljava/awt/geom/Rectangle2D;", "x", "", "y", "w", "h", "getBounds", "Ljava/awt/Rectangle;", "getBounds2D", "getPathIterator", "Ljava/awt/geom/PathIterator;", "at", "Ljava/awt/geom/AffineTransform;", "flatness", "intersects", "GeometryPathIterator", "kamaeleo"})
public final class GeometryShape
implements Shape {
    private final org.kamaeleo.geom.Shape geometry;

    @Override
    @NotNull
    public Rectangle getBounds() {
        org.kamaeleo.geom.Shape shape = this.geometry;
        Intrinsics.checkNotNull((Object)shape);
        org.kamaeleo.geom.Rectangle2D rectangle2D = shape.getBounds2D();
        Intrinsics.checkNotNull((Object)rectangle2D);
        org.kamaeleo.geom.Rectangle2D b = rectangle2D;
        double width = b.getWidth();
        double height = b.getHeight();
        if (width < 0.0 || height < 0.0) {
            return new Rectangle();
        }
        double x = b.getX();
        double y = b.getY();
        double x1 = Math.floor(x);
        double y1 = Math.floor(y);
        double x2 = Math.ceil(x + width);
        double y2 = Math.ceil(y + height);
        return new Rectangle((int)x1, (int)y1, (Integer)(x2 - x1), (Integer)(y2 - y1));
    }

    @Override
    @NotNull
    public Rectangle2D getBounds2D() {
        org.kamaeleo.geom.Rectangle2D b = this.geometry.getBounds2D();
        return new Rectangle2D.Double(b.getX(), b.getY(), b.getWidth(), b.getHeight());
    }

    @Override
    public boolean contains(double x, double y) {
        return this.geometry.contains(new Point2D.Double(x, y));
    }

    @Override
    public boolean contains(@NotNull Point2D p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this.geometry.contains(new Point2D.Double(p.getX(), p.getY()));
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.geometry.intersects(new Rectangle2D.Double(x, y, w, h));
    }

    @Override
    public boolean intersects(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.geometry.intersects(new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight()));
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return false;
    }

    @Override
    public boolean contains(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return false;
    }

    @Override
    @NotNull
    public PathIterator getPathIterator(@NotNull AffineTransform at) {
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return new GeometryPathIterator(this.geometry.getPathIterator(null), at);
    }

    @Override
    @NotNull
    public PathIterator getPathIterator(@NotNull AffineTransform at, double flatness) {
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return new GeometryPathIterator(this.geometry.getFlattenPathIterator(flatness), at);
    }

    public GeometryShape(@NotNull org.kamaeleo.geom.Shape geometry) {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        this.geometry = geometry;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0013\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\t\u0010\u000f\u001a\u00020\u0010H\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/kamaeleo/graphics/GeometryShape$GeometryPathIterator;", "Ljava/awt/geom/PathIterator;", "pi", "Lorg/kamaeleo/geom/PathIterator;", "transform", "Ljava/awt/geom/AffineTransform;", "(Lorg/kamaeleo/geom/PathIterator;Ljava/awt/geom/AffineTransform;)V", "currentSegment", "", "coords", "", "", "getWindingRule", "isDone", "", "next", "", "kamaeleo"})
    private static final class GeometryPathIterator
    implements PathIterator {
        private final org.kamaeleo.geom.PathIterator pi;
        private final AffineTransform transform;

        @Override
        public int getWindingRule() {
            return this.pi.getWindingRule();
        }

        @Override
        public boolean isDone() {
            return this.pi.isDone();
        }

        @Override
        public void next() {
            this.pi.next();
        }

        @Override
        public int currentSegment(@NotNull float[] coords) {
            int type;
            block0: {
                Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
                type = this.pi.currentSegment(coords);
                AffineTransform affineTransform = this.transform;
                if (affineTransform == null) break block0;
                affineTransform.transform(coords, 0, coords, 0, coords.length / 2);
            }
            return type;
        }

        @Override
        public int currentSegment(@NotNull double[] coords) {
            int type;
            block0: {
                Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
                type = this.pi.currentSegment(coords);
                AffineTransform affineTransform = this.transform;
                if (affineTransform == null) break block0;
                affineTransform.transform(coords, 0, coords, 0, coords.length / 2);
            }
            return type;
        }

        public GeometryPathIterator(@NotNull org.kamaeleo.geom.PathIterator pi, @Nullable AffineTransform transform) {
            Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
            this.pi = pi;
            this.transform = transform;
        }
    }
}

