/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.graphics;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.color.CPColor;
import org.kamaeleo.font.CPFont;
import org.kamaeleo.font.CPFontMetrics;
import org.kamaeleo.geom.Arc2D;
import org.kamaeleo.geom.Ellipse2D;
import org.kamaeleo.geom.Point2D;
import org.kamaeleo.geom.Rectangle2D;
import org.kamaeleo.geom.Shape;
import org.kamaeleo.graphics.AbstractIGraphics;
import org.kamaeleo.graphics.GeometryShape;
import org.kamaeleo.graphics.HeadlessGraphics2D;
import org.kamaeleo.graphics.IGraphics;
import org.kamaeleo.graphics.SwingFontMetrics;
import org.kamaeleo.graphics.SwingIGraphics$WhenMappings;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u0012\u0010\u000e\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J(\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J(\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u00020\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J(\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0017H\u0016J\"\u0010 \u001a\u00020\f2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001c\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\fH\u0016J\u0012\u0010$\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J(\u0010%\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0017H\u0016J\b\u0010&\u001a\u00020\u0013H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u0013H\u0016J\n\u0010*\u001a\u0004\u0018\u00010+H\u0016J\b\u0010,\u001a\u00020\u0013H\u0016J\u0012\u0010-\u001a\u00020.2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0012\u0010/\u001a\u00020#2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0012\u00100\u001a\u00020#2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0018\u00101\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0013H\u0016J\u0018\u00102\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0013H\u0016J\u0010\u00103\u001a\u00020\f2\u0006\u00104\u001a\u00020\u0013H\u0016J\u0010\u00105\u001a\u00020\f2\u0006\u00106\u001a\u00020(H\u0016J\u0012\u00107\u001a\u00020\f2\b\u00108\u001a\u0004\u0018\u000109H\u0016J\u0010\u0010:\u001a\u00020\f2\u0006\u0010;\u001a\u00020\u0013H\u0016J\u0012\u0010<\u001a\u00020\f2\b\u0010=\u001a\u0004\u0018\u00010>H\u0016J\u0010\u0010?\u001a\u00020\f2\u0006\u0010@\u001a\u00020\u0013H\u0016J\u0012\u0010A\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010B\u001a\u00020\fH\u0016J\u0018\u0010C\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0017H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lorg/kamaeleo/graphics/SwingIGraphics;", "Lorg/kamaeleo/graphics/AbstractIGraphics;", "context", "Ljava/awt/Graphics2D;", "(Ljava/awt/Graphics2D;)V", "baseline", "Lorg/kamaeleo/graphics/IGraphics$TextBaseline;", "getContext", "()Ljava/awt/Graphics2D;", "path", "Ljava/awt/geom/GeneralPath;", "beginPath", "", "closePath", "draw", "geometry", "Lorg/kamaeleo/geom/Shape;", "drawLine", "x1", "", "y1", "x2", "y2", "", "drawPoint", "point", "Lorg/kamaeleo/geom/Point2D;", "drawRectange", "x", "y", "width", "height", "drawString", "text", "", "", "fill", "fillRectangle", "getAscent", "getColor", "Lorg/kamaeleo/color/CPColor;", "getDescent", "getFontMetrics", "Lorg/kamaeleo/font/CPFontMetrics;", "getLineWidth", "getStringBounds", "Lorg/kamaeleo/geom/Rectangle2D;", "getStringHeight", "getStringWidth", "lineTo", "moveTo", "rotate", "theta", "setColor", "color", "setFont", "font", "Lorg/kamaeleo/font/CPFont;", "setGlobalAlpha", "alpha", "setLineDash", "dashPattern", "", "setLineWidth", "lineWidth", "setTextBaseline", "stroke", "translate", "kamaeleo"})
public final class SwingIGraphics
extends AbstractIGraphics {
    @NotNull
    private final Graphics2D context;
    private IGraphics.TextBaseline baseline = IGraphics.TextBaseline.Alphabetic;
    private GeneralPath path;

    @NotNull
    public final Graphics2D getContext() {
        return this.context;
    }

    @Override
    public double getLineWidth() {
        Stroke stroke = this.context.getStroke();
        if (stroke == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.BasicStroke");
        }
        return ((BasicStroke)stroke).getLineWidth();
    }

    @Override
    public void setLineWidth(double lineWidth) {
        this.context.setStroke(new BasicStroke((float)lineWidth, 0, 0));
    }

    @Override
    public void setLineDash(@Nullable float[] dashPattern) {
        Stroke stroke = new BasicStroke(1.0f, 0, 0, 10.0f, dashPattern, 0.0f);
        this.context.setStroke(stroke);
    }

    @Override
    public void setGlobalAlpha(double alpha) {
        this.context.setComposite(AlphaComposite.getInstance(3, (float)alpha));
    }

    @Override
    @NotNull
    public CPColor getColor() {
        Color color = this.context.getColor();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"context.color");
        return new CPColor(color);
    }

    @Override
    public void setColor(@NotNull CPColor color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.context.setColor(color.getNativeColor());
    }

    @Override
    protected void draw(@Nullable Shape geometry) {
        if (geometry instanceof org.kamaeleo.geom.Rectangle2D) {
            org.kamaeleo.geom.Rectangle2D r = (org.kamaeleo.geom.Rectangle2D)geometry;
            this.context.draw(new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight()));
        } else if (geometry instanceof Arc2D) {
            Arc2D arc = (Arc2D)geometry;
            this.context.draw(new Arc2D.Double(arc.getX(), arc.getY(), arc.getWidth(), arc.getHeight(), arc.getAngleStart(), arc.getAngleExtent(), arc.getArcType()));
        } else if (geometry != null) {
            GeometryShape shape = new GeometryShape(geometry);
            this.context.draw(shape);
        }
    }

    @Override
    protected void fill(@Nullable Shape geometry) {
        if (geometry instanceof org.kamaeleo.geom.Rectangle2D) {
            org.kamaeleo.geom.Rectangle2D r = (org.kamaeleo.geom.Rectangle2D)geometry;
            this.context.fill(new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight()));
        } else if (geometry instanceof Ellipse2D) {
            Ellipse2D r = (Ellipse2D)geometry;
            this.context.fill(new Ellipse2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight()));
        } else {
            Shape shape = geometry;
            Intrinsics.checkNotNull((Object)shape);
            GeometryShape shape2 = new GeometryShape(shape);
            this.context.fill(shape2);
        }
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.context.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawLine(double x1, double y1, double x2, double y2) {
        this.context.draw(new Line2D.Double(x1, y1, x2, y2));
    }

    @Override
    public void fillRectangle(int x, int y, int width, int height) {
        this.context.fillRect(x, y, width, height);
    }

    @Override
    public void drawRectange(int x, int y, int width, int height) {
        this.context.drawRect(x, y, width, height);
    }

    @Override
    public void drawPoint(@Nullable Point2D point) {
        Point2D point2D = point;
        Intrinsics.checkNotNull((Object)point2D);
        this.context.fill(new Rectangle2D.Double(point2D.getX(), point.getY(), 1.0, 1.0));
    }

    @Override
    public void setTextBaseline(@Nullable IGraphics.TextBaseline baseline) {
        IGraphics.TextBaseline textBaseline = baseline;
        Intrinsics.checkNotNull((Object)((Object)textBaseline));
        this.baseline = textBaseline;
    }

    @Override
    public void setFont(@Nullable CPFont font) {
        CPFont cPFont = font;
        Intrinsics.checkNotNull((Object)cPFont);
        this.context.setFont(cPFont.getNativeFont());
    }

    @Override
    @NotNull
    public org.kamaeleo.geom.Rectangle2D getStringBounds(@Nullable String text) {
        Rectangle2D stringBounds;
        Rectangle2D rectangle2D = stringBounds = this.context.getFontMetrics().getStringBounds(text, this.context);
        Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"stringBounds");
        return new Rectangle2D.Double(rectangle2D.getX(), stringBounds.getY(), stringBounds.getWidth(), stringBounds.getHeight());
    }

    @Override
    public float getStringWidth(@Nullable String text) {
        return text != null ? (float)this.context.getFontMetrics().stringWidth(text) : 0.0f;
    }

    @Override
    public float getStringHeight(@Nullable String text) {
        float f;
        if (text != null) {
            LineMetrics metrics;
            LineMetrics lineMetrics = metrics = this.context.getFont().getLineMetrics(text, this.context.getFontRenderContext());
            Intrinsics.checkNotNullExpressionValue((Object)lineMetrics, (String)"metrics");
            f = lineMetrics.getHeight();
        } else {
            f = 0.0f;
        }
        return f;
    }

    @Override
    public double getAscent() {
        FontMetrics fontMetrics = this.context.getFontMetrics();
        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"context.fontMetrics");
        return fontMetrics.getAscent();
    }

    @Override
    public double getDescent() {
        FontMetrics fontMetrics = this.context.getFontMetrics();
        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"context.fontMetrics");
        return fontMetrics.getDescent();
    }

    @Override
    @Nullable
    public CPFontMetrics getFontMetrics() {
        return new SwingFontMetrics(this.context);
    }

    @Override
    public void drawString(@Nullable String text, float x, float y) {
        float y2 = y;
        switch (SwingIGraphics$WhenMappings.$EnumSwitchMapping$0[this.baseline.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                FontMetrics fontMetrics = this.context.getFontMetrics();
                Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"context.fontMetrics");
                y2 -= (float)fontMetrics.getAscent();
                break;
            }
            case 3: {
                FontMetrics fontMetrics = this.context.getFontMetrics();
                Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"context.fontMetrics");
                y2 += (float)fontMetrics.getDescent();
                break;
            }
            case 4: {
                LineMetrics lm;
                FontMetrics fm = this.context.getFontMetrics();
                LineMetrics lineMetrics = lm = fm.getLineMetrics(text, this.context);
                Intrinsics.checkNotNullExpressionValue((Object)lineMetrics, (String)"lm");
                y2 = y2 - (lineMetrics.getAscent() + lm.getDescent()) / (float)2 + lm.getAscent();
                break;
            }
            case 5: {
                throw (Throwable)new UnsupportedOperationException();
            }
            case 6: {
                throw (Throwable)new UnsupportedOperationException();
            }
            default: {
                throw (Throwable)new IllegalArgumentException();
            }
        }
        this.context.drawString(text, x, y2);
    }

    @Override
    public void translate(int x, int y) {
        this.context.translate(x, y);
    }

    @Override
    public void rotate(double theta) {
        this.context.rotate(theta);
    }

    @Override
    public void beginPath() {
        this.path = new GeneralPath();
    }

    @Override
    public void moveTo(double x, double y) {
        GeneralPath generalPath = this.path;
        Intrinsics.checkNotNull((Object)generalPath);
        generalPath.moveTo(x, y);
    }

    @Override
    public void lineTo(double x, double y) {
        GeneralPath generalPath = this.path;
        Intrinsics.checkNotNull((Object)generalPath);
        generalPath.lineTo(x, y);
    }

    @Override
    public void closePath() {
        GeneralPath generalPath = this.path;
        Intrinsics.checkNotNull((Object)generalPath);
        generalPath.closePath();
    }

    @Override
    public void stroke() {
        this.context.draw(this.path);
    }

    @Override
    public void fill() {
        this.context.fill(this.path);
    }

    public SwingIGraphics(@Nullable Graphics2D context) {
        Graphics2D graphics2D = context;
        if (graphics2D == null) {
            graphics2D = new HeadlessGraphics2D();
        }
        this.context = graphics2D;
        this.context.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.context.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }
}

