/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.labeling;

import com.macrofocus.common.properties.Properties;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.color.CPColor;
import org.kamaeleo.font.CPFont;
import org.kamaeleo.labeling.EnhancedJLabel$EnhancedLabelUI$WhenMappings;
import org.kamaeleo.labeling.EnhancedLabel;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 A2\u00020\u0001:\u0002ABB\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010/\u001a\u0004\u0018\u00010\u00032\b\u00100\u001a\u0004\u0018\u00010\u0003J\n\u00101\u001a\u0004\u0018\u000102H\u0016J\b\u00103\u001a\u00020\u0010H\u0016J\b\u00104\u001a\u00020\u0010H\u0016J\u000e\u00104\u001a\u00020\u00102\u0006\u00105\u001a\u000206J\b\u00107\u001a\u00020\u0010H\u0016J\u000e\u00107\u001a\u00020\u00102\u0006\u00105\u001a\u000206J\u0010\u00108\u001a\u0002092\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u000e\u0010:\u001a\u0002092\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010;\u001a\u0002092\b\u0010<\u001a\u0004\u0018\u00010=J\u0012\u0010>\u001a\u0002092\b\u0010?\u001a\u0004\u0018\u000102H\u0016J\u0012\u0010@\u001a\u0002092\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0014R$\u0010\t\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00108F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00168F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR$\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R(\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010!\u001a\u0004\u0018\u00010\"8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0018\u0010'\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010)\u001a\u0004\u0018\u00010*2\b\u0010)\u001a\u0004\u0018\u00010*8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u0006C"}, d2={"Lorg/kamaeleo/labeling/EnhancedJLabel;", "Ljavax/swing/JLabel;", "text", "", "(Ljava/lang/String;)V", "()V", "data", "Lorg/kamaeleo/labeling/EnhancedLabel;", "(Lorg/kamaeleo/labeling/EnhancedLabel;)V", "angle", "", "getAngle", "()D", "setAngle", "(D)V", "desiredSize", "Ljava/awt/Dimension;", "getDesiredSize", "()Ljava/awt/Dimension;", "setDesiredSize", "(Ljava/awt/Dimension;)V", "effectOpacity", "", "getEffectOpacity", "()F", "setEffectOpacity", "(F)V", "justified", "", "isJustified", "()Z", "setJustified", "(Z)V", "minimumCharactersToDisplay", "", "getMinimumCharactersToDisplay", "()Ljava/lang/Integer;", "setMinimumCharactersToDisplay", "(Ljava/lang/Integer;)V", "propertiesListener", "Lcom/macrofocus/common/properties/PropertiesListener;", "rendering", "Lorg/kamaeleo/labeling/EnhancedLabel$Rendering;", "getRendering", "()Lorg/kamaeleo/labeling/EnhancedLabel$Rendering;", "setRendering", "(Lorg/kamaeleo/labeling/EnhancedLabel$Rendering;)V", "addTag", "value", "getFont", "Ljava/awt/Font;", "getMaximumSize", "getMinimumSize", "g2", "Ljava/awt/Graphics2D;", "getPreferredSize", "registerListener", "", "setData", "setEffect", "effect", "Lorg/kamaeleo/labeling/EnhancedLabel$Effect;", "setFont", "font", "unregisterListener", "Companion", "EnhancedLabelUI", "kamaeleo"})
public class EnhancedJLabel
extends JLabel {
    private EnhancedLabel data;
    private PropertiesListener<String> propertiesListener;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Dimension getMinimumSize(@NotNull Graphics2D g2) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        ComponentUI componentUI = this.ui;
        if (componentUI == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.kamaeleo.labeling.EnhancedJLabel.EnhancedLabelUI");
        }
        return ((EnhancedLabelUI)componentUI).getMinimumSize(g2, this);
    }

    @NotNull
    public final Dimension getPreferredSize(@NotNull Graphics2D g2) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        ComponentUI componentUI = this.ui;
        if (componentUI == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.kamaeleo.labeling.EnhancedJLabel.EnhancedLabelUI");
        }
        return ((EnhancedLabelUI)componentUI).getPreferredSize(g2, this);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"super.getPreferredSize()");
        return dimension;
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"super.getMinimumSize()");
        return dimension;
    }

    public final void setData(@NotNull EnhancedLabel data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.unregisterListener(this.data);
        this.data = data;
        if (data.isHTML()) {
            super.setText(this.addTag(data.getText()));
        } else {
            super.setText(data.getText());
        }
        super.setVerticalAlignment(data.getVerticalAlignment());
        super.setHorizontalAlignment(data.getHorizontalAlignment());
        if (data.getFont() != null) {
            CPFont cPFont = data.getFont();
            Intrinsics.checkNotNull((Object)cPFont);
            super.setFont(cPFont.getNativeFont());
        }
        if (data.getForeground() != null) {
            CPColor cPColor = data.getForeground();
            Intrinsics.checkNotNull((Object)cPColor);
            super.setForeground(cPColor.getNativeColor());
        }
        if (data.getBackground() != null) {
            CPColor cPColor = data.getBackground();
            Intrinsics.checkNotNull((Object)cPColor);
            super.setBackground(cPColor.getNativeColor());
        }
        super.setBorder(BorderFactory.createEmptyBorder(data.getInsetTop(), data.getInsetLeft(), data.getInsetBottom(), data.getInsetRight()));
        this.registerListener(data);
    }

    @Nullable
    public final String addTag(@Nullable String value) {
        return value != null ? (!StringsKt.startsWith$default((String)value, (String)"<html>", (boolean)false, (int)2, null) ? "<html>" + value + "</html>" : value) : null;
    }

    protected void unregisterListener(@Nullable EnhancedLabel data) {
        if (data != null) {
            Properties<String> properties = data.getProperties();
            Intrinsics.checkNotNull(properties);
            PropertiesListener<String> propertiesListener = this.propertiesListener;
            Intrinsics.checkNotNull(propertiesListener);
            properties.removePropertiesListener(propertiesListener);
        }
    }

    protected void registerListener(@NotNull EnhancedLabel data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (this.propertiesListener == null) {
            this.propertiesListener = (PropertiesListener)new PropertiesListener<String>(this){
                final /* synthetic */ EnhancedJLabel this$0;

                public void propertyChanged(@Nullable String name, @NotNull PropertyEvent<Object> event2) {
                    Intrinsics.checkNotNullParameter(event2, (String)"event");
                    this.this$0.repaint();
                }
                {
                    this.this$0 = this$0;
                }
            };
        }
        Properties<String> properties = data.getProperties();
        Intrinsics.checkNotNull(properties);
        PropertiesListener<String> propertiesListener = this.propertiesListener;
        Intrinsics.checkNotNull(propertiesListener);
        properties.addWeakPropertiesListener(propertiesListener);
    }

    public final void setEffect(@Nullable EnhancedLabel.Effect effect) {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        EnhancedLabel.Effect effect2 = effect;
        Intrinsics.checkNotNull((Object)((Object)effect2));
        enhancedLabel.setEffect(effect2);
    }

    public final float getEffectOpacity() {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        return enhancedLabel.getEffectOpacity();
    }

    public final void setEffectOpacity(float effectOpacity) {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        enhancedLabel.getEffectOpacity();
    }

    @Nullable
    public final EnhancedLabel.Rendering getRendering() {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        return enhancedLabel.getRendering();
    }

    public final void setRendering(@Nullable EnhancedLabel.Rendering rendering) {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        EnhancedLabel.Rendering rendering2 = rendering;
        Intrinsics.checkNotNull((Object)((Object)rendering2));
        enhancedLabel.setRendering(rendering2);
    }

    @Nullable
    public final Integer getMinimumCharactersToDisplay() {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        return enhancedLabel.getMinimumCharactersToDisplay();
    }

    public final void setMinimumCharactersToDisplay(@Nullable Integer minimumCharactersToDisplay) {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        enhancedLabel.getMinimumCharactersToDisplay();
    }

    public final boolean isJustified() {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        return enhancedLabel.isJustified();
    }

    public final void setJustified(boolean justified) {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        enhancedLabel.setJustified(justified);
    }

    public final double getAngle() {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        return enhancedLabel.getAngle();
    }

    public final void setAngle(double angle) {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        enhancedLabel.setAngle(angle);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public Font getFont() {
        Font font;
        if (this.data != null) {
            EnhancedLabel enhancedLabel = this.data;
            Intrinsics.checkNotNull((Object)enhancedLabel);
            if (enhancedLabel.getFont() != null) {
                EnhancedLabel enhancedLabel2 = this.data;
                Intrinsics.checkNotNull((Object)enhancedLabel2);
                CPFont cPFont = enhancedLabel2.getFont();
                Intrinsics.checkNotNull((Object)cPFont);
                font = cPFont.getNativeFont();
                return font;
            }
        }
        font = super.getFont();
        return font;
    }

    @Override
    public void setFont(@Nullable Font font) {
        Font oldFont = this.getFont();
        if (this.data != null) {
            EnhancedLabel enhancedLabel = this.data;
            Intrinsics.checkNotNull((Object)enhancedLabel);
            Font font2 = font;
            Intrinsics.checkNotNull((Object)font2);
            enhancedLabel.setFont(new CPFont(font2));
        } else {
            super.setFont(font);
        }
        this.firePropertyChange("font", oldFont, font);
    }

    @Override
    @NotNull
    public Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"super.getMaximumSize()");
        return dimension;
    }

    @NotNull
    public final Dimension getDesiredSize() {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        int n = enhancedLabel.getDesiredWidth();
        EnhancedLabel enhancedLabel2 = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel2);
        return new Dimension(n, enhancedLabel2.getDesiredWidth());
    }

    public final void setDesiredSize(@NotNull Dimension desiredSize) {
        Intrinsics.checkNotNullParameter((Object)desiredSize, (String)"desiredSize");
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        enhancedLabel.setDesiredWidth(desiredSize.width);
        EnhancedLabel enhancedLabel2 = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel2);
        enhancedLabel2.setDesiredHeight(desiredSize.height);
    }

    public EnhancedJLabel(@NotNull EnhancedLabel data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.setUI(new EnhancedLabelUI());
        this.setData(data);
    }

    public EnhancedJLabel(@Nullable String text) {
        this();
        this.setText(text);
    }

    public EnhancedJLabel() {
        this(new EnhancedLabel());
        this.setUI(new EnhancedLabelUI());
    }

    public static final /* synthetic */ void access$setData$p(EnhancedJLabel $this, EnhancedLabel enhancedLabel) {
        $this.data = enhancedLabel;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u000e\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0013\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J*\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0004JD\u0010\u001d\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00152\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0004H\u0014J\u0018\u0010%\u001a\u00020&2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J0\u0010'\u001a\u00020&2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u001bH\u0014J4\u0010*\u001a\u00020&2\u0006\u0010\r\u001a\u00020+2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00152\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010(\u001a\u00020.2\u0006\u0010)\u001a\u00020.H\u0002J0\u0010/\u001a\u00020&2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u001bH\u0014JD\u00100\u001a\u00020&2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00152\u0006\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u001b2\u0006\u00101\u001a\u00020-2\b\u00102\u001a\u0004\u0018\u00010-H\u0002J\"\u00103\u001a\u00020&2\u0006\u0010\r\u001a\u00020+2\b\u00104\u001a\u0004\u0018\u00010\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010-J\"\u00105\u001a\u00020&2\u0006\u0010\r\u001a\u00020+2\b\u00104\u001a\u0004\u0018\u00010\u00152\b\u00106\u001a\u0004\u0018\u00010-J\"\u00107\u001a\u00020&2\u0006\u0010\r\u001a\u00020+2\b\u00104\u001a\u0004\u0018\u00010\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010-JP\u00108\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\r\u001a\u0004\u0018\u00010+2\u0006\u0010\u001e\u001a\u00020\u00192\b\u0010\u001f\u001a\u0004\u0018\u00010\u00152\u0006\u00109\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020\u001b2\b\u00101\u001a\u0004\u0018\u00010-2\b\u00102\u001a\u0004\u0018\u00010-H\u0002J\u0012\u0010;\u001a\u0004\u0018\u00010-2\b\u0010\u000f\u001a\u0004\u0018\u00010-R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/kamaeleo/labeling/EnhancedJLabel$EnhancedLabelUI;", "Ljavax/swing/plaf/basic/BasicLabelUI;", "(Lorg/kamaeleo/labeling/EnhancedJLabel;)V", "paintIconR", "Ljava/awt/Rectangle;", "paintTextR", "useSwingPaintText", "", "createAffineTransform", "Ljava/awt/geom/AffineTransform;", "dimension", "Ljava/awt/Dimension;", "getMinimumSize", "g", "Ljava/awt/Graphics;", "c", "Ljavax/swing/JComponent;", "getPreferredSize", "getRotatedDimension", "getUnrotatedPreferredSize", "layout", "", "label", "Ljavax/swing/JLabel;", "fm", "Ljava/awt/FontMetrics;", "width", "", "height", "layoutCL", "fontMetrics", "text", "icon", "Ljavax/swing/Icon;", "viewR", "iconR", "textR", "paint", "", "paintDisabledText", "x", "y", "paintEffect", "Ljava/awt/Graphics2D;", "color", "Ljava/awt/Color;", "", "paintEnabledText", "paintText", "foreground", "background", "paintTextEmphasize", "s", "paintTextGlow", "glow", "paintTextShadow", "paintWordWrapText", "desiredWidth", "yStart", "removeAlpha", "kamaeleo"})
    protected final class EnhancedLabelUI
    extends BasicLabelUI {
        private final boolean useSwingPaintText;
        private final Rectangle paintIconR = new Rectangle();
        private final Rectangle paintTextR = new Rectangle();

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void paint(@NotNull Graphics g, @NotNull JComponent c2) {
            Icon icon;
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
            Graphics2D g2 = (Graphics2D)g;
            JLabel label = (JLabel)c2;
            EnhancedLabel.Rendering rendering = EnhancedJLabel.this.getRendering();
            if (rendering != null) {
                switch (EnhancedJLabel$EnhancedLabelUI$WhenMappings.$EnumSwitchMapping$0[rendering.ordinal()]) {
                    case 1: {
                        int n;
                        int y = 0;
                        if (label.getVerticalAlignment() != 1) {
                            Dimension d = this.getPreferredSize(g, c2);
                            switch (label.getVerticalAlignment()) {
                                case 0: {
                                    n = Math.max(0, (c2.getHeight() - d.height) / 2);
                                    break;
                                }
                                case 3: {
                                    n = Math.max(0, c2.getHeight() - d.height);
                                    break;
                                }
                                default: {
                                    n = 0;
                                    break;
                                }
                            }
                        } else {
                            n = 0;
                        }
                        y = n;
                        g2.setFont(EnhancedJLabel.this.getFont());
                        FontMetrics fontMetrics = g2.getFontMetrics();
                        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"g2.fontMetrics");
                        this.paintWordWrapText(label, g2, fontMetrics, EnhancedJLabel.this.getText(), EnhancedJLabel.this.getDesiredSize().width, y, label.getForeground(), label.getBackground());
                        return;
                    }
                }
            }
            switch (label.getHorizontalAlignment()) {
                case 2: 
                case 10: {
                    break;
                }
                case 0: {
                    break;
                }
                case 4: 
                case 11: {
                    break;
                }
            }
            switch (label.getVerticalAlignment()) {
                case 1: {
                    break;
                }
                case 0: {
                    break;
                }
                case 3: {
                    break;
                }
            }
            String text = label.getText();
            Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
            if (icon == null && text == null) {
                return;
            }
            FontMetrics fm = label.getFontMetrics(g2.getFont());
            int width = 0;
            int height = 0;
            width = c2.getWidth();
            height = c2.getHeight();
            FontMetrics fontMetrics = fm;
            Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"fm");
            String clippedText = this.layout(label, fontMetrics, width, height);
            if (EnhancedJLabel.this.getAngle() != 0.0) {
                g2.rotate(Math.PI * EnhancedJLabel.this.getAngle() / 180.0, this.paintTextR.getCenterX(), this.paintTextR.getCenterY());
            }
            Icon icon3 = icon;
            if (icon3 != null) {
                icon3.paintIcon(c2, g2, this.paintIconR.x, this.paintIconR.y);
            }
            if (text == null) return;
            View v = (View)c2.getClientProperty("html");
            if (v != null) {
                v.paint(g2, this.paintTextR);
                return;
            }
            int textX = this.paintTextR.x;
            int textY = this.paintTextR.y + fm.getAscent();
            if (label.isEnabled()) {
                Graphics graphics = g2;
                String string = clippedText;
                Intrinsics.checkNotNull((Object)string);
                this.paintEnabledText(label, graphics, string, textX, textY);
                return;
            }
            Graphics graphics = g2;
            String string = clippedText;
            Intrinsics.checkNotNull((Object)string);
            this.paintDisabledText(label, graphics, string, textX, textY);
        }

        @Nullable
        protected final String layout(@NotNull JLabel label, @NotNull FontMetrics fm, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
            Insets insets = label.getInsets(null);
            String text = label.getText();
            Icon icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
            Rectangle paintViewR = new Rectangle();
            paintViewR.x = insets.left;
            paintViewR.y = insets.top;
            paintViewR.width = width - (insets.left + insets.right);
            paintViewR.height = height - (insets.top + insets.bottom);
            this.paintIconR.x = this.paintIconR.y = (this.paintIconR.width = (this.paintIconR.height = 0));
            this.paintTextR.x = this.paintTextR.y = (this.paintTextR.width = (this.paintTextR.height = 0));
            String string = text;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
            return this.layoutCL(label, fm, string, icon, paintViewR, this.paintIconR, this.paintTextR);
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public final Dimension getMinimumSize(@NotNull Graphics g, @NotNull JComponent c2) {
            Dimension dimension;
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
            EnhancedLabel.Rendering rendering = EnhancedJLabel.this.getRendering();
            if (rendering != null) {
                switch (EnhancedJLabel$EnhancedLabelUI$WhenMappings.$EnumSwitchMapping$1[rendering.ordinal()]) {
                    case 1: {
                        Graphics2D g2 = (Graphics2D)g;
                        EnhancedJLabel label = (EnhancedJLabel)c2;
                        g2.setFont(EnhancedJLabel.this.getFont());
                        FontMetrics fontMetrics = g2.getFontMetrics(EnhancedJLabel.this.getFont());
                        JLabel jLabel = label;
                        FontMetrics fontMetrics2 = fontMetrics;
                        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics2, (String)"fontMetrics");
                        Dimension d = this.paintWordWrapText(jLabel, null, fontMetrics2, EnhancedJLabel.this.getText(), label.getDesiredSize().width, 0, null, null);
                        dimension = new Dimension(d.width, fontMetrics.getHeight());
                        return dimension;
                    }
                }
            }
            dimension = this.getPreferredSize(c2);
            return dimension;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Dimension getMinimumSize(@NotNull JComponent c2) {
            Dimension dimension;
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
            EnhancedLabel.Rendering rendering = EnhancedJLabel.this.getRendering();
            if (rendering != null) {
                switch (EnhancedJLabel$EnhancedLabelUI$WhenMappings.$EnumSwitchMapping$2[rendering.ordinal()]) {
                    case 1: {
                        EnhancedJLabel label = (EnhancedJLabel)c2;
                        JLabel jLabel = label;
                        FontMetrics fontMetrics = label.getFontMetrics(label.getFont());
                        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"label.getFontMetrics(label.font)");
                        Dimension d = this.paintWordWrapText(jLabel, null, fontMetrics, EnhancedJLabel.this.getText(), label.getDesiredSize().width, 0, null, null);
                        int n = d.width;
                        FontMetrics fontMetrics2 = EnhancedJLabel.this.getFontMetrics(EnhancedJLabel.this.getFont());
                        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics2, (String)"getFontMetrics(font)");
                        dimension = new Dimension(n, fontMetrics2.getHeight());
                        return dimension;
                    }
                }
            }
            dimension = this.getPreferredSize(c2);
            return dimension;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public final Dimension getPreferredSize(@NotNull Graphics g, @NotNull JComponent c2) {
            Dimension dimension;
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
            Insets insets = EnhancedJLabel.this.getInsets();
            Dimension size = null;
            EnhancedLabel.Rendering rendering = EnhancedJLabel.this.getRendering();
            if (rendering != null) {
                switch (EnhancedJLabel$EnhancedLabelUI$WhenMappings.$EnumSwitchMapping$3[rendering.ordinal()]) {
                    case 1: {
                        Graphics2D g2 = (Graphics2D)g;
                        EnhancedJLabel label = (EnhancedJLabel)c2;
                        g2.setFont(EnhancedJLabel.this.getFont());
                        JLabel jLabel = label;
                        FontMetrics fontMetrics = g2.getFontMetrics(EnhancedJLabel.this.getFont());
                        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"g2.getFontMetrics(font)");
                        Dimension d = this.paintWordWrapText(jLabel, null, fontMetrics, EnhancedJLabel.this.getText(), label.getDesiredSize().width, 0, null, null);
                        return new Dimension(d.width, d.height);
                    }
                }
            }
            if (EnhancedJLabel.this.getAngle() != 0.0) {
                Dimension dimension2 = super.getPreferredSize(c2);
                Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"super.getPreferredSize(c)");
                Dimension d = this.getRotatedDimension(dimension2);
                dimension = new Dimension(d.width + insets.left + insets.right, d.height + insets.top + insets.bottom);
                return dimension;
            } else {
                Dimension dimension3 = super.getPreferredSize(c2);
                dimension = dimension3;
                Intrinsics.checkNotNullExpressionValue((Object)dimension3, (String)"super.getPreferredSize(c)");
            }
            return dimension;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @NotNull
        public Dimension getPreferredSize(@NotNull JComponent c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            insets = EnhancedJLabel.this.getInsets();
            size = null;
            v0 = EnhancedJLabel.this.getRendering();
            if (v0 == null) ** GOTO lbl-1000
            switch (EnhancedJLabel$EnhancedLabelUI$WhenMappings.$EnumSwitchMapping$4[v0.ordinal()]) {
                case 1: {
                    label = (EnhancedJLabel)c;
                    v1 = label;
                    v2 = label.getFontMetrics(label.getFont());
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"label.getFontMetrics(label.font)");
                    d = this.paintWordWrapText(v1, null, v2, EnhancedJLabel.this.getText(), label.getDesiredSize().width, 0, null, null);
                    v3 = new Dimension(d.width, d.height);
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    if (EnhancedJLabel.this.getAngle() != 0.0) {
                        v4 = super.getPreferredSize(c);
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"super.getPreferredSize(c)");
                        d = this.getRotatedDimension(v4);
                        v5 = new Dimension(d.width + insets.left + insets.right, d.height + insets.top + insets.bottom);
                    } else {
                        v5 = super.getPreferredSize(c);
                    }
                    v3 = v5;
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"if (angle != 0.0) {\n    \u2026Size(c)\n                }");
                }
            }
            size = v3;
            return size;
        }

        private final Dimension getRotatedDimension(Dimension dimension) {
            AffineTransform at = this.createAffineTransform(dimension);
            Shape shape = at.createTransformedShape(new Rectangle(dimension));
            Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"at.createTransformedShape(Rectangle(dimension))");
            Rectangle rect = shape.getBounds();
            return new Dimension(rect.width, rect.height);
        }

        private final AffineTransform createAffineTransform(Dimension dimension) {
            AffineTransform at = new AffineTransform();
            at.rotate(Math.PI * EnhancedJLabel.this.getAngle() / 180.0, dimension.getWidth() / 2.0, dimension.getHeight() / 2.0);
            return at;
        }

        @NotNull
        public final Dimension getUnrotatedPreferredSize(@Nullable JComponent c2) {
            Dimension dimension = super.getPreferredSize(c2);
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"super.getPreferredSize(c)");
            return dimension;
        }

        @Override
        protected void paintEnabledText(@NotNull JLabel label, @NotNull Graphics g, @NotNull String text, int x, int y) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Color color = label.getForeground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"label.foreground");
            this.paintText(label, g, text, x, y, color, label.getBackground());
        }

        @Override
        protected void paintDisabledText(@NotNull JLabel label, @NotNull Graphics g, @NotNull String text, int x, int y) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Color color = label.getForeground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"label.foreground");
            this.paintText(label, g, text, x, y, color, label.getBackground());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @Nullable
        protected String layoutCL(@NotNull JLabel label, @NotNull FontMetrics fontMetrics, @NotNull String text, @Nullable Icon icon, @NotNull Rectangle viewR, @NotNull Rectangle iconR, @NotNull Rectangle textR) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)viewR, (String)"viewR");
            Intrinsics.checkNotNullParameter((Object)iconR, (String)"iconR");
            Intrinsics.checkNotNullParameter((Object)textR, (String)"textR");
            EnhancedLabel.Rendering rendering = EnhancedJLabel.this.getRendering();
            if (rendering == null) return text;
            switch (EnhancedJLabel$EnhancedLabelUI$WhenMappings.$EnumSwitchMapping$5[rendering.ordinal()]) {
                case 1: {
                    String truncatedString = super.layoutCL(label, fontMetrics, text, icon, viewR, iconR, textR);
                    if (!Intrinsics.areEqual((Object)text, (Object)truncatedString)) {
                        if (truncatedString == null) return null;
                        if (truncatedString.length() <= 3) return null;
                        if (EnhancedJLabel.this.getMinimumCharactersToDisplay() != null) {
                            int n = truncatedString.length() - 3;
                            Integer n2 = EnhancedJLabel.this.getMinimumCharactersToDisplay();
                            Intrinsics.checkNotNull((Object)n2);
                            if (n < n2) return null;
                        }
                    }
                    String string = truncatedString;
                    return string;
                }
                case 2: {
                    String clippedString = super.layoutCL(label, fontMetrics, text, icon, viewR, iconR, textR);
                    if (!(Intrinsics.areEqual((Object)text, (Object)clippedString) ^ true)) return text;
                    if (clippedString == null) return text;
                    if (EnhancedJLabel.this.getMinimumCharactersToDisplay() == null) return text;
                    int n = clippedString.length();
                    Integer n3 = EnhancedJLabel.this.getMinimumCharactersToDisplay();
                    Intrinsics.checkNotNull((Object)n3);
                    if (n >= n3) return text;
                    return null;
                }
            }
            return text;
        }

        private final void paintText(JLabel label, Graphics g, String text, int x, int y, Color foreground, Color background) {
            g.setColor(foreground);
            if (background != null) {
                g.translate(x, y);
                EnhancedLabel enhancedLabel = EnhancedJLabel.this.data;
                Intrinsics.checkNotNull((Object)enhancedLabel);
                switch (EnhancedJLabel$EnhancedLabelUI$WhenMappings.$EnumSwitchMapping$6[enhancedLabel.getEffect().ordinal()]) {
                    case 1: {
                        Graphics graphics = g;
                        if (graphics == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
                        }
                        this.paintTextShadow((Graphics2D)graphics, text, background);
                        break;
                    }
                    case 2: {
                        Graphics graphics = g;
                        if (graphics == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
                        }
                        this.paintTextGlow((Graphics2D)graphics, text, background);
                        break;
                    }
                    case 3: {
                        Graphics graphics = g;
                        if (graphics == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
                        }
                        this.paintTextGlow((Graphics2D)graphics, text, background);
                        break;
                    }
                    case 4: {
                        Graphics graphics = g;
                        if (graphics == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
                        }
                        this.paintTextEmphasize((Graphics2D)graphics, text, background);
                        break;
                    }
                }
                g.translate(-x, -y);
            }
            if (this.useSwingPaintText) {
                super.paintEnabledText(label, g, text, x, y);
            } else if (text != null) {
                g.drawString(text, x, y);
            }
        }

        private final Dimension paintWordWrapText(JLabel label, Graphics2D g, FontMetrics fontMetrics, String text, int desiredWidth, int yStart, Color foreground, Color background) {
            Insets insets = EnhancedJLabel.this.getInsets();
            int width = desiredWidth + (insets.left + insets.right);
            float w = (float)insets.left + (float)insets.right;
            float x = insets.left;
            float y = (float)yStart + (float)insets.top;
            if (desiredWidth > 0 && text != null && text.length() > 0) {
                if (g != null) {
                    // empty if block
                }
                AttributedString as = new AttributedString(text);
                as.addAttribute(TextAttribute.FONT, EnhancedJLabel.this.getFont());
                as.addAttribute(TextAttribute.FOREGROUND, foreground);
                AttributedCharacterIterator aci = as.getIterator();
                FontRenderContext fontRenderContext = fontMetrics.getFontRenderContext();
                BreakIterator breakIterator = BreakIterator.getLineInstance();
                LineBreakMeasurer lbm = new LineBreakMeasurer(aci, breakIterator, fontRenderContext);
                float max = 0.0f;
                try {
                    while (true) {
                        int n = lbm.getPosition();
                        AttributedCharacterIterator attributedCharacterIterator = aci;
                        Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"aci");
                        if (n < attributedCharacterIterator.getEndIndex()) {
                            TextLayout layout = lbm.nextLayout(desiredWidth);
                            if (g != null && EnhancedJLabel.this.isJustified()) {
                                TextLayout textLayout = layout;
                                Intrinsics.checkNotNullExpressionValue((Object)textLayout, (String)"layout");
                                if ((double)textLayout.getVisibleAdvance() > 0.8 * (double)desiredWidth) {
                                    layout = layout.getJustifiedLayout(desiredWidth);
                                }
                            }
                            TextLayout textLayout = layout;
                            Intrinsics.checkNotNullExpressionValue((Object)textLayout, (String)"layout");
                            float ascent = textLayout.getAscent();
                            float visibleAdvance = layout.getVisibleAdvance();
                            if (g != null) {
                                switch (label.getHorizontalAlignment()) {
                                    case 2: 
                                    case 10: {
                                        layout.draw(g, x, y + ascent);
                                        break;
                                    }
                                    case 0: {
                                        float leftMargin = insets.left;
                                        float rightMargin = (float)EnhancedJLabel.this.getWidth() - (float)insets.right;
                                        layout.draw(g, (leftMargin + rightMargin - visibleAdvance) / (float)2, y + ascent);
                                        break;
                                    }
                                    case 4: 
                                    case 11: {
                                        float rightMargin = (float)EnhancedJLabel.this.getWidth() - (float)insets.right;
                                        layout.draw(g, rightMargin - visibleAdvance, y + ascent);
                                        break;
                                    }
                                    default: {
                                        layout.draw(g, x, y + ascent);
                                    }
                                }
                            }
                            float leading = layout.getLeading();
                            float descent = layout.getDescent();
                            y += descent + leading + ascent;
                            max = Math.max(max, visibleAdvance);
                            continue;
                        }
                        break;
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
                w += max;
            }
            return new Dimension((int)Math.ceil(w), (int)Math.ceil(y) + insets.bottom);
        }

        private final void paintEffect(Graphics2D g, String text, Color color, double x, double y) {
            if (text != null) {
                Object oldTextAAHint = g.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                Composite oldComposite = g.getComposite();
                Color oldColor = g.getColor();
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g.setColor(color);
                g.translate(x, y);
                FontMetrics fontMetrics = g.getFontMetrics();
                Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"g.fontMetrics");
                int additionalOffset = fontMetrics.getHeight() / 32;
                EnhancedLabel enhancedLabel = EnhancedJLabel.this.data;
                Intrinsics.checkNotNull((Object)enhancedLabel);
                switch (EnhancedJLabel$EnhancedLabelUI$WhenMappings.$EnumSwitchMapping$7[enhancedLabel.getEffect().ordinal()]) {
                    case 1: {
                        int size1 = 1 + additionalOffset;
                        for (int j = 0; j < size1; ++j) {
                            double distance = (double)j * (double)j;
                            float alpha = EnhancedJLabel.this.getEffectOpacity();
                            if (distance > 0.0) {
                                alpha = (float)((double)0.5f / distance * (double)EnhancedJLabel.this.getEffectOpacity());
                            }
                            if (alpha > 1.0f) {
                                alpha = 1.0f;
                            }
                            g.setComposite(AlphaComposite.getInstance(3, alpha));
                            g.drawString(text, 0, j);
                        }
                        break;
                    }
                    case 2: {
                        int size = 1 + additionalOffset;
                        for (int i = 0; i < size; ++i) {
                            for (int j = 0; j < size; ++j) {
                                double distance = (double)(i * i) + (double)j * (double)j;
                                float alpha = EnhancedJLabel.this.getEffectOpacity();
                                if (distance > 0.0) {
                                    alpha = (float)((double)0.5f / distance * (double)EnhancedJLabel.this.getEffectOpacity());
                                }
                                if (alpha > 1.0f) {
                                    alpha = 1.0f;
                                }
                                g.setComposite(AlphaComposite.getInstance(3, alpha));
                                g.drawString(text, i, j);
                            }
                        }
                        break;
                    }
                    case 3: {
                        int size3 = 1 + additionalOffset;
                        for (int i = -size3; i <= size3; ++i) {
                            for (int j = -size3; j <= size3; ++j) {
                                double distance = (double)(i * i) + (double)j * (double)j;
                                float alpha = EnhancedJLabel.this.getEffectOpacity();
                                if (!(distance > 0.0)) continue;
                                alpha = (float)((double)1.0f / distance * (double)EnhancedJLabel.this.getEffectOpacity());
                                if (alpha > 1.0f) {
                                    alpha = 1.0f;
                                }
                                g.setComposite(AlphaComposite.getInstance(3, alpha));
                                g.drawString(text, i, j);
                            }
                        }
                        break;
                    }
                    case 4: {
                        Object oldAAHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        FontRenderContext frc = g.getFontRenderContext();
                        Font font = EnhancedJLabel.this.getFont();
                        Intrinsics.checkNotNull((Object)font);
                        GlyphVector gv = font.createGlyphVector(frc, text);
                        g.setStroke(new BasicStroke(2 + additionalOffset));
                        g.setComposite(AlphaComposite.getInstance(3, EnhancedJLabel.this.getEffectOpacity()));
                        GlyphVector glyphVector = gv;
                        Intrinsics.checkNotNullExpressionValue((Object)glyphVector, (String)"gv");
                        g.draw(glyphVector.getOutline());
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAAHint);
                        break;
                    }
                }
                g.translate(-x, -y);
                g.setComposite(oldComposite);
                g.setColor(oldColor);
                if (oldTextAAHint != null) {
                    g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldTextAAHint);
                }
            }
        }

        public final void paintTextShadow(@NotNull Graphics2D g, @Nullable String s, @Nullable Color c2) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            this.paintEffect(g, s, this.removeAlpha(c2), 1.0, 1.0);
        }

        public final void paintTextEmphasize(@NotNull Graphics2D g, @Nullable String s, @Nullable Color c2) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            this.paintEffect(g, s, this.removeAlpha(c2), 0.0, 1.0);
        }

        public final void paintTextGlow(@NotNull Graphics2D g, @Nullable String s, @Nullable Color glow) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            this.paintEffect(g, s, this.removeAlpha(glow), 0.0, 0.0);
        }

        @Nullable
        public final Color removeAlpha(@Nullable Color c2) {
            Color c3 = c2;
            if (c3 != null && c3.getAlpha() != 100) {
                c3 = new Color(c3.getRGB());
            }
            return c3;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/kamaeleo/labeling/EnhancedJLabel$Companion;", "", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "kamaeleo"})
    public static final class Companion {
        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            JFrame frame = new JFrame("EnhancedJLabel");
            frame.setSize(new Dimension(600, 600));
            Container container = frame.getContentPane();
            Intrinsics.checkNotNullExpressionValue((Object)container, (String)"frame.contentPane");
            container.setLayout(new BorderLayout());
            EnhancedJLabel label = new EnhancedJLabel();
            label.setText("This is a test");
            Font font = label.getFont();
            Intrinsics.checkNotNull((Object)font);
            label.setFont(font.deriveFont(72.0f));
            label.setEffect(EnhancedLabel.Effect.Shadow);
            label.setBackground(Color.yellow);
            label.setRendering(EnhancedLabel.Rendering.Truncate);
            label.setVerticalAlignment(0);
            label.setHorizontalAlignment(0);
            label.setIconTextGap(0);
            frame.getContentPane().add((Component)label, "Center");
            frame.setVisible(true);
            Timer timer2 = new Timer(10, new ActionListener(label){
                final /* synthetic */ EnhancedJLabel $label;

                public final void actionPerformed(ActionEvent it) {
                    this.$label.setAngle((this.$label.getAngle() + 1.0) % (double)360);
                }
                {
                    this.$label = enhancedJLabel;
                }
            });
            timer2.start();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

