/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.labeling;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.kamaeleo.color.CPColor;
import org.kamaeleo.color.CPColorKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\u001a\u001e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\u0001H\u0002\u001a\u0014\u0010\r\u001a\u00020\b*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001H\u0002\u001a\f\u0010\u000f\u001a\u00020\f*\u00020\u0001H\u0002\u001a\f\u0010\u0010\u001a\u00020\b*\u00020\u0001H\u0002\u001a\u0014\u0010\u0011\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\fH\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\u00a8\u0006\u0013"}, d2={"Black", "Lorg/kamaeleo/color/CPColor;", "getBlack", "()Lorg/kamaeleo/color/CPColor;", "White", "getWhite", "getHSBColor", "h", "", "s", "b", "brightness", "", "diff", "background", "lum", "luminance", "replaceBrightness", "min", "kamaeleo"})
public final class EnhancedLabelKt {
    @NotNull
    private static final CPColor Black = new CPColor(0, 0, 0, -1, null);
    @NotNull
    private static final CPColor White = new CPColor(-1, -1, -1, -1, null);

    private static final CPColor replaceBrightness(CPColor $this$replaceBrightness, double min) {
        byte by = $this$replaceBrightness.getRed-w2LRezQ();
        boolean bl = false;
        int n = by & 0xFF;
        by = $this$replaceBrightness.getGreen-w2LRezQ();
        bl = false;
        int n2 = by & 0xFF;
        by = $this$replaceBrightness.getBlue-w2LRezQ();
        bl = false;
        float[] hsb = CPColorKt.RGBtoHSB(n, n2, by & 0xFF, null);
        return EnhancedLabelKt.getHSBColor(hsb[0], hsb[1], (float)min);
    }

    @NotNull
    public static final CPColor getHSBColor(float h, float s, float b) {
        return new CPColor(CPColorKt.HSBtoRGB(h, s, b));
    }

    private static final double brightness(CPColor $this$brightness) {
        byte by = $this$brightness.getRed-w2LRezQ();
        boolean bl = false;
        int n = by & 0xFF;
        by = $this$brightness.getGreen-w2LRezQ();
        bl = false;
        int n2 = by & 0xFF;
        by = $this$brightness.getBlue-w2LRezQ();
        bl = false;
        float[] hsb = CPColorKt.RGBtoHSB(n, n2, by & 0xFF, null);
        return hsb[2];
    }

    private static final double lum(CPColor $this$lum) {
        byte by = $this$lum.getRed-w2LRezQ();
        byte by2 = 0;
        int r = by & 0xFF;
        by2 = $this$lum.getGreen-w2LRezQ();
        byte by3 = 0;
        int g = by2 & 0xFF;
        by3 = $this$lum.getBlue-w2LRezQ();
        boolean bl = false;
        int b = by3 & 0xFF;
        return 0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b;
    }

    private static final float luminance(CPColor $this$luminance) {
        byte by = $this$luminance.getRed-w2LRezQ();
        byte by2 = 0;
        int r = by & 0xFF;
        by2 = $this$luminance.getGreen-w2LRezQ();
        byte by3 = 0;
        int g = by2 & 0xFF;
        by3 = $this$luminance.getBlue-w2LRezQ();
        boolean bl = false;
        int b = by3 & 0xFF;
        return (0.299f * (float)r + 0.587f * (float)g + 0.114f * (float)b) / 255.0f;
    }

    private static final float diff(CPColor $this$diff, CPColor background) {
        int n = $this$diff.getRed-w2LRezQ();
        int n2 = 0;
        int n3 = n & 0xFF;
        n = background.getRed-w2LRezQ();
        n2 = 0;
        n = n3 - (n & 0xFF);
        n2 = 0;
        int r = Math.abs(n);
        n2 = $this$diff.getGreen-w2LRezQ();
        int n4 = 0;
        int n5 = n2 & 0xFF;
        n2 = background.getGreen-w2LRezQ();
        n4 = 0;
        n2 = n5 - (n2 & 0xFF);
        n4 = 0;
        int g = Math.abs(n2);
        n4 = $this$diff.getBlue-w2LRezQ();
        boolean bl = false;
        int n6 = n4 & 0xFF;
        n4 = background.getBlue-w2LRezQ();
        bl = false;
        n4 = n6 - (n4 & 0xFF);
        bl = false;
        int b = Math.abs(n4);
        n4 = 0;
        n4 = Math.max(g, b);
        bl = false;
        return (float)Math.max(r, n4) / 255.0f;
    }

    @NotNull
    public static final CPColor getBlack() {
        return Black;
    }

    @NotNull
    public static final CPColor getWhite() {
        return White;
    }

    public static final /* synthetic */ float access$diff(CPColor $this$access_u24diff, CPColor background) {
        return EnhancedLabelKt.diff($this$access_u24diff, background);
    }

    public static final /* synthetic */ double access$brightness(CPColor $this$access_u24brightness) {
        return EnhancedLabelKt.brightness($this$access_u24brightness);
    }

    public static final /* synthetic */ CPColor access$replaceBrightness(CPColor $this$access_u24replaceBrightness, double min) {
        return EnhancedLabelKt.replaceBrightness($this$access_u24replaceBrightness, min);
    }

    public static final /* synthetic */ float access$luminance(CPColor $this$access_u24luminance) {
        return EnhancedLabelKt.luminance($this$access_u24luminance);
    }

    public static final /* synthetic */ double access$lum(CPColor $this$access_u24lum) {
        return EnhancedLabelKt.lum($this$access_u24lum);
    }
}

