/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.palette;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kamaeleo.color.CPColor;
import org.kamaeleo.palette.AbstractMutablePalette;
import org.kamaeleo.palette.DynamicPalette$WhenMappings;
import org.kamaeleo.palette.Palette;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B#\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\bB\u0015\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0010H\u0016J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\u00108TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00108TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lorg/kamaeleo/palette/DynamicPalette;", "Lorg/kamaeleo/palette/AbstractMutablePalette;", "colors", "", "Lorg/kamaeleo/color/CPColor;", "([Lorg/kamaeleo/color/CPColor;)V", "inverted", "", "(Z[Lorg/kamaeleo/color/CPColor;)V", "", "(Ljava/util/List;)V", "", "getColors", "()Ljava/util/List;", "setColors", "highestFraction", "", "getHighestFraction", "()D", "isInverted", "()Z", "setInverted", "(Z)V", "lowestFraction", "getLowestFraction", "getColor", "fraction", "getColorAt", "index", "", "kamaeleo"})
public class DynamicPalette
extends AbstractMutablePalette {
    @NotNull
    private List<CPColor> colors;
    private boolean isInverted;

    @NotNull
    protected final List<CPColor> getColors() {
        return this.colors;
    }

    protected final void setColors(@NotNull List<CPColor> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.colors = list;
    }

    @Override
    public boolean isInverted() {
        return this.isInverted;
    }

    public void setInverted(boolean bl) {
        this.isInverted = bl;
    }

    @Override
    @NotNull
    public CPColor getColor(double fraction) {
        CPColor cPColor;
        double fraction2 = fraction;
        boolean inverted = this.isInverted();
        Palette.Cycle cycle = this.getCycle();
        if (cycle != null) {
            switch (DynamicPalette$WhenMappings.$EnumSwitchMapping$0[cycle.ordinal()]) {
                case 1: {
                    inverted = (int)fraction2 % 2 == 0;
                    fraction2 -= (double)((int)fraction2);
                    break;
                }
                case 2: {
                    fraction2 -= (double)((int)fraction2);
                    break;
                }
            }
        }
        if (fraction2 < this.getLowestFraction()) {
            cPColor = this.getColor(this.getLowestFraction());
        } else if (fraction2 > this.getHighestFraction()) {
            cPColor = this.getColor(this.getHighestFraction());
        } else {
            int index = this.getEntry(!inverted ? fraction2 : 1.0 - fraction2, this.getColorCount(), this.colors.size());
            List<CPColor> list = this.colors;
            Intrinsics.checkNotNull(list);
            cPColor = list.get(index);
        }
        return cPColor;
    }

    protected double getLowestFraction() {
        return 0.0;
    }

    protected double getHighestFraction() {
        return 1.0;
    }

    @Override
    @NotNull
    public CPColor getColorAt(int index) {
        CPColor cPColor;
        int n = this.getColorCount();
        List<CPColor> list = this.colors;
        Intrinsics.checkNotNull(list);
        if (n == list.size()) {
            if (index < 0) {
                cPColor = this.getColorAt(0);
            } else if (index > this.getColorCount() - 1) {
                cPColor = this.getColorAt(this.getColorCount() - 1);
            } else {
                List<CPColor> list2 = this.colors;
                Intrinsics.checkNotNull(list2);
                cPColor = list2.get(index);
            }
        } else {
            cPColor = this.getColor((double)this.getColorCount() / (double)index);
        }
        return cPColor;
    }

    public DynamicPalette(CPColor ... colors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        this.colors = ArraysKt.toMutableList((Object[])colors);
        this.setColorCount(this.colors.size());
    }

    public DynamicPalette(boolean inverted, CPColor ... colors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        this.colors = ArraysKt.toMutableList((Object[])colors);
        this.setColorCount(this.colors.size());
        this.setInverted(inverted);
    }

    public DynamicPalette(@NotNull List<CPColor> colors) {
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        this.colors = CollectionsKt.toMutableList((Collection)colors);
        List<CPColor> list = this.colors;
        Intrinsics.checkNotNull(list);
        this.setColorCount(list.size());
    }
}

