/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.transform;

import com.macrofocus.common.interval.BoundedInterval;
import com.macrofocus.common.interval.Interval;
import com.macrofocus.common.interval.IntervalEvent;
import com.macrofocus.common.interval.IntervalListener;
import com.macrofocus.common.transform.MutableOneDScreenTransform;
import com.macrofocus.common.transform.ScreenTransformEvent;
import com.macrofocus.common.transform.SimpleOneDScreenTransform;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.geom.Point;
import org.kamaeleo.geom.Point2D;
import org.kamaeleo.geom.Rectangle;
import org.kamaeleo.geom.Rectangle2D;
import org.kamaeleo.transform.AbstractMutableTwoDScreenTransform;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B5\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u000b\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010#\u001a\u00020'2\u0006\u0010%\u001a\u00020(H\u0016J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0003H\u0016J\u0010\u0010-\u001a\u00020*2\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u0018\u0010.\u001a\u00020*2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020*H\u0002J\u0010\u00102\u001a\u00020&2\u0006\u00103\u001a\u00020$H\u0016J\u0010\u00102\u001a\u00020(2\u0006\u00103\u001a\u00020'H\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0014\"\u0004\b\u0018\u0010\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0004\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001aR\u001e\u0010!\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001f\u00a8\u00064"}, d2={"Lorg/kamaeleo/transform/SimpleTwoDScreenTransform;", "Lorg/kamaeleo/transform/AbstractMutableTwoDScreenTransform;", "x", "Lcom/macrofocus/common/interval/BoundedInterval;", "y", "screenWidth", "", "screenHeight", "worldAspectRatio", "", "(Lcom/macrofocus/common/interval/BoundedInterval;Lcom/macrofocus/common/interval/BoundedInterval;IID)V", "Lcom/macrofocus/common/transform/MutableOneDScreenTransform;", "(Lcom/macrofocus/common/transform/MutableOneDScreenTransform;Lcom/macrofocus/common/transform/MutableOneDScreenTransform;IID)V", "intervalListener", "Lcom/macrofocus/common/interval/IntervalListener;", "isAffine", "", "()Z", "maintainAspectRatio", "getScreenHeight", "()I", "setScreenHeight", "(I)V", "getScreenWidth", "setScreenWidth", "getX", "()Lcom/macrofocus/common/transform/MutableOneDScreenTransform;", "<set-?>", "Lcom/macrofocus/common/interval/Interval;", "xWorldInterval", "getXWorldInterval", "()Lcom/macrofocus/common/interval/Interval;", "getY", "yWorldInterval", "getYWorldInterval", "screenToWorld", "Lorg/kamaeleo/geom/Point2D;", "screen", "Lorg/kamaeleo/geom/Point;", "Lorg/kamaeleo/geom/Rectangle2D;", "Lorg/kamaeleo/geom/Rectangle;", "setIntervals", "", "xInterval", "yInterval", "setMaintainAspectRatio", "setScreenSize", "toString", "", "updateAspectRatio", "worldToScreen", "world", "kamaeleo"})
public final class SimpleTwoDScreenTransform
extends AbstractMutableTwoDScreenTransform {
    private int screenWidth;
    private int screenHeight;
    @NotNull
    private Interval xWorldInterval;
    @NotNull
    private Interval yWorldInterval;
    @NotNull
    private final MutableOneDScreenTransform x;
    @NotNull
    private final MutableOneDScreenTransform y;
    private boolean maintainAspectRatio;
    private final double worldAspectRatio;
    private final IntervalListener intervalListener;

    @Override
    public int getScreenWidth() {
        return this.screenWidth;
    }

    public void setScreenWidth(int n) {
        this.screenWidth = n;
    }

    @Override
    public int getScreenHeight() {
        return this.screenHeight;
    }

    public void setScreenHeight(int n) {
        this.screenHeight = n;
    }

    @Override
    @NotNull
    public Interval getXWorldInterval() {
        return this.xWorldInterval;
    }

    @Override
    @NotNull
    public Interval getYWorldInterval() {
        return this.yWorldInterval;
    }

    @Override
    @NotNull
    public MutableOneDScreenTransform getX() {
        return this.x;
    }

    @Override
    @NotNull
    public MutableOneDScreenTransform getY() {
        return this.y;
    }

    @Override
    public void setIntervals(@NotNull BoundedInterval xInterval, @NotNull BoundedInterval yInterval) {
        Intrinsics.checkNotNullParameter((Object)xInterval, (String)"xInterval");
        Intrinsics.checkNotNullParameter((Object)yInterval, (String)"yInterval");
        Interval interval = this.getXWorldInterval();
        Intrinsics.checkNotNull((Object)interval);
        interval.removeIntervalListener(this.intervalListener);
        Interval interval2 = this.getYWorldInterval();
        Intrinsics.checkNotNull((Object)interval2);
        interval2.removeIntervalListener(this.intervalListener);
        this.xWorldInterval = (Interval)xInterval;
        this.yWorldInterval = (Interval)yInterval;
        Interval interval3 = this.getXWorldInterval();
        Intrinsics.checkNotNull((Object)interval3);
        interval3.addIntervalListener(this.intervalListener);
        this.getX().setWorldInterval(xInterval);
        Interval interval4 = this.getYWorldInterval();
        Intrinsics.checkNotNull((Object)interval4);
        interval4.addIntervalListener(this.intervalListener);
        this.getY().setWorldInterval(yInterval);
    }

    @Override
    @NotNull
    public Point2D screenToWorld(@NotNull Point screen) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        return new Point2D.Double(this.getX().screenToWorld(screen.getIx()), this.getY().screenToWorld(screen.getIy()));
    }

    @Override
    @NotNull
    public Rectangle2D screenToWorld(@NotNull Rectangle screen) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        double x1 = this.getX().screenToWorld(screen.getIx());
        double y1 = this.getY().screenToWorld(screen.getIy());
        double x2 = this.getX().screenToWorld(screen.getIx() + screen.getIwidth());
        double y2 = this.getY().screenToWorld(screen.getIy() + screen.getIheight());
        return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
    }

    @Override
    @NotNull
    public Point worldToScreen(@NotNull Point2D world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return new Point(this.getX().worldToScreen(world.getX()), this.getY().worldToScreen(world.getY()));
    }

    @Override
    @NotNull
    public Rectangle worldToScreen(@NotNull Rectangle2D world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        int x1 = this.getX().worldToScreen(world.getX());
        int y2 = this.getY().worldToScreen(world.getY());
        int x2 = this.getX().worldToScreen(world.getX() + world.getWidth());
        int y1 = this.getY().worldToScreen(world.getY() + world.getHeight());
        return new Rectangle(x1, y1, x2 - x1, y2 - y1);
    }

    @Override
    public boolean isAffine() {
        return true;
    }

    @Override
    public void setScreenSize(int screenWidth, int screenHeight) {
        if (this.getScreenWidth() != screenWidth || this.getScreenHeight() != screenHeight) {
            this.setScreenWidth(screenWidth);
            this.setScreenHeight(screenHeight);
            this.updateAspectRatio();
            this.getX().setScreenSize(screenWidth);
            this.getY().setScreenSize(screenHeight);
            this.notifyTransformChanged(new ScreenTransformEvent());
        }
    }

    @Override
    public void setMaintainAspectRatio(boolean maintainAspectRatio) {
        if (this.maintainAspectRatio != maintainAspectRatio) {
            this.maintainAspectRatio = maintainAspectRatio;
            this.updateAspectRatio();
            this.notifyTransformChanged(new ScreenTransformEvent());
        }
    }

    private final void updateAspectRatio() {
        double width = this.getScreenWidth();
        double height = (double)this.getScreenHeight() * this.worldAspectRatio;
        if (this.maintainAspectRatio && width != height) {
            if (width < height) {
                this.getX().setScreenMargins(0);
                this.getY().setScreenMargins((int)((double)this.getScreenHeight() - (double)this.getScreenWidth() / this.worldAspectRatio));
            } else {
                this.getX().setScreenMargins((int)((double)this.getScreenWidth() - (double)this.getScreenHeight() * this.worldAspectRatio));
                this.getY().setScreenMargins(0);
            }
        }
    }

    @NotNull
    public String toString() {
        return "SimpleTwoDScreenTransform{screenWidth=" + this.getScreenWidth() + ", screenHeight=" + this.getScreenHeight() + ", xInterval=" + this.getXWorldInterval() + ", yInterval=" + this.getYWorldInterval() + '}';
    }

    @JvmOverloads
    public SimpleTwoDScreenTransform(@NotNull BoundedInterval x, @NotNull BoundedInterval y, int screenWidth, int screenHeight, double worldAspectRatio) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        this.intervalListener = new IntervalListener(this){
            final /* synthetic */ SimpleTwoDScreenTransform this$0;

            public void intervalChanged(@Nullable IntervalEvent event2) {
                this.this$0.notifyTransformChanged(new ScreenTransformEvent());
            }
            {
                this.this$0 = this$0;
            }
        };
        this.xWorldInterval = (Interval)x;
        this.yWorldInterval = (Interval)y;
        this.x = (MutableOneDScreenTransform)new SimpleOneDScreenTransform(x, screenWidth);
        this.y = (MutableOneDScreenTransform)new SimpleOneDScreenTransform(y, screenHeight, true, false);
        this.setScreenWidth(screenWidth);
        this.setScreenHeight(screenHeight);
        this.worldAspectRatio = worldAspectRatio;
        Interval interval = this.getXWorldInterval();
        Intrinsics.checkNotNull((Object)interval);
        interval.addIntervalListener(this.intervalListener);
        Interval interval2 = this.getYWorldInterval();
        Intrinsics.checkNotNull((Object)interval2);
        interval2.addIntervalListener(this.intervalListener);
    }

    public /* synthetic */ SimpleTwoDScreenTransform(BoundedInterval boundedInterval, BoundedInterval boundedInterval2, int n, int n2, double d, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x10) != 0) {
            d = 1.0;
        }
        this(boundedInterval, boundedInterval2, n, n2, d);
    }

    @JvmOverloads
    public SimpleTwoDScreenTransform(@NotNull BoundedInterval x, @NotNull BoundedInterval y, int screenWidth, int screenHeight) {
        this(x, y, screenWidth, screenHeight, 0.0, 16, null);
    }

    @JvmOverloads
    public SimpleTwoDScreenTransform(@NotNull BoundedInterval x, @NotNull BoundedInterval y, int screenWidth) {
        this(x, y, screenWidth, 0, 0.0, 24, null);
    }

    @JvmOverloads
    public SimpleTwoDScreenTransform(@NotNull BoundedInterval x, @NotNull BoundedInterval y) {
        this(x, y, 0, 0, 0.0, 28, null);
    }

    public SimpleTwoDScreenTransform(@NotNull MutableOneDScreenTransform x, @NotNull MutableOneDScreenTransform y, int screenWidth, int screenHeight, double worldAspectRatio) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        this.intervalListener = new /* invalid duplicate definition of identical inner class */;
        this.xWorldInterval = x.getWorldInterval();
        this.yWorldInterval = y.getWorldInterval();
        this.x = x;
        this.y = y;
        this.setScreenWidth(screenWidth);
        this.setScreenHeight(screenHeight);
        this.worldAspectRatio = worldAspectRatio;
        Interval interval = this.getXWorldInterval();
        Intrinsics.checkNotNull((Object)interval);
        interval.addIntervalListener(this.intervalListener);
        Interval interval2 = this.getYWorldInterval();
        Intrinsics.checkNotNull((Object)interval2);
        interval2.addIntervalListener(this.intervalListener);
    }
}

