/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.geom.AffineTransform;
import org.kamaeleo.geom.EllipseIterator;
import org.kamaeleo.geom.FlatteningPathIterator;
import org.kamaeleo.geom.PathIterator;
import org.kamaeleo.geom.Point2D;
import org.kamaeleo.geom.Rectangle;
import org.kamaeleo.geom.Rectangle2D;
import org.kamaeleo.geom.Shape;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0016\bf\u0018\u00002\u00020\u0001:\u0001\u0018R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0012\u0010\b\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005R\u0012\u0010\n\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0005R\u0012\u0010\f\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0005R\u0012\u0010\u000e\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0005R\u0012\u0010\u0010\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0005R\u0012\u0010\u0012\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0005R\u0012\u0010\u0014\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0005R\u0012\u0010\u0016\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0005\u00a8\u0006\u0019"}, d2={"Lorg/kamaeleo/geom/Ellipse2D;", "Lorg/kamaeleo/geom/Shape;", "centerX", "", "getCenterX", "()D", "centerY", "getCenterY", "height", "getHeight", "maxX", "getMaxX", "maxY", "getMaxY", "minX", "getMinX", "minY", "getMinY", "width", "getWidth", "x", "getX", "y", "getY", "Double", "kamaeleo"})
public interface Ellipse2D
extends Shape {
    public double getX();

    public double getY();

    public double getWidth();

    public double getHeight();

    public double getMinX();

    public double getMinY();

    public double getMaxX();

    public double getMaxY();

    public double getCenterX();

    public double getCenterY();

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B \u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003J\u0011\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0096\u0002J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u0003H\u0016J\u0012\u0010\u001b\u001a\u00020\u001a2\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J\u0010\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020\bH\u0016J\b\u0010*\u001a\u00020+H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0014\u0010\u0011\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\rR\u0014\u0010\u0013\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\rR\u0014\u0010\u0015\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\rR\u0014\u0010\u0017\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\rR\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\r\u00a8\u0006,"}, d2={"Lorg/kamaeleo/geom/Ellipse2D$Double;", "Lorg/kamaeleo/geom/Ellipse2D;", "x", "", "y", "width", "height", "bounds2D", "Lorg/kamaeleo/geom/Rectangle2D;", "getBounds2D", "()Lorg/kamaeleo/geom/Rectangle2D;", "centerX", "getCenterX", "()D", "centerY", "getCenterY", "getHeight", "maxX", "getMaxX", "maxY", "getMaxY", "minX", "getMinX", "minY", "getMinY", "pathIterator", "Lorg/kamaeleo/geom/PathIterator;", "getPathIterator", "()Lorg/kamaeleo/geom/PathIterator;", "getWidth", "getX", "getY", "contains", "", "point", "Lorg/kamaeleo/geom/Point2D;", "getFlattenPathIterator", "flatness", "at", "Lorg/kamaeleo/geom/AffineTransform;", "intersects", "rect", "toString", "", "kamaeleo"})
    @StabilityInferred(parameters=0)
    public static final class Double
    implements Ellipse2D {
        private final double x;
        private final double y;
        private final double width;
        private final double height;
        public static final int $stable;

        public Double(double x, double y, double width, double height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        @NotNull
        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }

        @Override
        public boolean contains(@NotNull Point2D point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            double x = point.getX();
            double y = point.getY();
            double x0 = x;
            double y0 = y;
            return x >= x0 && y >= y0 && x < x0 + this.getWidth() && y < y0 + this.getHeight();
        }

        @Override
        public boolean intersects(@NotNull Rectangle2D rect) {
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            double x = rect.getX();
            double y = rect.getY();
            double w = rect.getWidth();
            double h = rect.getHeight();
            if (w <= 0.0 || h <= 0.0) {
                return false;
            }
            double ellw = this.getWidth();
            if (ellw <= 0.0) {
                return false;
            }
            double normx0 = (x - x) / ellw - 0.5;
            double ellh = this.getHeight();
            if (ellh <= 0.0) {
                return false;
            }
            double normy0 = (y - y) / ellh - 0.5;
            double nearx = 0.0;
            double normx1 = normx0 + w / ellw;
            nearx = normx0 > 0.0 ? normx0 : (normx1 < 0.0 ? normx1 : 0.0);
            double neary = 0.0;
            double normy1 = normy0 + h / ellh;
            neary = normy0 > 0.0 ? normy0 : (normy1 < 0.0 ? normy1 : 0.0);
            return nearx * nearx + neary * neary < 0.25;
        }

        @Override
        public double getMinX() {
            return this.getX();
        }

        @Override
        public double getMinY() {
            return this.getY();
        }

        @Override
        public double getMaxX() {
            return this.getX() + this.getWidth();
        }

        @Override
        public double getMaxY() {
            return this.getY() + this.getHeight();
        }

        @Override
        public double getCenterX() {
            return this.getX() + this.getWidth() / 2.0;
        }

        @Override
        public double getCenterY() {
            return this.getY() + this.getHeight() / 2.0;
        }

        @Override
        @NotNull
        public PathIterator getPathIterator() {
            return this.getPathIterator(null);
        }

        @Override
        @NotNull
        public PathIterator getPathIterator(@Nullable AffineTransform at) {
            return new EllipseIterator(this, at);
        }

        @Override
        @NotNull
        public PathIterator getFlattenPathIterator(double flatness) {
            return new FlatteningPathIterator(this.getPathIterator(), flatness);
        }

        @NotNull
        public String toString() {
            return "Ellipse2D.Double{x=" + this.getX() + ", y=" + this.getY() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + '}';
        }

        @Override
        @Nullable
        public Rectangle getBounds() {
            return DefaultImpls.getBounds(this);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Nullable
        public static Rectangle getBounds(@NotNull Ellipse2D this_) {
            return Shape.DefaultImpls.getBounds(this_);
        }
    }
}

