/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.geom.AffineTransform;
import org.kamaeleo.geom.Crossings;
import org.kamaeleo.geom.Path2D;
import org.kamaeleo.geom.PathIterator;
import org.kamaeleo.geom.Point;
import org.kamaeleo.geom.Point2D;
import org.kamaeleo.geom.Rectangle;
import org.kamaeleo.geom.Rectangle2D;
import org.kamaeleo.geom.Shape;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 >2\u00020\u0001:\u0002>?B\u0002\b\u0016B\u001a\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0006J\u001e\u0010%\u001a\u00020\"2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010&\u001a\u00020'2\u0006\u0010#\u001a\u00020(2\u0006\u0010$\u001a\u00020(J&\u0010&\u001a\u00020'2\u0006\u0010#\u001a\u00020(2\u0006\u0010$\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020(J\u0016\u0010&\u001a\u00020'2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0006J\u0011\u0010&\u001a\u00020'2\u0006\u0010+\u001a\u00020,H\u0086\u0002J\u0011\u0010&\u001a\u00020'2\u0006\u0010+\u001a\u00020-H\u0096\u0002J\u0011\u0010&\u001a\u00020'2\u0006\u0010.\u001a\u00020\bH\u0086\u0002J*\u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u00020(2\u0006\u00102\u001a\u00020(2\u0006\u00103\u001a\u00020(2\u0006\u00104\u001a\u00020(H\u0002J\u0010\u00105\u001a\u00020\u00182\u0006\u00106\u001a\u00020(H\u0016J\u0012\u0010\u0019\u001a\u00020\u00182\b\u00107\u001a\u0004\u0018\u000108H\u0016J\u0018\u0010\u0019\u001a\u00020\u00182\b\u00107\u001a\u0004\u0018\u0001082\u0006\u00106\u001a\u00020(J\u0018\u00109\u001a\u00020'2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0006H\u0007J&\u0010:\u001a\u00020'2\u0006\u0010#\u001a\u00020(2\u0006\u0010$\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020(J\u0010\u0010:\u001a\u00020'2\u0006\u0010.\u001a\u00020\bH\u0016J\u0006\u0010;\u001a\u00020\"J\u0006\u0010<\u001a\u00020\"J\u0016\u0010=\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0006R\u0011\u0010\u0007\u001a\u00020\b8G\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001c\"\u0004\b \u0010\u001e\u00a8\u0006@"}, d2={"Lorg/kamaeleo/geom/Polygon;", "Lorg/kamaeleo/geom/Shape;", "xpoints", "", "ypoints", "npoints", "", "boundingBox", "Lorg/kamaeleo/geom/Rectangle2D;", "getBoundingBox", "()Lorg/kamaeleo/geom/Rectangle2D;", "bounds", "Lorg/kamaeleo/geom/Rectangle;", "getBounds", "()Lorg/kamaeleo/geom/Rectangle;", "setBounds", "(Lorg/kamaeleo/geom/Rectangle;)V", "bounds2D", "getBounds2D", "getNpoints", "()I", "setNpoints", "(I)V", "pathIterator", "Lorg/kamaeleo/geom/PathIterator;", "getPathIterator", "()Lorg/kamaeleo/geom/PathIterator;", "getXpoints", "()[I", "setXpoints", "([I)V", "getYpoints", "setYpoints", "addPoint", "", "x", "y", "calculateBounds", "contains", "", "", "w", "h", "p", "Lorg/kamaeleo/geom/Point;", "Lorg/kamaeleo/geom/Point2D;", "r", "getCrossings", "Lorg/kamaeleo/geom/Crossings;", "xlo", "ylo", "xhi", "yhi", "getFlattenPathIterator", "flatness", "at", "Lorg/kamaeleo/geom/AffineTransform;", "inside", "intersects", "invalidate", "reset", "updateBounds", "Companion", "PolygonPathIterator", "kamaeleo"})
@StabilityInferred(parameters=0)
public final class Polygon
implements Shape {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int npoints;
    @NotNull
    private int[] xpoints;
    @NotNull
    private int[] ypoints;
    @Nullable
    private Rectangle bounds;
    public static final int $stable = 8;
    private static final long serialVersionUID = -6460061437900069969L;
    private static final int MIN_LENGTH = 4;

    public final int getNpoints() {
        return this.npoints;
    }

    public final void setNpoints(int n) {
        this.npoints = n;
    }

    @NotNull
    public final int[] getXpoints() {
        return this.xpoints;
    }

    public final void setXpoints(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.xpoints = nArray;
    }

    @NotNull
    public final int[] getYpoints() {
        return this.ypoints;
    }

    public final void setYpoints(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.ypoints = nArray;
    }

    @Override
    @Nullable
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(@Nullable Rectangle rectangle) {
        this.bounds = rectangle;
    }

    public Polygon() {
        this.xpoints = new int[4];
        this.ypoints = new int[4];
    }

    public Polygon(@NotNull int[] xpoints, @NotNull int[] ypoints, int npoints) {
        Intrinsics.checkNotNullParameter((Object)xpoints, (String)"xpoints");
        Intrinsics.checkNotNullParameter((Object)ypoints, (String)"ypoints");
        if (npoints > xpoints.length || npoints > ypoints.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        if (npoints < 0) {
            throw new RuntimeException("npoints < 0");
        }
        this.npoints = npoints;
        this.xpoints = Path2D.Companion.copyOf(xpoints, npoints);
        this.ypoints = Path2D.Companion.copyOf(ypoints, npoints);
    }

    public final void reset() {
        this.npoints = 0;
        this.setBounds(null);
    }

    public final void invalidate() {
        this.setBounds(null);
    }

    public final void addPoint(int x, int y) {
        int n;
        if (this.npoints >= this.xpoints.length || this.npoints >= this.ypoints.length) {
            int newLength = this.npoints * 2;
            if (newLength < 4) {
                newLength = 4;
            } else if ((newLength & newLength - 1) != 0) {
                n = newLength;
                boolean bl = false;
                newLength = Integer.highestOneBit(n);
            }
            this.xpoints = Path2D.Companion.copyOf(this.xpoints, newLength);
            this.ypoints = Path2D.Companion.copyOf(this.ypoints, newLength);
        }
        this.xpoints[this.npoints] = x;
        this.ypoints[this.npoints] = y;
        Polygon polygon = this;
        n = polygon.npoints;
        polygon.npoints = n + 1;
        if (this.getBounds() != null) {
            this.updateBounds(x, y);
        }
    }

    public final void updateBounds(int x, int y) {
        boolean bl;
        double d = x;
        Rectangle rectangle = this.getBounds();
        Intrinsics.checkNotNull((Object)rectangle);
        if (d < rectangle.getX()) {
            rectangle = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle);
            Rectangle rectangle2 = rectangle;
            rectangle = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle);
            int n = rectangle.getIwidth();
            rectangle = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle);
            rectangle2.setIwidth(n + (rectangle.getIx() - x));
            rectangle = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle);
            rectangle.setIx(x);
        } else {
            rectangle = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle);
            Rectangle rectangle3 = rectangle;
            rectangle = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle);
            int n = rectangle.getIwidth();
            Rectangle rectangle4 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle4);
            int n2 = x - rectangle4.getIx();
            bl = false;
            rectangle3.setIwidth(Math.max(n, n2));
        }
        double d2 = y;
        Rectangle rectangle5 = this.getBounds();
        Intrinsics.checkNotNull((Object)rectangle5);
        if (d2 < rectangle5.getY()) {
            rectangle5 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle5);
            Rectangle rectangle6 = rectangle5;
            rectangle5 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle5);
            int n = rectangle5.getIheight();
            rectangle5 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle5);
            rectangle6.setIheight(n + (rectangle5.getIy() - y));
            rectangle5 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle5);
            rectangle5.setIy(y);
        } else {
            rectangle5 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle5);
            Rectangle rectangle7 = rectangle5;
            rectangle5 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle5);
            int n = rectangle5.getIheight();
            Rectangle rectangle8 = this.getBounds();
            Intrinsics.checkNotNull((Object)rectangle8);
            int n3 = y - rectangle8.getIy();
            bl = false;
            rectangle7.setIheight(Math.max(n, n3));
        }
    }

    public final boolean contains(@NotNull Point p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this.contains(p.getX(), p.getY());
    }

    public final boolean contains(int x, int y) {
        return this.contains((double)x, (double)y);
    }

    public final boolean contains(double x, double y) {
        if (this.npoints <= 2 || !this.getBoundingBox().contains(x, y)) {
            return false;
        }
        int hits = 0;
        int lastx = this.xpoints[this.npoints - 1];
        int lasty = this.ypoints[this.npoints - 1];
        int curx = 0;
        int cury = 0;
        int i = 0;
        while (i < this.npoints) {
            int n;
            curx = this.xpoints[i];
            cury = this.ypoints[i];
            if (cury == lasty) {
                lastx = curx;
                lasty = cury;
                int n2 = i;
                i = n2 + 1;
                continue;
            }
            int leftx = 0;
            if (curx < lastx) {
                if (x >= (double)lastx) {
                    lastx = curx;
                    lasty = cury;
                    int n3 = i;
                    i = n3 + 1;
                    continue;
                }
                leftx = curx;
            } else {
                if (x >= (double)curx) {
                    lastx = curx;
                    lasty = cury;
                    int n4 = i;
                    i = n4 + 1;
                    continue;
                }
                leftx = lastx;
            }
            double test1 = 0.0;
            double test2 = 0.0;
            if (cury < lasty) {
                if (y < (double)cury || y >= (double)lasty) {
                    lastx = curx;
                    lasty = cury;
                    n = i;
                    i = n + 1;
                    continue;
                }
                if (x < (double)leftx) {
                    n = hits;
                    hits = n + 1;
                    lastx = curx;
                    lasty = cury;
                    n = i;
                    i = n + 1;
                    continue;
                }
                test1 = x - (double)curx;
                test2 = y - (double)cury;
            } else {
                if (y < (double)lasty || y >= (double)cury) {
                    lastx = curx;
                    lasty = cury;
                    n = i;
                    i = n + 1;
                    continue;
                }
                if (x < (double)leftx) {
                    n = hits;
                    hits = n + 1;
                    lastx = curx;
                    lasty = cury;
                    n = i;
                    i = n + 1;
                    continue;
                }
                test1 = x - (double)lastx;
                test2 = y - (double)lasty;
            }
            if (test1 < test2 / (double)(lasty - cury) * (double)(lastx - curx)) {
                n = hits;
                hits = n + 1;
            }
            lastx = curx;
            lasty = cury;
            n = i;
            i = n + 1;
        }
        return hits & true;
    }

    @Deprecated(message="As of JDK version 1.1,\n      replaced by <code>getBounds()</code>.")
    @NotNull
    public final Rectangle2D getBoundingBox() {
        if (this.npoints == 0) {
            return new Rectangle();
        }
        if (this.getBounds() == null) {
            this.calculateBounds(this.xpoints, this.ypoints, this.npoints);
        }
        Rectangle rectangle = this.getBounds();
        Intrinsics.checkNotNull((Object)rectangle);
        return rectangle.getBounds2D();
    }

    public final void calculateBounds(@NotNull int[] xpoints, @NotNull int[] ypoints, int npoints) {
        Intrinsics.checkNotNullParameter((Object)xpoints, (String)"xpoints");
        Intrinsics.checkNotNullParameter((Object)ypoints, (String)"ypoints");
        int boundsMinX = Integer.MAX_VALUE;
        int boundsMinY = Integer.MAX_VALUE;
        int boundsMaxX = Integer.MIN_VALUE;
        int boundsMaxY = Integer.MIN_VALUE;
        int n = 0;
        int n2 = npoints + -1;
        if (npoints != Integer.MIN_VALUE && n <= n2) {
            do {
                int i = n++;
                int x = xpoints[i];
                boolean bl = false;
                boundsMinX = Math.min(boundsMinX, x);
                bl = false;
                boundsMaxX = Math.max(boundsMaxX, x);
                int y = ypoints[i];
                boolean bl2 = false;
                boundsMinY = Math.min(boundsMinY, y);
                bl2 = false;
                boundsMaxY = Math.max(boundsMaxY, y);
            } while (n <= n2);
        }
        this.setBounds(new Rectangle(boundsMinX, boundsMinY, boundsMaxX - boundsMinX, boundsMaxY - boundsMinY));
    }

    @Deprecated(message="As of JDK version 1.1,\n      replaced by <code>contains(int, int)</code>.")
    public final boolean inside(int x, int y) {
        return this.contains((double)x, (double)y);
    }

    @Override
    @NotNull
    public Rectangle2D getBounds2D() {
        return this.getBoundingBox();
    }

    @Override
    public boolean contains(@NotNull Point2D p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean intersects(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public final boolean intersects(double x, double y, double w, double h) {
        if (this.npoints <= 0 || !this.getBoundingBox().intersects(x, y, w, h)) {
            return false;
        }
        Crossings cross = this.getCrossings(x, y, x + w, y + h);
        return cross == null || !cross.isEmpty();
    }

    private final Crossings getCrossings(double xlo, double ylo, double xhi, double yhi) {
        Crossings cross = new Crossings.EvenOdd(xlo, ylo, xhi, yhi);
        int lastx = this.xpoints[this.npoints - 1];
        int lasty = this.ypoints[this.npoints - 1];
        int n = this.npoints;
        int n2 = 0;
        int n3 = n + -1;
        if (n != Integer.MIN_VALUE && n2 <= n3) {
            do {
                int cury;
                int i;
                int curx;
                if (cross.accumulateLine(lastx, lasty, curx = this.xpoints[i = n2++], cury = this.ypoints[i])) {
                    return null;
                }
                lastx = curx;
                lasty = cury;
            } while (n2 <= n3);
        }
        return cross;
    }

    @Override
    @NotNull
    public PathIterator getPathIterator() {
        return this.getPathIterator(null);
    }

    @Override
    @NotNull
    public PathIterator getPathIterator(@Nullable AffineTransform at) {
        return new PolygonPathIterator(this, at);
    }

    @Override
    @NotNull
    public PathIterator getFlattenPathIterator(double flatness) {
        return this.getPathIterator(null, flatness);
    }

    @NotNull
    public final PathIterator getPathIterator(@Nullable AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    public final boolean contains(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public final boolean contains(double x, double y, double w, double h) {
        if (this.npoints <= 0 || !this.getBoundingBox().intersects(x, y, w, h)) {
            return false;
        }
        Crossings cross = this.getCrossings(x, y, x + w, y + h);
        return cross != null && cross.covers(y, y + h);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0013\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0019H\u0016J\t\u0010\u001a\u001a\u00020\u001bH\u0096\u0002R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\t\u00a8\u0006\u001c"}, d2={"Lorg/kamaeleo/geom/Polygon$PolygonPathIterator;", "Lorg/kamaeleo/geom/PathIterator;", "poly", "Lorg/kamaeleo/geom/Polygon;", "at", "Lorg/kamaeleo/geom/AffineTransform;", "index", "", "getIndex", "()I", "setIndex", "(I)V", "isDone", "", "()Z", "getPoly", "()Lorg/kamaeleo/geom/Polygon;", "transform", "getTransform", "()Lorg/kamaeleo/geom/AffineTransform;", "windingRule", "getWindingRule", "currentSegment", "coords", "", "", "next", "", "kamaeleo"})
    public static final class PolygonPathIterator
    implements PathIterator {
        @NotNull
        private final Polygon poly;
        @Nullable
        private final AffineTransform transform;
        private int index;

        public PolygonPathIterator(@NotNull Polygon poly, @Nullable AffineTransform at) {
            Intrinsics.checkNotNullParameter((Object)poly, (String)"poly");
            this.poly = poly;
            this.transform = at;
            if (this.poly.getNpoints() == 0) {
                this.index = 1;
            }
        }

        @NotNull
        public final Polygon getPoly() {
            return this.poly;
        }

        @Nullable
        public final AffineTransform getTransform() {
            return this.transform;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        @Override
        public int getWindingRule() {
            return Path2D.Companion.getWIND_EVEN_ODD();
        }

        @Override
        public boolean isDone() {
            return this.index > this.poly.getNpoints();
        }

        @Override
        public void next() {
            PolygonPathIterator polygonPathIterator = this;
            int n = polygonPathIterator.index;
            polygonPathIterator.index = n + 1;
        }

        @Override
        public int currentSegment(@NotNull float[] coords) {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            if (this.index >= this.poly.getNpoints()) {
                return 4;
            }
            coords[0] = this.poly.getXpoints()[this.index];
            coords[1] = this.poly.getYpoints()[this.index];
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }

        @Override
        public int currentSegment(@NotNull double[] coords) {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            if (this.index >= this.poly.getNpoints()) {
                return 4;
            }
            coords[0] = this.poly.getXpoints()[this.index];
            coords[1] = this.poly.getYpoints()[this.index];
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0002\b\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/kamaeleo/geom/Polygon$Companion;", "", "MIN_LENGTH", "", "serialVersionUID", "", "kamaeleo"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

