/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.geom.AffineTransform;
import org.kamaeleo.geom.PathIterator;
import org.kamaeleo.geom.Rectangle2D;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0013\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0014\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020!H\u0016J\t\u0010\"\u001a\u00020#H\u0096\u0002R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\fR\u0014\u0010\u0018\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0010R\u0011\u0010\u001a\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\fR\u0011\u0010\u001c\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\f\u00a8\u0006$"}, d2={"Lorg/kamaeleo/geom/RectIterator;", "Lorg/kamaeleo/geom/PathIterator;", "r", "Lorg/kamaeleo/geom/Rectangle2D;", "at", "Lorg/kamaeleo/geom/AffineTransform;", "affine", "getAffine", "()Lorg/kamaeleo/geom/AffineTransform;", "h", "", "getH", "()D", "index", "", "getIndex", "()I", "setIndex", "(I)V", "isDone", "", "()Z", "w", "getW", "windingRule", "getWindingRule", "x", "getX", "y", "getY", "currentSegment", "coords", "", "", "next", "", "kamaeleo"})
@StabilityInferred(parameters=0)
public final class RectIterator
implements PathIterator {
    private final double x;
    private final double y;
    private final double w;
    private final double h;
    @Nullable
    private final AffineTransform affine;
    private int index;
    public static final int $stable = 8;

    public RectIterator(@NotNull Rectangle2D r, @Nullable AffineTransform at) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        this.x = r.getX();
        this.y = r.getY();
        this.w = r.getWidth();
        this.h = r.getHeight();
        this.affine = at;
        if (this.w < 0.0 || this.h < 0.0) {
            this.index = 6;
        }
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getW() {
        return this.w;
    }

    public final double getH() {
        return this.h;
    }

    @Nullable
    public final AffineTransform getAffine() {
        return this.affine;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.index > 5;
    }

    @Override
    public void next() {
        RectIterator rectIterator = this;
        int n = rectIterator.index;
        rectIterator.index = n + 1;
    }

    @Override
    public int currentSegment(@NotNull float[] coords) {
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        if (this.isDone()) {
            throw new NoSuchElementException("rect iterator out of bounds");
        }
        if (this.index == 5) {
            return 4;
        }
        coords[0] = (float)this.x;
        coords[1] = (float)this.y;
        if (this.index == 1 || this.index == 2) {
            fArray = coords;
            fArray[0] = fArray[0] + (float)this.w;
        }
        if (this.index == 2 || this.index == 3) {
            fArray = coords;
            fArray[1] = fArray[1] + (float)this.h;
        }
        if (this.affine != null) {
            this.affine.transform(coords, 0, coords, 0, 1);
        }
        return this.index == 0 ? 0 : 1;
    }

    @Override
    public int currentSegment(@NotNull double[] coords) {
        double[] dArray;
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        if (this.isDone()) {
            throw new NoSuchElementException("rect iterator out of bounds");
        }
        if (this.index == 5) {
            return 4;
        }
        coords[0] = this.x;
        coords[1] = this.y;
        if (this.index == 1 || this.index == 2) {
            dArray = coords;
            dArray[0] = dArray[0] + this.w;
        }
        if (this.index == 2 || this.index == 3) {
            dArray = coords;
            dArray[1] = dArray[1] + this.h;
        }
        if (this.affine != null) {
            this.affine.transform(coords, 0, coords, 0, 1);
        }
        return this.index == 0 ? 0 : 1;
    }
}

