/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom.curve;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.geom.curve.BinaryCurveApproximationAlgorithm;
import org.kamaeleo.geom.curve.ControlPath;
import org.kamaeleo.geom.curve.GroupIterator;
import org.kamaeleo.geom.curve.MultiPath;
import org.kamaeleo.geom.curve.ParametricCurve;
import org.kamaeleo.geom.curve.Point;
import org.kamaeleo.geom.curve.ValueVector;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\n\b\u0017\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0016\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005J\u0016\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0007J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0016J\u0006\u0010$\u001a\u00020\u0007J\u0006\u0010%\u001a\u00020\u0007J\b\u0010&\u001a\u00020\u001eH\u0016J\u000e\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u0007J\u0016\u0010)\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\u0007J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006-"}, d2={"Lorg/kamaeleo/geom/curve/BSpline;", "Lorg/kamaeleo/geom/curve/ParametricCurve;", "cp", "Lorg/kamaeleo/geom/curve/ControlPath;", "gi", "Lorg/kamaeleo/geom/curve/GroupIterator;", "degree", "", "knotVector", "Lorg/kamaeleo/geom/curve/ValueVector;", "knotVectorType", "limit", "sampleLimit", "getSampleLimit", "()I", "setSampleLimit", "(I)V", "t_max", "", "t_min", "useDefaultInterval", "", "getUseDefaultInterval", "()Z", "setUseDefaultInterval", "(Z)V", "N", "t", "i", "appendTo", "", "mp", "Lorg/kamaeleo/geom/curve/MultiPath;", "eval", "p", "", "getDegree", "getKnotVectorType", "resetMemory", "setDegree", "d", "setInterval", "setKnotVectorType", "type", "Companion", "kamaeleo"})
@StabilityInferred(parameters=0)
public class BSpline
extends ParametricCurve {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ValueVector knotVector;
    private double t_min;
    private double t_max;
    private int sampleLimit;
    private int degree;
    private int knotVectorType;
    private boolean useDefaultInterval;
    public static final int $stable = 8;
    private static final int UNIFORM_CLAMPED = 0;
    private static final int UNIFORM_UNCLAMPED = 1;
    private static final int NON_UNIFORM = 2;
    @NotNull
    private static int[] a = new int[0];
    @NotNull
    private static int[] c = new int[0];
    @NotNull
    private static double[] knot = new double[0];

    public BSpline(@Nullable ControlPath cp, @Nullable GroupIterator gi) {
        super(cp, gi);
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0};
        this.knotVector = new ValueVector(dArray, 8);
        this.t_max = 1.0;
        this.sampleLimit = 1;
        this.degree = 4;
        this.useDefaultInterval = true;
    }

    @Override
    public int getSampleLimit() {
        return this.sampleLimit;
    }

    public void setSampleLimit(int limit) {
        this.sampleLimit = limit;
    }

    public final boolean getUseDefaultInterval() {
        return this.useDefaultInterval;
    }

    public final void setUseDefaultInterval(boolean bl) {
        this.useDefaultInterval = bl;
    }

    public final void setInterval(double t_min, double t_max) {
        this.t_min = t_min;
        this.t_max = t_max;
    }

    public final double t_min() {
        return this.t_min;
    }

    public final double t_max() {
        return this.t_max;
    }

    public final int getDegree() {
        return this.degree - 1;
    }

    public final void setDegree(int d) {
        this.degree = d + 1;
    }

    public final int getKnotVectorType() {
        return this.knotVectorType;
    }

    public final void setKnotVectorType(int type) {
        this.knotVectorType = type;
    }

    @Override
    public void appendTo(@NotNull MultiPath mp) {
        Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
        Object object = this.getGi();
        Intrinsics.checkNotNull((Object)object);
        GroupIterator groupIterator = object;
        object = this.getCp();
        Intrinsics.checkNotNull((Object)object);
        if (!groupIterator.isInRange(0, ((ControlPath)object).numPoints())) {
            return;
        }
        GroupIterator groupIterator2 = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator2);
        int numPts = groupIterator2.getGroupSize();
        int f = numPts - this.degree;
        if (f < 0) {
            return;
        }
        int x = numPts + this.degree;
        if (knot.length < x) {
            knot = new double[2 * x];
        }
        double t1 = this.t_min;
        double t2 = this.t_max;
        if (this.knotVectorType == 2) {
            if (this.knotVector.size() != x) {
                return;
            }
            BSpline.knot[0] = this.knotVector.get(0);
            int n = 1;
            int n2 = x + -1;
            if (x != Integer.MIN_VALUE && n <= n2) {
                do {
                    int i = n++;
                    BSpline.knot[i] = this.knotVector.get(i);
                    if (!(knot[i] < knot[i - 1])) continue;
                    return;
                } while (n <= n2);
            }
        } else if (this.knotVectorType == 1) {
            double grad = 1.0 / (double)(x - 1);
            int n = 0;
            int n3 = x + -1;
            if (x != Integer.MIN_VALUE && n <= n3) {
                do {
                    int i = n++;
                    BSpline.knot[i] = (double)i * grad;
                } while (n <= n3);
            }
            if (this.useDefaultInterval) {
                t1 = (double)(this.degree - 1) * grad;
                t2 = 1.0 - (double)(this.degree - 1) * grad;
            }
        } else if (this.knotVectorType == 0) {
            int i;
            int grad = this.degree;
            int n = 0;
            int n4 = grad + -1;
            if (grad != Integer.MIN_VALUE && n <= n4) {
                do {
                    int i2 = n++;
                    BSpline.knot[i2] = 0.0;
                } while (n <= n4);
            }
            int j = this.degree;
            double grad2 = 1.0 / (double)(f + 1);
            int n5 = 1;
            int n6 = f;
            if (n5 <= n6) {
                do {
                    i = n5++;
                    int n7 = j;
                    j = n7 + 1;
                    BSpline.knot[n7] = (double)i * grad2;
                } while (i != n6);
            }
            n5 = j;
            n6 = x + -1;
            if (x != Integer.MIN_VALUE && n5 <= n6) {
                do {
                    i = n5++;
                    BSpline.knot[i] = 1.0;
                } while (n5 <= n6);
            }
            if (this.useDefaultInterval) {
                t1 = 0.0;
                t2 = 1.0;
            }
        }
        if (a.length < this.degree) {
            a = new int[2 * this.degree];
            c = new int[2 * this.degree];
        }
        double[] p = new double[mp.getDimension() + 1];
        p[mp.getDimension()] = t1;
        this.eval(p);
        if (this.getConnect()) {
            mp.lineTo(p);
        } else {
            mp.moveTo(p);
        }
        BinaryCurveApproximationAlgorithm.INSTANCE.genPts(this, t1, t2, mp);
    }

    @Override
    public void eval(@NotNull double[] p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        int dim = p.length - 1;
        double t = p[dim];
        GroupIterator groupIterator = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator);
        int numPts = groupIterator.getGroupSize();
        groupIterator = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator);
        groupIterator.set(0, 0);
        int n = 0;
        int n2 = numPts + -1;
        if (numPts != Integer.MIN_VALUE && n <= n2) {
            do {
                int i = n++;
                double w = this.N(t, i);
                Object object = this.getCp();
                Intrinsics.checkNotNull((Object)object);
                ControlPath controlPath = object;
                object = this.getGi();
                Intrinsics.checkNotNull((Object)object);
                Point point = controlPath.getPoint(((GroupIterator)object).next());
                Intrinsics.checkNotNull((Object)point);
                double[] loc = point.getLocation();
                int n3 = 0;
                int n4 = dim + -1;
                if (dim == Integer.MIN_VALUE || n3 > n4) continue;
                do {
                    int j = n3++;
                    double[] dArray = p;
                    int n5 = j;
                    dArray[n5] = dArray[n5] + loc[j] * w;
                } while (n3 <= n4);
            } while (n <= n2);
        }
    }

    public final double N(double t, int i) {
        double d = 0.0;
        int n = this.degree;
        int n2 = 0;
        int n3 = n + -1;
        if (n != Integer.MIN_VALUE && n2 <= n3) {
            block0: do {
                int k;
                int j = n2++;
                double t1 = knot[i + j];
                double t2 = knot[i + j + 1];
                if (!(t >= t1) || !(t <= t2) || t1 == t2) continue;
                int dm2 = this.degree - 2;
                int n4 = this.degree - j - 1;
                if (0 <= n4) {
                    do {
                        k = n4;
                        BSpline.a[k] = 0;
                    } while (0 <= (n4 += -1));
                }
                if (j > 0) {
                    n4 = 0;
                    k = j + -1;
                    if (j != Integer.MIN_VALUE && n4 <= k) {
                        do {
                            int k2;
                            BSpline.c[k2] = k2 = n4++;
                        } while (n4 <= k);
                    }
                    BSpline.c[j] = Integer.MAX_VALUE;
                } else {
                    BSpline.c[0] = dm2;
                    BSpline.c[1] = this.degree;
                }
                int z = 0;
                while (true) {
                    if (c[z] < c[z + 1] - 1) {
                        int n5;
                        int n6;
                        double e = 1.0;
                        int bc = 0;
                        int y = dm2 - j;
                        int p = j - 1;
                        int m = dm2;
                        int n7 = this.degree;
                        while (m >= 0) {
                            int w;
                            if (p >= 0 && c[p] == m) {
                                w = i + bc;
                                double kd = knot[w + n7];
                                e *= (kd - t) / (kd - knot[w + 1]);
                                n6 = bc;
                                bc = n6 + 1;
                                n6 = p;
                                p = n6 + -1;
                            } else {
                                w = i + a[y];
                                double kw = knot[w];
                                e *= (t - kw) / (knot[w + n7 - 1] - kw);
                                n6 = y;
                                y = n6 + -1;
                            }
                            w = m;
                            m = w + -1;
                            w = n7;
                            n7 = w + -1;
                        }
                        if (j > 0) {
                            int n8;
                            int g = 0;
                            boolean reset = false;
                            while (true) {
                                int[] nArray = a;
                                n6 = g;
                                int n9 = nArray[n6];
                                nArray[n6] = n9 + 1;
                                if (a[g] <= j) break;
                                n5 = g;
                                g = n5 + 1;
                                reset = true;
                            }
                            if (reset && 0 <= (n8 = g - 1)) {
                                do {
                                    int h = n8;
                                    BSpline.a[h] = a[g];
                                } while (0 <= (n8 += -1));
                            }
                        }
                        d += e;
                        int[] nArray = c;
                        int n10 = z;
                        n5 = nArray[n10];
                        nArray[n10] = n5 + 1;
                        if (c[z] > dm2) break block0;
                        int n11 = 0;
                        n10 = z + -1;
                        if (z != Integer.MIN_VALUE && n11 <= n10) {
                            do {
                                int k3;
                                BSpline.c[k3] = k3 = n11++;
                            } while (n11 <= n10);
                        }
                        z = 0;
                        continue;
                    }
                    int n12 = z;
                    z = n12 + 1;
                }
            } while (n2 <= n3);
        }
        return d;
    }

    @Override
    public void resetMemory() {
        if (a.length > 0) {
            a = new int[0];
            c = new int[0];
        }
        if (knot.length > 0) {
            knot = new double[0];
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0002\b\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/kamaeleo/geom/curve/BSpline$Companion;", "", "NON_UNIFORM", "", "UNIFORM_CLAMPED", "UNIFORM_UNCLAMPED", "a", "", "c", "knot", "", "kamaeleo"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

