/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.graphics;

import androidx.compose.runtime.internal.StabilityInferred;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.font.CPFontMetrics;
import org.kamaeleo.geom.Rectangle2D;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/kamaeleo/graphics/SwingFontMetrics;", "Lorg/kamaeleo/font/CPFontMetrics;", "g2", "Ljava/awt/Graphics2D;", "fontMetrics", "Ljava/awt/FontMetrics;", "getAscent", "", "getHeight", "", "getStringBounds", "Lorg/kamaeleo/geom/Rectangle2D;", "text", "", "kamaeleo"})
@StabilityInferred(parameters=0)
public final class SwingFontMetrics
implements CPFontMetrics {
    @NotNull
    private final Graphics2D g2;
    @NotNull
    private final FontMetrics fontMetrics;
    public static final int $stable = 8;

    public SwingFontMetrics(@NotNull Graphics2D g2) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        this.g2 = g2;
        FontMetrics fontMetrics = this.g2.getFontMetrics();
        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"g2.fontMetrics");
        this.fontMetrics = fontMetrics;
    }

    @Override
    public float getHeight() {
        return this.fontMetrics.getHeight();
    }

    @Override
    public int getAscent() {
        return this.fontMetrics.getAscent();
    }

    @NotNull
    public final org.kamaeleo.geom.Rectangle2D getStringBounds(@Nullable String text) {
        Rectangle2D stringBounds = this.fontMetrics.getStringBounds(text, this.g2);
        return new Rectangle2D.Double(stringBounds.getX(), stringBounds.getY(), stringBounds.getWidth(), stringBounds.getHeight());
    }
}

