/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.palette;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.collection.SortedSet;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.SimpleProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.color.CPColor;
import org.kamaeleo.palette.FixedPalette;
import org.kamaeleo.palette.Palette;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0002\u001f B\n\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003B\u0016\b\u0016\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006B\u000e\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0007J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\rH\u0002J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018J \u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\rH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/kamaeleo/palette/InterpolatedPalette;", "Lorg/kamaeleo/palette/FixedPalette;", "palette", "Lorg/kamaeleo/palette/Palette;", "entries", "", "Lorg/kamaeleo/palette/InterpolatedPalette$Entry;", "Lcom/macrofocus/common/collection/SortedSet;", "getEntries", "()Lcom/macrofocus/common/collection/SortedSet;", "setEntries", "(Lcom/macrofocus/common/collection/SortedSet;)V", "highestFraction", "", "getHighestFraction", "()D", "lowestFraction", "getLowestFraction", "mode", "Lcom/macrofocus/common/properties/MutableProperty;", "Lorg/kamaeleo/palette/InterpolatedPalette$Mode;", "computeColor", "Lorg/kamaeleo/color/CPColor;", "fraction", "", "interpolate", "c1", "c2", "p", "updateFixedColorGradient", "", "Entry", "Mode", "kamaeleo"})
@StabilityInferred(parameters=0)
public final class InterpolatedPalette
extends FixedPalette {
    @NotNull
    private SortedSet<Entry> entries;
    @NotNull
    private final MutableProperty<Mode> mode;
    public static final int $stable = 8;

    public InterpolatedPalette(@NotNull SortedSet<Entry> entries) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        super(false, CollectionsKt.emptyList());
        this.entries = entries;
        this.mode = (MutableProperty)new SimpleProperty((Object)Mode.Ramps);
        this.updateFixedColorGradient();
    }

    @NotNull
    public final SortedSet<Entry> getEntries() {
        return this.entries;
    }

    public final void setEntries(@NotNull SortedSet<Entry> sortedSet) {
        Intrinsics.checkNotNullParameter(sortedSet, (String)"<set-?>");
        this.entries = sortedSet;
    }

    public InterpolatedPalette(@NotNull Palette palette) {
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        int n = 0;
        this((SortedSet<Entry>)new SortedSet(new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Entry it = (Entry)a;
                boolean bl2 = false;
                Comparable comparable = Double.valueOf(it.getFraction());
                it = (Entry)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Comparable comparable3 = Double.valueOf(it.getFraction());
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        }, null, 2, null));
        n = palette.getColorCount();
        int n2 = 0;
        int n3 = n + -1;
        if (n != Integer.MIN_VALUE && n2 <= n3) {
            do {
                int i = n2++;
                CPColor c2 = palette.getColorAt(i);
                this.entries.add((Object)new Entry((double)i / (double)(palette.getColorCount() - 1), c2));
            } while (n2 <= n3);
        }
        this.updateFixedColorGradient();
    }

    public InterpolatedPalette(Entry ... entries) {
        Intrinsics.checkNotNullParameter((Object)entries, (String)"entries");
        boolean bl = false;
        this((SortedSet<Entry>)new SortedSet(new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Entry it = (Entry)a;
                boolean bl2 = false;
                Comparable comparable = Double.valueOf(it.getFraction());
                it = (Entry)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Comparable comparable3 = Double.valueOf(it.getFraction());
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        }, (Collection)ArraysKt.asList((Object[])entries)));
        this.updateFixedColorGradient();
    }

    private final void updateFixedColorGradient() {
        if (!this.entries.isEmpty()) {
            List colors = new ArrayList();
            int n = 0;
            do {
                int i;
                double fraction;
                CPColor color;
                if ((color = this.computeColor(fraction = 1.0 * (double)(i = n++) / (double)255)) == null) {
                    throw new IllegalStateException("Null color " + fraction + ", " + color);
                }
                colors.add(color);
            } while (n <= 255);
            this.setColors(colors);
            this.setColorCount(colors.size());
        } else {
            this.setColors(CollectionsKt.emptyList());
            this.setColorCount(0);
        }
    }

    private final CPColor computeColor(double fraction) {
        if (!this.entries.isEmpty()) {
            Entry previous = null;
            for (Entry current : this.entries) {
                if (previous != null && previous.getFraction() <= fraction && fraction <= current.getFraction()) {
                    double v = (fraction - previous.getFraction()) / (current.getFraction() - previous.getFraction());
                    return this.interpolate(previous.getColor(), current.getColor(), v);
                }
                previous = current;
            }
            if (fraction < ((Entry)CollectionsKt.first((Iterable)((Iterable)this.entries))).getFraction()) {
                return ((Entry)CollectionsKt.first((Iterable)((Iterable)this.entries))).getColor();
            }
            if (fraction > ((Entry)CollectionsKt.last((Iterable)((Iterable)this.entries))).getFraction()) {
                return ((Entry)CollectionsKt.last((Iterable)((Iterable)this.entries))).getColor();
            }
        }
        return null;
    }

    private final CPColor interpolate(CPColor c1, CPColor c2, double p) {
        CPColor cPColor;
        Mode mode = (Mode)((Object)this.mode.getValue());
        int n = WhenMappings.$EnumSwitchMapping$0[mode.ordinal()];
        switch (n) {
            case 1: {
                if (p == 0.0) {
                    return c1;
                }
                if (p == 1.0) {
                    cPColor = c2;
                    break;
                }
                byte by = c1.getRed-w2LRezQ();
                boolean bl = false;
                byte by2 = by;
                boolean bl2 = false;
                double d = (double)(by2 & 0xFF) * (1.0 - p);
                by = c2.getRed-w2LRezQ();
                bl = false;
                by2 = by;
                bl2 = false;
                int n2 = (int)(d + (double)(by2 & 0xFF) * p);
                by = c1.getGreen-w2LRezQ();
                bl = false;
                by2 = by;
                bl2 = false;
                double d2 = (double)(by2 & 0xFF) * (1.0 - p);
                by = c2.getGreen-w2LRezQ();
                bl = false;
                by2 = by;
                bl2 = false;
                int n3 = (int)(d2 + (double)(by2 & 0xFF) * p);
                by = c1.getBlue-w2LRezQ();
                bl = false;
                by2 = by;
                bl2 = false;
                double d3 = (double)(by2 & 0xFF) * (1.0 - p);
                by = c2.getBlue-w2LRezQ();
                bl = false;
                by2 = by;
                bl2 = false;
                int n4 = (int)(d3 + (double)(by2 & 0xFF) * p);
                by = c1.getAlpha-w2LRezQ();
                bl = false;
                by2 = by;
                bl2 = false;
                double d4 = (double)(by2 & 0xFF) * (1.0 - p);
                by = c2.getAlpha-w2LRezQ();
                bl = false;
                by2 = by;
                bl2 = false;
                CPColor cPColor2 = new CPColor(n2, n3, n4, (int)(d4 + (double)(by2 & 0xFF) * p));
                cPColor = cPColor2;
                break;
            }
            case 2: {
                cPColor = c1;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return cPColor;
    }

    @NotNull
    public final Set<Entry> getEntries() {
        return (Set)this.entries;
    }

    @Override
    protected double getLowestFraction() {
        return !this.entries.isEmpty() ? ((Entry)CollectionsKt.first((Iterable)((Iterable)this.entries))).getFraction() : super.getLowestFraction();
    }

    @Override
    protected double getHighestFraction() {
        return !this.entries.isEmpty() ? ((Entry)CollectionsKt.last((Iterable)((Iterable)this.entries))).getFraction() : super.getHighestFraction();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0003\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0002\b\u0002j\u0002\b\u0002j\u0002\b\u0003\u00a8\u0006\u0004"}, d2={"Lorg/kamaeleo/palette/InterpolatedPalette$Mode;", "", "Ramps", "Bands", "kamaeleo"})
    private static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode Ramps = new Mode();
        public static final /* enum */ Mode Bands = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;

        public static Mode[] values() {
            Mode[] modeArray = $VALUES;
            Mode[] modeArray2 = new Mode[modeArray.length];
            System.arraycopy(modeArray, 0, modeArray2, 0, modeArray.length);
            return modeArray2;
        }

        public static Mode valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(Mode.class, value);
        }

        static {
            Mode[] modeArray = new Mode[]{Ramps, Bands};
            $VALUES = modeArray;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\u0006\u0010\u000f\u001a\u00020\u0005J\b\u0010\u0010\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/kamaeleo/palette/InterpolatedPalette$Entry;", "", "fraction", "", "color", "Lorg/kamaeleo/color/CPColor;", "getFraction", "()D", "compareTo", "", "o", "equals", "", "other", "", "getColor", "hashCode", "kamaeleo"})
    @StabilityInferred(parameters=0)
    public static final class Entry
    implements Comparable<Entry> {
        private final double fraction;
        @NotNull
        private final CPColor color;
        public static final int $stable = 8;

        public Entry(double fraction, @NotNull CPColor color) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            this.fraction = fraction;
            this.color = color;
        }

        public final double getFraction() {
            return this.fraction;
        }

        @NotNull
        public final CPColor getColor() {
            return this.color;
        }

        @Override
        public int compareTo(@NotNull Entry o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            return Double.compare(this.fraction, o.fraction);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)Reflection.getOrCreateKotlinClass(other.getClass()))) {
                return false;
            }
            Entry cfr_ignored_0 = (Entry)other;
            return this.fraction == ((Entry)other).fraction;
        }

        public int hashCode() {
            return Double.hashCode(this.fraction);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Mode.values().length];
            nArray[Mode.Ramps.ordinal()] = 1;
            nArray[Mode.Bands.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

