/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.canvas;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.collection.CollectionFactory;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kamaeleo.canvas.CanvasListener;
import org.kamaeleo.canvas.ContextMenuListener;
import org.kamaeleo.canvas.DrawingListener;
import org.kamaeleo.canvas.Graphics2DDrawing;
import org.kamaeleo.canvas.GraphicsContextDrawing;
import org.kamaeleo.canvas.KeyListener;
import org.kamaeleo.canvas.MouseListener;
import org.kamaeleo.canvas.MouseMotionListener;
import org.kamaeleo.canvas.MouseWheelListener;
import org.kamaeleo.canvas.SwingCanvasHandler;
import org.kamaeleo.color.CPColor;
import org.kamaeleo.component.CPComponent;
import org.kamaeleo.graphics.CPGraphicsContext2D;
import org.kamaeleo.graphics.GraphicsContext2D;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001:\u0001.B\u0000J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0010H\u0016J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020 J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\"H\u0016J\u000e\u0010#\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\bJ\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020'H\u0016J\u0018\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0014J\u0006\u0010-\u001a\u00020\u0016R\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006/"}, d2={"Lorg/kamaeleo/canvas/CPCanvas;", "Lorg/kamaeleo/component/CPComponent;", "canvas", "Lorg/kamaeleo/canvas/CPCanvas$CanvasComponent;", "getCanvas", "()Lorg/kamaeleo/canvas/CPCanvas$CanvasComponent;", "graphics2DDrawings", "", "Lorg/kamaeleo/canvas/Graphics2DDrawing;", "getGraphics2DDrawings", "()Ljava/util/List;", "handler", "Lorg/kamaeleo/canvas/SwingCanvasHandler;", "getHandler", "()Lorg/kamaeleo/canvas/SwingCanvasHandler;", "listeners", "Lorg/kamaeleo/canvas/CanvasListener;", "nativeComponent", "Ljavax/swing/JComponent;", "getNativeComponent", "()Ljavax/swing/JComponent;", "addCanvasListener", "", "l", "addContextMenuListener", "Lorg/kamaeleo/canvas/ContextMenuListener;", "addKeyListener", "Lorg/kamaeleo/canvas/KeyListener;", "addLayer", "d", "Lorg/kamaeleo/canvas/GraphicsContextDrawing;", "addMouseListener", "Lorg/kamaeleo/canvas/MouseListener;", "addMouseMotionListener", "Lorg/kamaeleo/canvas/MouseMotionListener;", "addMouseWheelListener", "Lorg/kamaeleo/canvas/MouseWheelListener;", "addNativeLayer", "getHeight", "", "getWidth", "notifySizeChanged", "width", "", "height", "redraw", "CanvasComponent", "kamaeleo"})
@StabilityInferred(parameters=0)
public class CPCanvas
implements CPComponent {
    @NotNull
    private final List<Graphics2DDrawing> graphics2DDrawings = CollectionFactory.INSTANCE.copyOnWriteArrayList();
    @NotNull
    private final List<CanvasListener> listeners = new ArrayList();
    @NotNull
    private final CanvasComponent canvas = new CanvasComponent();
    @NotNull
    private final SwingCanvasHandler handler = new SwingCanvasHandler(this.canvas);
    public static final int $stable = 8;

    public CPCanvas() {
        this.addLayer(new GraphicsContextDrawing(){

            @Override
            public boolean isActive() {
                return true;
            }

            @Override
            public void draw(@NotNull GraphicsContext2D g, double width, double height) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                g.setFill(new CPColor(-128, 0, 0, -1, null));
                g.fillRect(100.0, 100.0, width - 200.0, height - 200.0);
            }

            @Override
            public void addIDrawingListener(@NotNull DrawingListener listener) {
                Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            }

            @Override
            public void removeIDrawingListener(@NotNull DrawingListener listener) {
                Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            }
        });
        this.canvas.add(new JButton("Test"));
    }

    @NotNull
    public final List<Graphics2DDrawing> getGraphics2DDrawings() {
        return this.graphics2DDrawings;
    }

    @NotNull
    public final CanvasComponent getCanvas() {
        return this.canvas;
    }

    @NotNull
    public final SwingCanvasHandler getHandler() {
        return this.handler;
    }

    public final void addLayer(@NotNull GraphicsContextDrawing d) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        this.graphics2DDrawings.add(new Graphics2DDrawing(d){
            final /* synthetic */ GraphicsContextDrawing $d;
            {
                this.$d = $d;
            }

            public void draw(@NotNull Graphics2D g, double width, double height) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                this.$d.draw(new CPGraphicsContext2D(g), width, height);
            }
        });
    }

    public final void addNativeLayer(@NotNull Graphics2DDrawing d) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        this.graphics2DDrawings.add(d);
    }

    @Override
    @NotNull
    public JComponent getNativeComponent() {
        return this.canvas;
    }

    public double getWidth() {
        return this.getNativeComponent().getWidth();
    }

    public double getHeight() {
        return this.getNativeComponent().getHeight();
    }

    public void addCanvasListener(@NotNull CanvasListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.add(l);
    }

    protected void notifySizeChanged(int width, int height) {
        for (CanvasListener listener : this.listeners) {
            listener.sizeChange(width, height);
        }
    }

    public final void redraw() {
        this.getNativeComponent().repaint();
    }

    public final void addMouseListener(@NotNull MouseListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.handler.addMouseListener(l);
    }

    public void addMouseMotionListener(@NotNull MouseMotionListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.handler.addMouseMotionListener(l);
    }

    public final void addMouseWheelListener(@NotNull MouseWheelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.handler.addMouseWheelListener(l);
    }

    public final void addKeyListener(@NotNull KeyListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.handler.addKeyListener(l);
    }

    public final void addContextMenuListener(@NotNull ContextMenuListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.handler.addContextMenuListener(l);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0000J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0006H\u0002J\u0006\u0010\n\u001a\u00020\u0006J\b\u0010\u000b\u001a\u00020\u0006H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/kamaeleo/canvas/CPCanvas$CanvasComponent;", "Ljavax/swing/JPanel;", "dirtyLayers", "", "Lorg/kamaeleo/canvas/GraphicsContextDrawing;", "paint", "", "g", "Ljava/awt/Graphics;", "schedulePrepare", "scheduleRender", "updateUI", "kamaeleo"})
    public final class CanvasComponent
    extends JPanel {
        @NotNull
        private final Set<GraphicsContextDrawing> dirtyLayers;

        public CanvasComponent() {
            Intrinsics.checkNotNullParameter((Object)CPCanvas.this, (String)"this$0");
            this.dirtyLayers = new HashSet();
            this.setOpaque(false);
            this.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(@NotNull ComponentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    CPCanvas.this.notifySizeChanged(this.getWidth(), this.getHeight());
                    this.schedulePrepare();
                }

                @Override
                public void componentMoved(@NotNull ComponentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                }

                @Override
                public void componentShown(@NotNull ComponentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                }

                @Override
                public void componentHidden(@NotNull ComponentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                }
            });
            this.addHierarchyListener(new HierarchyListener(){

                @Override
                public final void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 4L) != 0L) {
                        CPCanvas.this.notifySizeChanged(this.getWidth(), this.getHeight());
                        this.schedulePrepare();
                    }
                }
            });
            this.updateUI();
        }

        @Override
        public void updateUI() {
            this.setBackground(null);
            super.updateUI();
        }

        private final void schedulePrepare() {
            this.scheduleRender();
        }

        public final void scheduleRender() {
            this.repaint();
        }

        @Override
        public void paint(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            if (this.isPaintingForPrint()) {
                // empty if block
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.setFont(this.getFont());
            for (Graphics2DDrawing layer : CPCanvas.this.getGraphics2DDrawings()) {
                layer.draw(g2, this.getWidth(), this.getHeight());
            }
        }
    }
}

