/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.geom.AffineTransform;
import org.kamaeleo.geom.AreaOp;
import org.kamaeleo.geom.Crossings;
import org.kamaeleo.geom.Curve;
import org.kamaeleo.geom.FlatteningPathIterator;
import org.kamaeleo.geom.PathIterator;
import org.kamaeleo.geom.Point2D;
import org.kamaeleo.geom.Rectangle;
import org.kamaeleo.geom.Rectangle2D;
import org.kamaeleo.geom.Shape;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 12\u00020\u0001:\u000201B\u0002\b\u0016B\n\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0000J\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cJ&\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001cJ\u0011\u0010\u001a\u001a\u00020\f2\u0006\u0010 \u001a\u00020!H\u0096\u0002J\u0011\u0010\u001a\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u0004H\u0086\u0002J\u0010\u0010#\u001a\u00020\f2\b\u0010$\u001a\u0004\u0018\u00010\u0000J\u000e\u0010%\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0000J\b\u0010&\u001a\u00020\u0004H\u0002J\u0010\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u001cH\u0016J\u0012\u0010\u0013\u001a\u00020\u00122\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\u000e\u0010+\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0000J&\u0010,\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001cJ\u0010\u0010,\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u0004H\u0016J\b\u0010-\u001a\u00020\u0016H\u0002J\u0006\u0010.\u001a\u00020\u0016J\u000e\u0010/\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0000R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0011\u0010\u000e\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u000f\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\rR\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00062"}, d2={"Lorg/kamaeleo/geom/Area;", "Lorg/kamaeleo/geom/Shape;", "s", "bounds2D", "Lorg/kamaeleo/geom/Rectangle2D;", "getBounds2D", "()Lorg/kamaeleo/geom/Rectangle2D;", "cachedBounds", "curves", "", "Lorg/kamaeleo/geom/Curve;", "isEmpty", "", "()Z", "isPolygonal", "isRectangular", "isSingular", "pathIterator", "Lorg/kamaeleo/geom/PathIterator;", "getPathIterator", "()Lorg/kamaeleo/geom/PathIterator;", "add", "", "rhs", "clone", "", "contains", "x", "", "y", "w", "h", "p", "Lorg/kamaeleo/geom/Point2D;", "r", "equals", "other", "exclusiveOr", "getCachedBounds", "getFlattenPathIterator", "flatness", "at", "Lorg/kamaeleo/geom/AffineTransform;", "intersect", "intersects", "invalidateBounds", "reset", "subtract", "AreaIterator", "Companion", "kamaeleo"})
@StabilityInferred(parameters=0)
public final class Area
implements Shape {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private List<Curve> curves;
    @Nullable
    private Rectangle2D cachedBounds;
    public static final int $stable = 8;
    @NotNull
    private static final List<Curve> EmptyCurves = new ArrayList();

    public Area() {
        this.curves = EmptyCurves;
    }

    public Area(@NotNull Shape s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.curves = s instanceof Area ? ((Area)s).curves : Area.Companion.pathToCurves(s.getPathIterator());
    }

    public final void add(@NotNull Area rhs) {
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        AreaOp.AddOp addOp = new AreaOp.AddOp();
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        List<Curve> list2 = list;
        list = rhs.curves;
        Intrinsics.checkNotNull(list);
        this.curves = addOp.calculate(list2, list);
        this.invalidateBounds();
    }

    private final void invalidateBounds() {
        this.cachedBounds = null;
    }

    public final void subtract(@NotNull Area rhs) {
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        AreaOp.SubOp subOp = new AreaOp.SubOp();
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        List<Curve> list2 = list;
        list = rhs.curves;
        Intrinsics.checkNotNull(list);
        this.curves = subOp.calculate(list2, list);
        this.invalidateBounds();
    }

    public final void intersect(@NotNull Area rhs) {
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        AreaOp.IntOp intOp = new AreaOp.IntOp();
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        List<Curve> list2 = list;
        list = rhs.curves;
        Intrinsics.checkNotNull(list);
        this.curves = intOp.calculate(list2, list);
        this.invalidateBounds();
    }

    public final void exclusiveOr(@NotNull Area rhs) {
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        AreaOp.XorOp xorOp = new AreaOp.XorOp();
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        List<Curve> list2 = list;
        list = rhs.curves;
        Intrinsics.checkNotNull(list);
        this.curves = xorOp.calculate(list2, list);
        this.invalidateBounds();
    }

    public final void reset() {
        this.curves = new ArrayList();
        this.invalidateBounds();
    }

    public final boolean isEmpty() {
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        return list.size() == 0;
    }

    public final boolean isPolygonal() {
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        for (Curve c2 : list) {
            if (c2.getOrder() <= 1) continue;
            return false;
        }
        return true;
    }

    public final boolean isRectangular() {
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        int size = list.size();
        if (size == 0) {
            return true;
        }
        if (size > 3) {
            return false;
        }
        Object object = this.curves;
        Intrinsics.checkNotNull(object);
        Curve curve = object.get(1);
        Intrinsics.checkNotNull((Object)curve);
        Curve c1 = curve;
        List<Curve> list2 = this.curves;
        Intrinsics.checkNotNull(list2);
        object = list2.get(2);
        Intrinsics.checkNotNull((Object)object);
        Object c2 = object;
        if (c1.getOrder() != 1 || ((Curve)c2).getOrder() != 1) {
            return false;
        }
        return c1.getXTop() != c1.getXBot() || ((Curve)c2).getXTop() != ((Curve)c2).getXBot() ? false : c1.getYTop() == ((Curve)c2).getYTop() && c1.getYBot() == ((Curve)c2).getYBot();
    }

    public final boolean isSingular() {
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        if (list.size() < 3) {
            return true;
        }
        List<Curve> list2 = this.curves;
        Intrinsics.checkNotNull(list2);
        for (Curve c2 : list2) {
            Intrinsics.checkNotNull((Object)c2);
            if (c2.getOrder() != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Rectangle2D getBounds2D() {
        return this.getCachedBounds().getBounds2D();
    }

    private final Rectangle2D getCachedBounds() {
        int n;
        int n2;
        if (this.cachedBounds != null) {
            Rectangle2D rectangle2D = this.cachedBounds;
            Intrinsics.checkNotNull((Object)rectangle2D);
            return rectangle2D;
        }
        Rectangle2D r = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        Object object = this.curves;
        Intrinsics.checkNotNull(object);
        if (object.size() > 0) {
            List<Curve> list = this.curves;
            Intrinsics.checkNotNull(list);
            Curve c2 = list.get(0);
            r = new Rectangle2D.Double(c2.getX0(), c2.getY0(), 0.0, 0.0);
            List<Curve> list2 = this.curves;
            Intrinsics.checkNotNull(list2);
            n2 = list2.size();
            n = 1;
            int n3 = n2 + -1;
            if (n2 != Integer.MIN_VALUE && n <= n3) {
                do {
                    int i = n++;
                    List<Curve> list3 = this.curves;
                    Intrinsics.checkNotNull(list3);
                    r = list3.get(i).enlarge(new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight()));
                } while (n <= n3);
            }
        }
        object = new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        n2 = 0;
        n = 0;
        Object it = object;
        boolean bl = false;
        this.cachedBounds = (Rectangle2D)it;
        return (Rectangle2D)object;
    }

    @Override
    public boolean contains(@NotNull Point2D p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this.contains(p.getX(), p.getY());
    }

    public final boolean contains(double x, double y) {
        if (!this.getCachedBounds().contains(x, y)) {
            return false;
        }
        int crossings = 0;
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        for (Curve c2 : list) {
            crossings += c2.crossingsFor(x, y);
        }
        return crossings & true;
    }

    @Override
    public boolean intersects(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public final boolean intersects(double x, double y, double w, double h) {
        if (w < 0.0 || h < 0.0) {
            return false;
        }
        if (!this.getCachedBounds().intersects(x, y, w, h)) {
            return false;
        }
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        Crossings c2 = Crossings.Companion.findCrossings(list, x, y, x + w, y + h);
        return c2 == null || !c2.isEmpty();
    }

    @Override
    @NotNull
    public PathIterator getPathIterator() {
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        return new AreaIterator(list, null);
    }

    @Override
    @NotNull
    public PathIterator getPathIterator(@Nullable AffineTransform at) {
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        return new AreaIterator(list, at);
    }

    @Override
    @NotNull
    public PathIterator getFlattenPathIterator(double flatness) {
        return new FlatteningPathIterator(this.getPathIterator(), flatness);
    }

    @NotNull
    public final Object clone() {
        return new Area(this);
    }

    public final boolean equals(@Nullable Area other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        AreaOp.XorOp xorOp = new AreaOp.XorOp();
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        List<Curve> list2 = list;
        list = other.curves;
        Intrinsics.checkNotNull(list);
        List<Curve> c2 = xorOp.calculate(list2, list);
        return c2.isEmpty();
    }

    public final boolean contains(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public final boolean contains(double x, double y, double w, double h) {
        if (w < 0.0 || h < 0.0) {
            return false;
        }
        if (!this.getCachedBounds().contains(x, y, w, h)) {
            return false;
        }
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        Crossings c2 = Crossings.Companion.findCrossings(list, x, y, x + w, y + h);
        return c2 != null && c2.covers(y, y + h);
    }

    @Override
    @Nullable
    public Rectangle getBounds() {
        return Shape.DefaultImpls.getBounds(this);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0013\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0018\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0015H\u0016J\t\u0010\u0016\u001a\u00020\u0017H\u0096\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lorg/kamaeleo/geom/Area$AreaIterator;", "Lorg/kamaeleo/geom/PathIterator;", "curves", "", "Lorg/kamaeleo/geom/Curve;", "at", "Lorg/kamaeleo/geom/AffineTransform;", "index", "", "isDone", "", "()Z", "prevcurve", "thiscurve", "transform", "windingRule", "getWindingRule", "()I", "currentSegment", "coords", "", "", "next", "", "kamaeleo"})
    public static final class AreaIterator
    implements PathIterator {
        @Nullable
        private final AffineTransform transform;
        @NotNull
        private final List<Curve> curves;
        private int index;
        @Nullable
        private Curve prevcurve;
        @Nullable
        private Curve thiscurve;

        public AreaIterator(@NotNull List<Curve> curves, @Nullable AffineTransform at) {
            Intrinsics.checkNotNullParameter(curves, (String)"curves");
            this.curves = curves;
            this.transform = at;
            if (curves.size() >= 1) {
                this.thiscurve = curves.get(0);
            }
        }

        @Override
        public int getWindingRule() {
            return 1;
        }

        @Override
        public boolean isDone() {
            return this.prevcurve == null && this.thiscurve == null;
        }

        @Override
        public void next() {
            if (this.prevcurve != null) {
                this.prevcurve = null;
            } else {
                this.prevcurve = this.thiscurve;
                Object object = this;
                int n = ((AreaIterator)object).index;
                ((AreaIterator)object).index = n + 1;
                if (this.index < this.curves.size()) {
                    this.thiscurve = this.curves.get(this.index);
                    object = this.thiscurve;
                    Intrinsics.checkNotNull((Object)object);
                    if (((Curve)object).getOrder() != 0) {
                        object = this.prevcurve;
                        Intrinsics.checkNotNull((Object)object);
                        double d = ((Curve)object).getX1();
                        object = this.thiscurve;
                        Intrinsics.checkNotNull((Object)object);
                        if (d == ((Curve)object).getX0()) {
                            object = this.prevcurve;
                            Intrinsics.checkNotNull((Object)object);
                            double d2 = ((Curve)object).getY1();
                            object = this.thiscurve;
                            Intrinsics.checkNotNull((Object)object);
                            if (d2 == ((Curve)object).getY0()) {
                                this.prevcurve = null;
                            }
                        }
                    }
                } else {
                    this.thiscurve = null;
                }
            }
        }

        @Override
        public int currentSegment(@NotNull float[] coords) {
            int n;
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            double[] dcoords = new double[6];
            int segtype = this.currentSegment(dcoords);
            switch (segtype) {
                case 4: {
                    n = 0;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                case 3: {
                    n = 3;
                    break;
                }
                default: {
                    n = 1;
                }
            }
            int numpoints = n;
            int n2 = numpoints * 2;
            int n3 = 0;
            int n4 = n2 + -1;
            if (n2 != Integer.MIN_VALUE && n3 <= n4) {
                do {
                    int i = n3++;
                    coords[i] = (float)dcoords[i];
                } while (n3 <= n4);
            }
            return segtype;
        }

        @Override
        public int currentSegment(@NotNull double[] coords) {
            int numpoints;
            int segtype;
            block9: {
                block6: {
                    Curve curve;
                    block8: {
                        block7: {
                            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
                            segtype = 0;
                            numpoints = 0;
                            if (this.prevcurve == null) break block6;
                            if (this.thiscurve == null) break block7;
                            curve = this.thiscurve;
                            Intrinsics.checkNotNull((Object)curve);
                            if (curve.getOrder() != 0) break block8;
                        }
                        return 4;
                    }
                    curve = this.thiscurve;
                    Intrinsics.checkNotNull((Object)curve);
                    coords[0] = curve.getX0();
                    curve = this.thiscurve;
                    Intrinsics.checkNotNull((Object)curve);
                    coords[1] = curve.getY0();
                    segtype = 1;
                    numpoints = 1;
                    break block9;
                }
                if (this.thiscurve == null) {
                    throw new NoSuchElementException("area iterator out of bounds");
                }
                Curve curve = this.thiscurve;
                Intrinsics.checkNotNull((Object)curve);
                segtype = curve.getSegment(coords);
                curve = this.thiscurve;
                Intrinsics.checkNotNull((Object)curve);
                numpoints = curve.getOrder();
                if (numpoints == 0) {
                    numpoints = 1;
                }
            }
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, numpoints);
            }
            return segtype;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0002\b\u0002J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/kamaeleo/geom/Area$Companion;", "", "EmptyCurves", "", "Lorg/kamaeleo/geom/Curve;", "pathToCurves", "pi", "Lorg/kamaeleo/geom/PathIterator;", "kamaeleo"})
    public static final class Companion {
        private Companion() {
        }

        private final List<Curve> pathToCurves(PathIterator pi) {
            ArrayList curves = new ArrayList();
            int windingRule = pi.getWindingRule();
            double[] coords = new double[23];
            double movx = 0.0;
            double movy = 0.0;
            double curx = 0.0;
            double cury = 0.0;
            while (!pi.isDone()) {
                double newy = 0.0;
                double newx = 0.0;
                int n = pi.currentSegment(coords);
                switch (n) {
                    case 0: {
                        Curve.Companion.insertLine(curves, curx, cury, movx, movy);
                        Companion companion = this;
                        boolean bl = false;
                        boolean bl2 = false;
                        Companion $this$pathToCurves_u24lambda_u2d0 = companion;
                        boolean bl3 = false;
                        curx = movx = coords[0];
                        companion = this;
                        bl = false;
                        bl2 = false;
                        Companion $this$pathToCurves_u24lambda_u2d1 = companion;
                        boolean bl4 = false;
                        cury = movy = coords[1];
                        Curve.Companion.insertMove(curves, movx, movy);
                        break;
                    }
                    case 1: {
                        newx = coords[0];
                        newy = coords[1];
                        Curve.Companion.insertLine(curves, curx, cury, newx, newy);
                        curx = newx;
                        cury = newy;
                        break;
                    }
                    case 2: {
                        newx = coords[2];
                        newy = coords[3];
                        Curve.Companion.insertQuad(curves, curx, cury, coords);
                        curx = newx;
                        cury = newy;
                        break;
                    }
                    case 3: {
                        newx = coords[4];
                        newy = coords[5];
                        Curve.Companion.insertCubic(curves, curx, cury, coords);
                        curx = newx;
                        cury = newy;
                        break;
                    }
                    case 4: {
                        Curve.Companion.insertLine(curves, curx, cury, movx, movy);
                        curx = movx;
                        cury = movy;
                    }
                }
                pi.next();
            }
            Curve.Companion.insertLine(curves, curx, cury, movx, movy);
            AreaOp operator = null;
            operator = windingRule == 0 ? (AreaOp)new AreaOp.EOWindOp() : (AreaOp)new AreaOp.NZWindOp();
            return operator.calculate(curves, EmptyCurves);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

