/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.geom;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.geom.Curve;
import org.kamaeleo.geom.Order2;
import org.kamaeleo.geom.QuadCurve2D;
import org.kamaeleo.geom.Rectangle2D;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b4\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\u000e\b\u0000\u0018\u0000 W2\u00020\u0001:\u0001WBH\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u0003H\u0016J\u0010\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u0003H\u0016J\u0010\u0010>\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u0003H\u0016J\u0010\u0010?\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u0003H\u0016J\b\u0010@\u001a\u00020AH\u0016J\u0018\u0010B\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u00032\u0006\u0010C\u001a\u00020\fH\u0016J\u0018\u0010D\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u00032\u0006\u0010C\u001a\u00020\fH\u0016J\u0010\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020FH\u0016J\u0010\u0010H\u001a\u00020\f2\u0006\u0010I\u001a\u00020JH\u0016J \u0010K\u001a\u00020\u00012\u0006\u0010L\u001a\u00020\u00032\u0006\u0010M\u001a\u00020\u00032\u0006\u0010N\u001a\u00020\fH\u0016J\u0018\u0010O\u001a\u00020\u00032\u0006\u0010P\u001a\u00020\u00032\u0006\u0010Q\u001a\u00020\u0003H\u0016J.\u0010R\u001a\u00020\u00032\u0006\u0010S\u001a\u00020\u00032\u0006\u0010T\u001a\u00020\u00032\u0006\u0010U\u001a\u00020\u00032\u0006\u0010V\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u0003R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0018\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015R\u0011\u0010\u001a\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0015R\u0014\u0010\t\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0015R\u0014\u0010$\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0015R\u0014\u0010&\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0015R\u0014\u0010(\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0015R\u0014\u0010*\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0015R\u000e\u0010,\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0015R\u0014\u0010\n\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0015R\u0014\u00102\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u0015R\u0014\u00104\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u0015R\u000e\u00106\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Lorg/kamaeleo/geom/Order3;", "Lorg/kamaeleo/geom/Curve;", "x0", "", "y0", "cx0", "cy0", "cx1", "cy1", "x1", "y1", "direction", "", "TforY1", "TforY2", "TforY3", "YforT1", "YforT2", "YforT3", "cX0", "getCX0", "()D", "cX1", "getCX1", "cY0", "getCY0", "cY1", "getCY1", "order", "getOrder", "()I", "reversedCurve", "getReversedCurve", "()Lorg/kamaeleo/geom/Curve;", "getX0", "getX1", "xBot", "getXBot", "xMax", "getXMax", "xMin", "getXMin", "xTop", "getXTop", "xcoeff0", "xcoeff1", "xcoeff2", "xcoeff3", "getY0", "getY1", "yBot", "getYBot", "yTop", "getYTop", "ycoeff0", "ycoeff1", "ycoeff2", "ycoeff3", "TforY", "y", "XforT", "t", "XforY", "YforT", "controlPointString", "", "dXforT", "deriv", "dYforT", "enlarge", "Lorg/kamaeleo/geom/Rectangle2D;", "r", "getSegment", "coords", "", "getSubCurve", "ystart", "yend", "dir", "nextVertical", "t0", "t1", "refine", "a", "b", "c", "target", "Companion", "kamaeleo"})
public final class Order3
extends Curve {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double xTop;
    private final double yTop;
    private final double cx0;
    private final double cy0;
    private final double cx1;
    private final double cy1;
    private final double xBot;
    private final double yBot;
    private final double xMin;
    private final double xMax;
    private final double xcoeff0;
    private final double xcoeff1;
    private final double xcoeff2;
    private final double xcoeff3;
    private final double ycoeff0;
    private final double ycoeff1;
    private final double ycoeff2;
    private final double ycoeff3;
    private double TforY1;
    private double YforT1;
    private double TforY2;
    private double YforT2;
    private double TforY3;
    private double YforT3;

    public Order3(double x0, double y0, double cx0, double cy0, double cx1, double cy1, double x1, double y1, int direction) {
        super(direction);
        double cy02 = cy0;
        double cy12 = cy1;
        if (cy02 < y0) {
            cy02 = y0;
        }
        if (cy12 > y1) {
            cy12 = y1;
        }
        this.xTop = x0;
        this.yTop = y0;
        this.cx0 = cx0;
        this.cy0 = cy02;
        this.cx1 = cx1;
        this.cy1 = cy12;
        this.xBot = x1;
        this.yBot = y1;
        boolean bl = false;
        double d = Math.min(x0, x1);
        boolean bl2 = false;
        double d2 = Math.min(cx0, cx1);
        boolean bl3 = false;
        this.xMin = Math.min(d, d2);
        boolean bl4 = false;
        double d3 = Math.max(x0, x1);
        boolean bl5 = false;
        double d4 = Math.max(cx0, cx1);
        bl3 = false;
        this.xMax = Math.max(d3, d4);
        this.xcoeff0 = x0;
        this.xcoeff1 = (cx0 - x0) * 3.0;
        this.xcoeff2 = (cx1 - cx0 - cx0 + x0) * 3.0;
        this.xcoeff3 = x1 - (cx1 - cx0) * 3.0 - x0;
        this.ycoeff0 = y0;
        this.ycoeff1 = (cy02 - y0) * 3.0;
        this.ycoeff2 = (cy12 - cy02 - cy02 + y0) * 3.0;
        this.ycoeff3 = y1 - (cy12 - cy02) * 3.0 - y0;
        this.YforT1 = this.YforT2 = (this.YforT3 = y0);
    }

    @Override
    public double getXTop() {
        return this.xTop;
    }

    @Override
    public double getYTop() {
        return this.yTop;
    }

    @Override
    public double getXBot() {
        return this.xBot;
    }

    @Override
    public double getYBot() {
        return this.yBot;
    }

    @Override
    public double getXMin() {
        return this.xMin;
    }

    @Override
    public double getXMax() {
        return this.xMax;
    }

    @Override
    @Nullable
    public Curve getReversedCurve() {
        return new Order3(this.getXTop(), this.getYTop(), this.cx0, this.cy0, this.cx1, this.cy1, this.getXBot(), this.getYBot(), -this.getDirection());
    }

    @Override
    @NotNull
    public String controlPointString() {
        return "" + '(' + Curve.Companion.round(this.getCX0()) + ", " + Curve.Companion.round(this.getCY0()) + "), (" + Curve.Companion.round(this.getCX1()) + ", " + Curve.Companion.round(this.getCY1()) + "), ";
    }

    @Override
    public int getOrder() {
        return 3;
    }

    @Override
    public double getX0() {
        return this.getDirection() == 1 ? this.getXTop() : this.getXBot();
    }

    @Override
    public double getY0() {
        return this.getDirection() == 1 ? this.getYTop() : this.getYBot();
    }

    @Override
    public double getX1() {
        return this.getDirection() == 1 ? this.getYTop() : this.getYBot();
    }

    @Override
    public double getY1() {
        return this.getDirection() == -1 ? this.getYTop() : this.getYBot();
    }

    @Override
    public double YforT(double t) {
        return ((this.ycoeff3 * t + this.ycoeff2) * t + this.ycoeff1) * t + this.ycoeff0;
    }

    @Override
    public double dXforT(double t, int deriv) {
        double d;
        int n = deriv;
        switch (n) {
            case 0: {
                d = ((this.xcoeff3 * t + this.xcoeff2) * t + this.xcoeff1) * t + this.xcoeff0;
                break;
            }
            case 1: {
                d = ((double)3 * this.xcoeff3 * t + (double)2 * this.xcoeff2) * t + this.xcoeff1;
                break;
            }
            case 2: {
                d = (double)6 * this.xcoeff3 * t + (double)2 * this.xcoeff2;
                break;
            }
            case 3: {
                d = (double)6 * this.xcoeff3;
                break;
            }
            default: {
                d = 0.0;
            }
        }
        return d;
    }

    @Override
    public double dYforT(double t, int deriv) {
        double d;
        int n = deriv;
        switch (n) {
            case 0: {
                d = ((this.ycoeff3 * t + this.ycoeff2) * t + this.ycoeff1) * t + this.ycoeff0;
                break;
            }
            case 1: {
                d = ((double)3 * this.ycoeff3 * t + (double)2 * this.ycoeff2) * t + this.ycoeff1;
                break;
            }
            case 2: {
                d = (double)6 * this.ycoeff3 * t + (double)2 * this.ycoeff2;
                break;
            }
            case 3: {
                d = (double)6 * this.ycoeff3;
                break;
            }
            default: {
                d = 0.0;
            }
        }
        return d;
    }

    @Override
    public double XforY(double y) {
        if (y <= this.getYTop()) {
            return this.getXTop();
        }
        return y >= this.getYBot() ? this.getXBot() : this.XforT(this.TforY(y));
    }

    @Override
    public double TforY(double y) {
        if (y <= this.getYTop()) {
            return 0.0;
        }
        if (y >= this.getYBot()) {
            return 1.0;
        }
        if (y == this.YforT1) {
            return this.TforY1;
        }
        if (y == this.YforT2) {
            return this.TforY2;
        }
        if (y == this.YforT3) {
            return this.TforY3;
        }
        if (this.ycoeff3 == 0.0) {
            return Order2.Companion.TforY(y, this.ycoeff0, this.ycoeff1, this.ycoeff2);
        }
        double a = this.ycoeff2 / this.ycoeff3;
        double b = this.ycoeff1 / this.ycoeff3;
        double c2 = (this.ycoeff0 - y) / this.ycoeff3;
        boolean roots = false;
        double Q = (a * a - 3.0 * b) / 9.0;
        double R = (2.0 * a * a * a - 9.0 * a * b + 27.0 * c2) / 54.0;
        double R2 = R * R;
        double Q3 = Q * Q * Q;
        double a_3 = a / 3.0;
        double t = 0.0;
        if (R2 < Q3) {
            boolean bl = false;
            double d = R / Math.sqrt(Q3);
            boolean bl2 = false;
            double theta = Math.acos(d);
            boolean bl3 = false;
            Q = -2.0 * Math.sqrt(Q);
            double d2 = theta / 3.0;
            bl2 = false;
            t = this.refine(a, b, c2, y, Q * Math.cos(d2) - a_3);
            if (t < 0.0) {
                d2 = (theta + Math.PI * 2) / 3.0;
                bl2 = false;
                t = this.refine(a, b, c2, y, Q * Math.cos(d2) - a_3);
            }
            if (t < 0.0) {
                d2 = (theta - Math.PI * 2) / 3.0;
                bl2 = false;
                t = this.refine(a, b, c2, y, Q * Math.cos(d2) - a_3);
            }
        } else {
            boolean neg;
            boolean bl = neg = R < 0.0;
            if (neg) {
                R = -R;
            }
            double d = R2 - Q3;
            boolean bl4 = false;
            double S = Math.sqrt(d);
            double d3 = R + S;
            double d4 = 0.3333333333333333;
            boolean bl5 = false;
            double A = Math.pow(d3, d4);
            if (!neg) {
                A = -A;
            }
            double B = A == 0.0 ? 0.0 : Q / A;
            t = this.refine(a, b, c2, y, A + B - a_3);
        }
        if (t < 0.0) {
            double t0 = 0.0;
            double t1 = 1.0;
            while (!((t = (t0 + t1) / (double)2) == t0) && !(t == t1)) {
                double yt = this.YforT(t);
                if (yt < y) {
                    t0 = t;
                    continue;
                }
                if (!(yt > y)) break;
                t1 = t;
            }
        }
        if (t >= 0.0) {
            this.TforY3 = this.TforY2;
            this.YforT3 = this.YforT2;
            this.TforY2 = this.TforY1;
            this.YforT2 = this.YforT1;
            this.TforY1 = t;
            this.YforT1 = y;
        }
        return t;
    }

    public final double refine(double a, double b, double c2, double target, double t) {
        double t2 = t;
        if (t2 < -0.1 || t2 > 1.1) {
            return -1.0;
        }
        double y = this.YforT(t2);
        double t0 = 0.0;
        double t1 = 0.0;
        if (y < target) {
            t0 = t2;
            t1 = 1.0;
        } else {
            t0 = 0.0;
            t1 = t2;
        }
        double origt = t2;
        double origy = y;
        boolean useslope = true;
        while (!(y == target)) {
            if (!useslope) {
                double t22 = (t0 + t1) / (double)2;
                if (t22 == t0 || t22 == t1) break;
                t2 = t22;
            } else {
                double slope = this.dYforT(t2, 1);
                if (slope == 0.0) {
                    useslope = false;
                    continue;
                }
                double t23 = t2 + (target - y) / slope;
                if (t23 == t2 || t23 <= t0 || t23 >= t1) {
                    useslope = false;
                    continue;
                }
                t2 = t23;
            }
            y = this.YforT(t2);
            if (y < target) {
                t0 = t2;
                continue;
            }
            if (!(y > target)) break;
            t1 = t2;
        }
        return t2 > 1.0 ? -1.0 : t2;
    }

    @Override
    public double XforT(double t) {
        return ((this.xcoeff3 * t + this.xcoeff2) * t + this.xcoeff1) * t + this.xcoeff0;
    }

    @Override
    public double nextVertical(double t0, double t1) {
        double t12 = t1;
        double[] dArray = new double[]{this.xcoeff1, (double)2 * this.xcoeff2, (double)3 * this.xcoeff3};
        double[] eqn = dArray;
        int numroots = QuadCurve2D.Companion.solveQuadratic(eqn, eqn);
        int n = 0;
        int n2 = numroots + -1;
        if (numroots != Integer.MIN_VALUE && n <= n2) {
            do {
                int i;
                if (!(eqn[i = n++] > t0) || !(eqn[i] < t12)) continue;
                t12 = eqn[i];
            } while (n <= n2);
        }
        return t12;
    }

    @Override
    @NotNull
    public Curve getSubCurve(double ystart, double yend, int dir) {
        int n;
        if (ystart <= this.getYTop() && yend >= this.getYBot()) {
            return this.getWithDirection(dir);
        }
        double t0 = this.TforY(ystart);
        double t1 = this.TforY(yend);
        double[] eqn = new double[14];
        eqn[0] = this.getXTop();
        eqn[1] = this.getYTop();
        eqn[2] = this.cx0;
        eqn[3] = this.cy0;
        eqn[4] = this.cx1;
        eqn[5] = this.cy1;
        eqn[6] = this.getXBot();
        eqn[7] = this.getYBot();
        if (t0 > t1) {
            double t = t0;
            t0 = t1;
            t1 = t;
        }
        if (t1 < 1.0) {
            Companion.split(eqn, 0, t1);
        }
        int i = 0;
        if (t0 <= 0.0) {
            n = 0;
        } else {
            Companion.split(eqn, 0, t0 / t1);
            n = 6;
        }
        i = n;
        return new Order3(eqn[i + 0], ystart, eqn[i + 2], eqn[i + 3], eqn[i + 4], eqn[i + 5], eqn[i + 6], yend, dir);
    }

    @Override
    public int getSegment(@NotNull double[] coords) {
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        if (this.getDirection() == 1) {
            coords[0] = this.cx0;
            coords[1] = this.cy0;
            coords[2] = this.cx1;
            coords[3] = this.cy1;
            coords[4] = this.getXBot();
            coords[5] = this.getYBot();
        } else {
            coords[0] = this.cx1;
            coords[1] = this.cy1;
            coords[2] = this.cx0;
            coords[3] = this.cy0;
            coords[4] = this.getXTop();
            coords[5] = this.getYTop();
        }
        return 3;
    }

    @Override
    @NotNull
    public Rectangle2D enlarge(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Rectangle2D r2 = r;
        r2 = r2.add(this.getXTop(), this.getYTop());
        double[] dArray = new double[]{this.xcoeff1, (double)2 * this.xcoeff2, (double)3 * this.xcoeff3};
        double[] eqn = dArray;
        int numroots = QuadCurve2D.Companion.solveQuadratic(eqn, eqn);
        int n = 0;
        int n2 = numroots + -1;
        if (numroots != Integer.MIN_VALUE && n <= n2) {
            do {
                int i;
                double t;
                if (!((t = eqn[i = n++]) > 0.0) || !(t < 1.0)) continue;
                r2 = r2.add(this.XforT(t), this.YforT(t));
            } while (n <= n2);
        }
        return r2.add(this.getXBot(), this.getYBot());
    }

    public final double getCX0() {
        return this.getDirection() == 1 ? this.cx0 : this.cx1;
    }

    public final double getCY0() {
        return this.getDirection() == 1 ? this.cy0 : this.cy1;
    }

    public final double getCX1() {
        return this.getDirection() == -1 ? this.cx0 : this.cx1;
    }

    public final double getCY1() {
        return this.getDirection() == -1 ? this.cy0 : this.cy1;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0013\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0002\b\u0002J\\\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011J.\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018Jd\u0010\u0019\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\b\u00a8\u0006\u001f"}, d2={"Lorg/kamaeleo/geom/Order3$Companion;", "", "addInstance", "", "curves", "", "Lorg/kamaeleo/geom/Curve;", "x0", "", "y0", "cx0", "cy0", "cx1", "cy1", "x1", "y1", "direction", "", "getHorizontalParams", "c0", "cp0", "cp1", "c1", "ret", "", "insert", "tmp", "split", "coords", "pos", "t", "kamaeleo"})
    public static final class Companion {
        private Companion() {
        }

        public final void insert(@NotNull List<Curve> curves, @NotNull double[] tmp, double x0, double y0, double cx0, double cy0, double cx1, double cy1, double x1, double y1, int direction) {
            Intrinsics.checkNotNullParameter(curves, (String)"curves");
            Intrinsics.checkNotNullParameter((Object)tmp, (String)"tmp");
            int numparams = this.getHorizontalParams(y0, cy0, cy1, y1, tmp);
            if (numparams == 0) {
                this.addInstance(curves, x0, y0, cx0, cy0, cx1, cy1, x1, y1, direction);
                return;
            }
            tmp[3] = x0;
            tmp[4] = y0;
            tmp[5] = cx0;
            tmp[6] = cy0;
            tmp[7] = cx1;
            tmp[8] = cy1;
            tmp[9] = x1;
            tmp[10] = y1;
            double t = tmp[0];
            if (numparams > 1 && t > tmp[1]) {
                tmp[0] = tmp[1];
                tmp[1] = t;
                t = tmp[0];
            }
            this.split(tmp, 3, t);
            if (numparams > 1) {
                t = (tmp[1] - t) / (1.0 - t);
                this.split(tmp, 9, t);
            }
            int index = 3;
            if (direction == -1) {
                index += numparams * 6;
            }
            while (numparams >= 0) {
                this.addInstance(curves, tmp[index + 0], tmp[index + 1], tmp[index + 2], tmp[index + 3], tmp[index + 4], tmp[index + 5], tmp[index + 6], tmp[index + 7], direction);
                int n = numparams;
                numparams = n + -1;
                if (direction == 1) {
                    index += 6;
                    continue;
                }
                index -= 6;
            }
        }

        public final void addInstance(@NotNull List<Curve> curves, double x0, double y0, double cx0, double cy0, double cx1, double cy1, double x1, double y1, int direction) {
            Intrinsics.checkNotNullParameter(curves, (String)"curves");
            if (y0 > y1) {
                curves.add(new Order3(x1, y1, cx1, cy1, cx0, cy0, x0, y0, -direction));
            } else if (y1 > y0) {
                curves.add(new Order3(x0, y0, cx0, cy0, cx1, cy1, x1, y1, direction));
            }
        }

        public final int getHorizontalParams(double c0, double cp0, double cp1, double c1, @NotNull double[] ret) {
            Intrinsics.checkNotNullParameter((Object)ret, (String)"ret");
            double cp02 = cp0;
            double cp12 = cp1;
            double c12 = c1;
            if (c0 <= cp02 && cp02 <= cp12 && cp12 <= c12) {
                return 0;
            }
            c12 -= cp12;
            cp12 -= cp02;
            ret[0] = cp02 -= c0;
            ret[1] = (cp12 - cp02) * (double)2;
            ret[2] = c12 - cp12 - cp12 + cp02;
            int numroots = QuadCurve2D.Companion.solveQuadratic(ret, ret);
            int j = 0;
            int n = 0;
            int n2 = numroots + -1;
            if (numroots != Integer.MIN_VALUE && n <= n2) {
                do {
                    int i;
                    double t;
                    if (!((t = ret[i = n++]) > 0.0) || !(t < 1.0)) continue;
                    if (j < i) {
                        ret[j] = t;
                    }
                    int n3 = j;
                    j = n3 + 1;
                } while (n <= n2);
            }
            return j;
        }

        public final void split(@NotNull double[] coords, int pos, double t) {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            double x1 = 0.0;
            coords[pos + 12] = x1 = coords[pos + 6];
            double y1 = 0.0;
            coords[pos + 13] = y1 = coords[pos + 7];
            double cx1 = coords[pos + 4];
            double cy1 = coords[pos + 5];
            x1 = cx1 + (x1 - cx1) * t;
            y1 = cy1 + (y1 - cy1) * t;
            double x0 = coords[pos + 0];
            double y0 = coords[pos + 1];
            double cx0 = coords[pos + 2];
            double cy0 = coords[pos + 3];
            x0 += (cx0 - x0) * t;
            y0 += (cy0 - y0) * t;
            cx0 += (cx1 - cx0) * t;
            cy0 += (cy1 - cy0) * t;
            cx1 = cx0 + (x1 - cx0) * t;
            cy1 = cy0 + (y1 - cy0) * t;
            cx0 = x0 + (cx0 - x0) * t;
            cy0 = y0 + (cy0 - y0) * t;
            coords[pos + 2] = x0;
            coords[pos + 3] = y0;
            coords[pos + 4] = cx0;
            coords[pos + 5] = cy0;
            coords[pos + 6] = cx0 + (cx1 - cx0) * t;
            coords[pos + 7] = cy0 + (cy1 - cy0) * t;
            coords[pos + 8] = cx1;
            coords[pos + 9] = cy1;
            coords[pos + 10] = x1;
            coords[pos + 11] = y1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

