/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.graphics;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.math.MathKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.font.CPFont;
import org.kamaeleo.font.CPFontMetrics;
import org.kamaeleo.geom.Ellipse2D;
import org.kamaeleo.geom.Point2D;
import org.kamaeleo.geom.Rectangle;
import org.kamaeleo.geom.Rectangle2D;
import org.kamaeleo.geom.Shape;
import org.kamaeleo.graphics.ICallback;
import org.kamaeleo.graphics.IGraphics;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000 H2\u00020\u0001:\u0001HB\u0000J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H$J:\u0010\u0013\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0017H\u0016J\u0012\u0010\u001c\u001a\u00020\u000f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J(\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020!H\u0016J\u0010\u0010%\u001a\u00020\u000f2\b\u0010&\u001a\u0004\u0018\u00010\u0012J\"\u0010'\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010 \u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0017H\u0016J\b\u0010(\u001a\u00020\u000fH\u0016J\u0012\u0010)\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H$J\u0010\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,H\u0016J(\u0010-\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020!H\u0016J\u0012\u0010.\u001a\u00020\u000f2\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J\u0010\u0010/\u001a\u00020\u000f2\b\u0010&\u001a\u0004\u0018\u00010\u0012J\b\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u000201H\u0016J\n\u00103\u001a\u0004\u0018\u000104H\u0016J\u0012\u00105\u001a\u00020,2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0012\u00106\u001a\u00020\u00172\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0012\u00107\u001a\u00020\u00172\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u00108\u001a\u000209H\u0016J;\u0010:\u001a\u00020\u000f\"\u0004\b\u0000\u0010;2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\t\u001a\u0002H;2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H;0\u0003H\u0002\u00a2\u0006\u0002\u0010<J9\u0010=\u001a\u00020\u000f\"\u0004\b\u0000\u0010;2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\t\u001a\u0002H;2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H;0\u0003\u00a2\u0006\u0002\u0010<J9\u0010>\u001a\u00020\u000f\"\u0004\b\u0000\u0010;2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\t\u001a\u0002H;2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H;0\u0003\u00a2\u0006\u0002\u0010<J\u0012\u0010?\u001a\u00020\u000f2\b\u0010@\u001a\u0004\u0018\u00010AH\u0016J\u0012\u0010B\u001a\u00020\u000f2\b\u0010C\u001a\u0004\u0018\u00010DH\u0016J\u0012\u0010E\u001a\u00020\u000f2\b\u0010F\u001a\u0004\u0018\u00010GH\u0016R$\u0010\u0002\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006I"}, d2={"Lorg/kamaeleo/graphics/AbstractIGraphics;", "Lorg/kamaeleo/graphics/IGraphics;", "callback", "Lorg/kamaeleo/graphics/ICallback;", "", "getCallback", "()Lorg/kamaeleo/graphics/ICallback;", "setCallback", "(Lorg/kamaeleo/graphics/ICallback;)V", "value", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "beginPick", "", "draw", "geometry", "Lorg/kamaeleo/geom/Shape;", "drawCircularString", "text", "", "centerX", "", "centerY", "radius", "startAngle", "extent", "drawPoint", "point", "Lorg/kamaeleo/geom/Point2D;", "drawRectange", "x", "", "y", "width", "height", "drawShape", "shape", "drawString", "endPick", "fill", "fillCircle", "rectangle", "Lorg/kamaeleo/geom/Rectangle2D;", "fillRectangle", "fillRectangle2D", "fillShape", "getAscent", "", "getDescent", "getFontMetrics", "Lorg/kamaeleo/font/CPFontMetrics;", "getStringBounds", "getStringHeight", "getStringWidth", "isThreadSafe", "", "pick", "T", "(Lorg/kamaeleo/geom/Shape;Lorg/kamaeleo/geom/Point2D;Ljava/lang/Object;Lorg/kamaeleo/graphics/ICallback;)V", "pickDraw", "pickFill", "setFont", "font", "Lorg/kamaeleo/font/CPFont;", "setLineDash", "dashPatern", "", "setTextBaseline", "baseline", "Lorg/kamaeleo/graphics/IGraphics$TextBaseline;", "Companion", "kamaeleo"})
@StabilityInferred(parameters=0)
public abstract class AbstractIGraphics
implements IGraphics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Object value;
    @Nullable
    private ICallback<Object> callback;
    public static final int $stable = 8;

    @Nullable
    protected final Object getValue() {
        return this.value;
    }

    protected final void setValue(@Nullable Object object) {
        this.value = object;
    }

    @Nullable
    protected final ICallback<Object> getCallback() {
        return this.callback;
    }

    protected final void setCallback(@Nullable ICallback<Object> iCallback) {
        this.callback = iCallback;
    }

    @Override
    public boolean isThreadSafe() {
        return false;
    }

    @Override
    public void setLineDash(@Nullable float[] dashPatern) {
        throw new UnsupportedOperationException();
    }

    public final void drawShape(@Nullable Shape shape) {
        this.draw(shape);
    }

    public void drawPoint(@Nullable Point2D point) {
    }

    public void fillCircle(@NotNull Rectangle2D rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        this.fill(new Ellipse2D.Double(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight()));
    }

    public void fillRectangle2D(@Nullable Rectangle2D rectangle) {
        this.fill(rectangle);
    }

    @Override
    public void fillRectangle(int x, int y, int width, int height) {
        this.fill(new Rectangle(x, y, width, height));
    }

    @Override
    public void drawRectange(int x, int y, int width, int height) {
        this.draw(new Rectangle(x, y, width, height));
    }

    public final void fillShape(@Nullable Shape shape) {
        this.fill(shape);
    }

    public final <T> void pickDraw(@NotNull Shape geometry, @Nullable Point2D point, T value, @NotNull ICallback<T> callback) {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.pick(geometry, point, value, callback);
        this.draw(geometry);
    }

    public final <T> void pickFill(@NotNull Shape geometry, @Nullable Point2D point, T value, @NotNull ICallback<T> callback) {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.pick(geometry, point, value, callback);
        this.fill(geometry);
    }

    private final <T> void pick(Shape geometry, Point2D point, T value, ICallback<T> callback) {
        if (point != null && geometry.contains(point)) {
            this.value = value;
            this.callback = callback;
        }
    }

    protected abstract void draw(@Nullable Shape var1);

    protected abstract void fill(@Nullable Shape var1);

    @Override
    public void beginPick() {
        this.value = null;
        this.callback = null;
    }

    @Override
    public void endPick() {
        if (this.callback != null) {
            ICallback<Object> iCallback = this.callback;
            Intrinsics.checkNotNull(iCallback);
            iCallback.callingBack(this.value);
        }
    }

    @Override
    public void setTextBaseline(@Nullable IGraphics.TextBaseline baseline) {
    }

    @Override
    public void setFont(@Nullable CPFont font) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public Rectangle2D getStringBounds(@Nullable String text) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public float getStringWidth(@Nullable String text) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public float getStringHeight(@Nullable String text) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void drawString(@Nullable String text, float x, float y) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void drawCircularString(@Nullable String text, float centerX, float centerY, float radius, float startAngle, float extent) {
        boolean clockwise = true;
        boolean inwardFacing = true;
        boolean kerning = false;
        this.translate((int)centerX, (int)centerY);
        double rotated = MathKt.convertDegreesToRadians((double)Companion.normalizeDegrees(startAngle));
        this.rotate(rotated);
        float textHeight = this.getStringHeight(text);
        Intrinsics.checkNotNull((Object)text);
        int n = text.length();
        int n2 = 0;
        int n3 = n + -1;
        if (n != Integer.MIN_VALUE && n2 <= n3) {
            do {
                int j = n2++;
                String string = String.valueOf(text.charAt(j));
                float charWidth = this.getStringWidth(string);
                float theta1 = charWidth / (float)2 / (radius - textHeight) * (float)clockwise;
                this.rotate(theta1);
                rotated += (double)theta1;
                this.drawString(string, 0.0f, 1.0f * (0.0f - radius + textHeight / (float)2));
                float theta2 = (charWidth / (float)2 + (float)kerning) / (radius - textHeight) * (float)clockwise;
                this.rotate(theta2);
                rotated += (double)theta2;
            } while (n2 <= n3);
        }
        this.rotate(-rotated);
        this.translate((int)(-centerX), (int)(-centerY));
    }

    @Override
    public double getAscent() {
        return 0.0;
    }

    @Override
    public double getDescent() {
        return 0.0;
    }

    @Override
    @Nullable
    public CPFontMetrics getFontMetrics() {
        String string = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0002\b\u0002J\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003J\u000e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003\u00a8\u0006\b"}, d2={"Lorg/kamaeleo/graphics/AbstractIGraphics$Companion;", "", "IEEEremainder", "", "f1", "f2", "normalizeDegrees", "angle", "kamaeleo"})
    public static final class Companion {
        private Companion() {
        }

        public final double normalizeDegrees(double angle) {
            double angle2 = angle;
            if (angle2 > 180.0) {
                if (angle2 <= 540.0) {
                    angle2 -= 360.0;
                } else if ((angle2 = this.IEEEremainder(angle2, 360.0)) == -180.0) {
                    angle2 = 180.0;
                }
            } else if (angle2 <= -180.0) {
                if (angle2 > -540.0) {
                    angle2 += 360.0;
                } else if ((angle2 = this.IEEEremainder(angle2, 360.0)) == -180.0) {
                    angle2 = 180.0;
                }
            }
            return angle2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public final double IEEEremainder(double f1, double f2) {
            double d;
            double d2 = f1 % f2;
            boolean bl = false;
            double r = Math.abs(d2);
            if (!MathKt.isNaN((double)r) && !(r == f2)) {
                boolean bl2 = false;
                if (!(r <= Math.abs(f2) / 2.0)) {
                    bl2 = false;
                    d = Math.signum(f1) * (r - f2);
                    return d;
                }
            }
            d = r;
            return d;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

