/*
 * Decompiled with CFR 0.152.
 */
package org.kamaeleo.palette;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamaeleo.color.CPColor;
import org.kamaeleo.palette.AbstractPalette;
import org.kamaeleo.palette.MutablePalette;
import org.kamaeleo.palette.Palette;
import org.kamaeleo.palette.PaletteListener;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u0000 +2\u00020\u00012\u00020\u0002:\u0001+B\u000e\b\u0016\u0012\n\u0010\u0003\u001a\u00020\u0004\"\u00020\u0005B\u0016\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\u0003\u001a\u00020\u0004\"\u00020\u0005B\u0016\b\u0016\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\"\u00020\tB\u001e\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\"\u00020\tB\u0010\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\t0\nB\u0016\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\t0\nJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u0018H\u0016J\u0010\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u0005H\u0016J\u0010\u0010(\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010)\u001a\u00020*H\u0016R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\t0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR(\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u00118V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u000b\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00188TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001a\u00a8\u0006,"}, d2={"Lorg/kamaeleo/palette/FixedPalette;", "Lorg/kamaeleo/palette/AbstractPalette;", "Lorg/kamaeleo/palette/MutablePalette;", "colors", "", "", "inverted", "", "", "Lorg/kamaeleo/color/CPColor;", "", "isInverted", "getColors", "()Ljava/util/List;", "setColors", "(Ljava/util/List;)V", "value", "Lorg/kamaeleo/palette/Palette$Cycle;", "cycle", "getCycle", "()Lorg/kamaeleo/palette/Palette$Cycle;", "setCycle", "(Lorg/kamaeleo/palette/Palette$Cycle;)V", "highestFraction", "", "getHighestFraction", "()D", "()Z", "setInverted", "(Z)V", "lowestFraction", "getLowestFraction", "addPaletteListener", "", "listener", "Lorg/kamaeleo/palette/PaletteListener;", "getColor", "fraction", "getColorAt", "index", "removePaletteListener", "toString", "", "Companion", "kamaeleo"})
@StabilityInferred(parameters=0)
public class FixedPalette
extends AbstractPalette
implements MutablePalette {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isInverted;
    @NotNull
    private List<CPColor> colors;
    public static final int $stable = 8;

    public FixedPalette(boolean isInverted, @NotNull List<CPColor> colors) {
        int n;
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        this.isInverted = isInverted;
        this.colors = colors;
        if (this.colors != null) {
            List<CPColor> list = this.colors;
            Intrinsics.checkNotNull(list);
            n = list.size();
        } else {
            n = 0;
        }
        this.setColorCount(n);
    }

    @Override
    public boolean isInverted() {
        return this.isInverted;
    }

    public void setInverted(boolean bl) {
        this.isInverted = bl;
    }

    @NotNull
    public final List<CPColor> getColors() {
        return this.colors;
    }

    public final void setColors(@NotNull List<CPColor> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.colors = list;
    }

    public FixedPalette(int ... colors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        int[] nArray = new int[colors.length];
        System.arraycopy(colors, 0, nArray, 0, colors.length);
        this(false, nArray);
    }

    public FixedPalette(boolean inverted, int ... colors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        this(false, FixedPalette.Companion.toCPColorList(colors));
    }

    public FixedPalette(CPColor ... colors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        this(false, ArraysKt.toMutableList((Object[])colors));
    }

    public FixedPalette(boolean inverted, CPColor ... colors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        this(inverted, ArraysKt.toMutableList((Object[])colors));
    }

    public FixedPalette(@NotNull List<CPColor> colors) {
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        this(false, colors);
    }

    @Override
    @NotNull
    public CPColor getColor(double fraction) {
        CPColor cPColor;
        double fraction2 = fraction;
        boolean inverted = this.isInverted();
        Palette.Cycle cycle = this.getCycle();
        int n = cycle == null ? -1 : WhenMappings.$EnumSwitchMapping$0[cycle.ordinal()];
        switch (n) {
            case 1: {
                inverted = (int)fraction2 % 2 == 0;
                fraction2 -= (double)((int)fraction2);
                break;
            }
            case 2: {
                fraction2 -= (double)((int)fraction2);
            }
        }
        if (fraction2 < this.getLowestFraction()) {
            cPColor = this.getColor(this.getLowestFraction());
        } else if (fraction2 > this.getHighestFraction()) {
            cPColor = this.getColor(this.getHighestFraction());
        } else {
            double d = !inverted ? fraction2 : 1.0 - fraction2;
            int n2 = this.getColorCount();
            List<CPColor> list = this.colors;
            Intrinsics.checkNotNull(list);
            int index = this.getEntry(d, n2, list.size());
            list = this.colors;
            Intrinsics.checkNotNull(list);
            cPColor = list.get(index);
        }
        return cPColor;
    }

    protected double getLowestFraction() {
        return 0.0;
    }

    protected double getHighestFraction() {
        return 1.0;
    }

    @Override
    @NotNull
    public CPColor getColorAt(int index) {
        CPColor cPColor;
        int n = this.getColorCount();
        List<CPColor> list = this.colors;
        Intrinsics.checkNotNull(list);
        if (n == list.size()) {
            if (index < 0) {
                cPColor = this.getColorAt(0);
            } else if (index > this.getColorCount() - 1) {
                cPColor = this.getColorAt(this.getColorCount() - 1);
            } else {
                list = this.colors;
                Intrinsics.checkNotNull(list);
                cPColor = list.get(index);
            }
        } else {
            cPColor = this.getColor((double)this.getColorCount() / (double)index);
        }
        return cPColor;
    }

    @Override
    public void addPaletteListener(@NotNull PaletteListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
    }

    @Override
    public void removePaletteListener(@NotNull PaletteListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
    }

    @Override
    @Nullable
    public Palette.Cycle getCycle() {
        return super.getCycle();
    }

    @Override
    public void setCycle(@Nullable Palette.Cycle value) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public String toString() {
        return "" + this.getColor(0.0) + '-' + this.getColor(1.0);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0002\b\u0002J\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/kamaeleo/palette/FixedPalette$Companion;", "", "toCPColorList", "", "Lorg/kamaeleo/color/CPColor;", "colors", "", "kamaeleo"})
    public static final class Companion {
        private Companion() {
        }

        private final List<CPColor> toCPColorList(int[] colors) {
            List list = new ArrayList(colors.length);
            for (int color : colors) {
                list.add(new CPColor(color));
            }
            return list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Palette.Cycle.values().length];
            nArray[Palette.Cycle.REFLECT.ordinal()] = 1;
            nArray[Palette.Cycle.REPEAT.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

