package org.kamaeleo.canvas

interface MouseMotionListener {
    /**
     * Invoked when a mouse button is pressed on a component and then
     * dragged.  `MOUSE_DRAGGED` events will continue to be
     * delivered to the component where the drag originated until the
     * mouse button is released (regardless of whether the mouse position
     * is within the bounds of the component).
     *
     *
     * Due to platform-dependent Drag&amp;Drop implementations,
     * `MOUSE_DRAGGED` events may not be delivered during a native
     * Drag&amp;Drop operation.
     */
    fun mouseDragged(event: MouseEvent)

    /**
     * Invoked when the mouse cursor has been moved onto a component
     * but no buttons have been pushed.
     */
    fun mouseMoved(event: MouseEvent)
}