package org.kamaeleo.geom.curve

/**
 * A ControlPath is a container of Point objects and Curve objects.  The control-path
 * uses arrays to store the points and curves.
 */
class ControlPath {
    private val curveBag: Bag = Bag()
    private val pointBag: Bag = Bag()

    /**
     * Adds a curve to the curve array at index location numCurves.
     */
    fun addCurve(c: Curve?) {
        curveBag.add(c)
    }

    /**
     * Adds a point to the point array at index location numPoints.
     */
    fun addPoint(p: Point?) {
        pointBag.add(p)
    }

    /**
     * Returns the curve at the specified index.
     */
    fun getCurve(index: Int): Curve? {
        return curveBag.get(index) as Curve
    }

    /**
     * Returns the point at the specified index.
     */
    fun getPoint(index: Int): Point? {
        return pointBag.get(index) as Point
    }

    /**
     * Returns the number of curves in the control-path.
     */
    fun numCurves(): Int {
        return curveBag.size()
    }

    /**
     * Returns the number of points in the control-path.
     */
    fun numPoints(): Int {
        return pointBag.size()
    }
}