package org.kamaeleo.geom.curve

import org.kamaeleo.geom.AffineTransform
import org.kamaeleo.geom.PathIterator

internal class ShapeMultiPathIterator(smp: ShapeMultiPath, at: AffineTransform?) : PathIterator {
    private val ai0: Int
    private val ai1: Int
    private val at: AffineTransform?
    private val smp: ShapeMultiPath
    override val windingRule: Int
    private var n = 0
    override val isDone: Boolean
        get() = n >= smp.numPoints

    override operator fun next() {
        n++
    }

    override fun currentSegment(coords: FloatArray): Int {
        val p: DoubleArray = smp.get(n)
        coords[0] = p[ai0].toFloat()
        coords[1] = p[ai1].toFloat()
        if (n > 0 && p == smp.get(0)) return PathIterator.SEG_CLOSE
        if (at != null) at.transform(coords, 0, coords, 0, 1)
        return if (smp.getType(n) === MultiPath.MOVE_TO) PathIterator.SEG_MOVETO else PathIterator.SEG_LINETO
    }

    override fun currentSegment(coords: DoubleArray): Int {
        val p: DoubleArray = smp.get(n)
        coords[0] = p[ai0]
        coords[1] = p[ai1]
        if (n > 0 && p == smp.get(0)) return PathIterator.SEG_CLOSE
        if (at != null) at.transform(coords, 0, coords, 0, 1)
        return if (smp.getType(n) === MultiPath.MOVE_TO) PathIterator.SEG_MOVETO else PathIterator.SEG_LINETO
    }

    init {
        this.smp = smp
        this.at = at
        val bv: IntArray = smp.basisVectors
        ai0 = bv[0]
        ai1 = bv[1]
        windingRule = smp.windingRule
    }
}