/*
 * Copyright (c) 2018 Macrofocus GmbH. All Rights Reserved.
 */
package org.kamaeleo.palette

import org.kamaeleo.color.CPColor

/**
 * Palette composed of a defined list of discrete colors.
 */
open class DynamicPalette : AbstractMutablePalette {
    protected var colors: MutableList<CPColor>
    override var isInverted = false

//    constructor(vararg colors: Int) : this(false, *colors) {
//    }
//
//    constructor(inverted: Boolean, vararg colors: Int) {
//        isInverted = inverted
//        this.colors = ArrayList<CPColor>(colors.size)
//        for (color in colors) {
//            this.colors.add(CPColorFactory.instance.createColor(color))
//        }
//        colorCount = this.colors.size
//    }

    constructor(vararg colors: CPColor) {
        this.colors = colors.toMutableList()
        colorCount = this.colors.size
    }

    constructor(inverted: Boolean, vararg colors: CPColor) {
        this.colors = colors.toMutableList()
        colorCount = this.colors.size
        isInverted = inverted
    }

    constructor(colors: List<CPColor>) {
        this.colors = colors.toMutableList()
        colorCount = this.colors!!.size
    }

    override fun getColor(fraction: Double): CPColor {
        var fraction = fraction
        var inverted = isInverted
        when (cycle) {
            Palette.Cycle.REFLECT -> {
                inverted = fraction.toInt() % 2 == 0
                fraction = fraction - fraction.toInt()
            }
            Palette.Cycle.REPEAT -> fraction = fraction - fraction.toInt()
        }
        return if (fraction < lowestFraction) {
            getColor(lowestFraction)
        } else if (fraction > highestFraction) {
            getColor(highestFraction)
        } else {
            val index: Int = getEntry(if (!inverted) fraction else 1 - fraction, colorCount, colors.size)
            colors!![index]
        }
    }

    protected open val lowestFraction: Double
        protected get() = 0.0
    protected open val highestFraction: Double
        protected get() = 1.0

    override fun getColorAt(index: Int): CPColor {
        return if (colorCount === colors!!.size) {
            if (index < 0) {
                getColorAt(0)
            } else if (index > colorCount - 1) {
                getColorAt(colorCount - 1)
            } else {
                colors!![index]
            }
        } else {
            getColor(colorCount / index.toDouble())
        }
    }
}