package org.kamaeleo.property

import kotlin.properties.ReadWriteProperty
import kotlin.reflect.KProperty

private class ObservableProperty<T>(initialValue: T) : ReadWriteProperty<Any?, T> {
    public val observers: MutableSet<(T) -> Unit> = LinkedHashSet()
    private var value = initialValue

    override fun getValue(thisRef: Any?, property: KProperty<*>): T {
        return value
    }

    override fun setValue(thisRef: Any?, property: KProperty<*>, value: T) {
        this.value = value
        observers.forEach { it(value) }
    }
}